/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.world;

import com.legacy.goodnightsleep.GNSRegistry;
import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.world.dream.GoodDreamDimension;
import com.legacy.goodnightsleep.world.nightmare.NightmareDimension;
import io.netty.buffer.Unpooled;
import java.util.function.BiFunction;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.registries.IForgeRegistry;

public class GNSDimensions {
    public static final ModDimension dreamDim = new ModDimension(){

        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return GoodDreamDimension::new;
        }
    };
    public static final ModDimension nightmareDim = new ModDimension(){

        public BiFunction<World, DimensionType, ? extends Dimension> getFactory() {
            return NightmareDimension::new;
        }
    };

    public static void initModDimensions(IForgeRegistry<ModDimension> registry) {
        GNSRegistry.register(registry, "good_dream", dreamDim);
        DimensionManager.registerDimension((ResourceLocation)GoodNightSleep.locate("good_dream"), (ModDimension)dreamDim, (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
        GNSRegistry.register(registry, "nightmare", nightmareDim);
        DimensionManager.registerDimension((ResourceLocation)GoodNightSleep.locate("nightmare"), (ModDimension)nightmareDim, (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
    }

    public static void initDimensions() {
        if (GNSDimensions.dimensionType(true) == null) {
            DimensionManager.registerDimension((ResourceLocation)GoodNightSleep.locate("good_dream"), (ModDimension)dreamDim, (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
        }
        if (GNSDimensions.dimensionType(false) == null) {
            DimensionManager.registerDimension((ResourceLocation)GoodNightSleep.locate("nightmare"), (ModDimension)nightmareDim, (PacketBuffer)new PacketBuffer(Unpooled.buffer()), (boolean)true);
        }
    }

    public static DimensionType dimensionType(boolean dream) {
        DimensionType dimension = dream ? DimensionType.func_193417_a((ResourceLocation)new ResourceLocation("good_nights_sleep", "good_dream")) : DimensionType.func_193417_a((ResourceLocation)new ResourceLocation("good_nights_sleep", "nightmare"));
        return dimension;
    }
}

