/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.world.dream.features;

import com.legacy.goodnightsleep.blocks.GNSBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class DreamTreeFeature
extends AbstractTreeFeature<TreeFeatureConfig> {
    private static final BlockState DEFAULT_TRUNK = GNSBlocks.dream_log.func_176223_P();
    private static final BlockState DEFAULT_LEAF = GNSBlocks.dream_leaves.func_176223_P();
    protected final int minTreeHeight;
    private final BlockState trunk;
    private final BlockState leaf;

    public DreamTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace) {
        this(configFactoryIn, doBlockNotifyOnPlace, 4, DEFAULT_TRUNK, DEFAULT_LEAF);
    }

    public DreamTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> configFactoryIn, boolean doBlockNotifyOnPlace, int minTreeHeightIn, BlockState trunkState, BlockState leafState) {
        super(configFactoryIn);
        this.minTreeHeight = minTreeHeightIn;
        this.trunk = trunkState;
        this.leaf = leafState;
    }

    protected boolean place(IWorldGenerationReader worldIn, Random rand, BlockPos position, Set<BlockPos> changedBlocks, Set<BlockPos> set2, MutableBoundingBox p_208519_5_, TreeFeatureConfig config) {
        int i = this.getHeight(rand);
        boolean flag = true;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 <= worldIn.getMaxHeight()) {
            for (int j = position.func_177956_o(); j <= position.func_177956_o() + 1 + i; ++j) {
                int k = 1;
                if (j == position.func_177956_o()) {
                    k = 0;
                }
                if (j >= position.func_177956_o() + 1 + i - 2) {
                    k = 2;
                }
                BlockPos.Mutable blockpos$mutableblockpos = new BlockPos.Mutable();
                for (int l = position.func_177958_n() - k; l <= position.func_177958_n() + k && flag; ++l) {
                    for (int i1 = position.func_177952_p() - k; i1 <= position.func_177952_p() + k && flag; ++i1) {
                        if (j >= 0 && j < worldIn.getMaxHeight()) {
                            if (DreamTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos$mutableblockpos.func_181079_c(l, j, i1))) continue;
                            flag = false;
                            continue;
                        }
                        flag = false;
                    }
                }
            }
            if (!flag) {
                return false;
            }
            if (DreamTreeFeature.isSoil((IWorldGenerationBaseReader)worldIn, position.func_177977_b(), (IPlantable)GNSBlocks.dream_sapling) && position.func_177956_o() < worldIn.getMaxHeight() - i - 1) {
                this.setDirtAt(worldIn, position.func_177977_b(), position);
                for (int l2 = position.func_177956_o() - 3 + i; l2 <= position.func_177956_o() + i; ++l2) {
                    int l3 = l2 - (position.func_177956_o() + i);
                    int j4 = 1 - l3 / 2;
                    for (int j1 = position.func_177958_n() - j4; j1 <= position.func_177958_n() + j4; ++j1) {
                        int k1 = j1 - position.func_177958_n();
                        for (int l1 = position.func_177952_p() - j4; l1 <= position.func_177952_p() + j4; ++l1) {
                            BlockPos blockpos;
                            int i2 = l1 - position.func_177952_p();
                            if (Math.abs(k1) == j4 && Math.abs(i2) == j4 && (rand.nextInt(2) == 0 || l3 == 0) || !DreamTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = new BlockPos(j1, l2, l1))) && !DreamTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)blockpos)) continue;
                            this.func_227217_a_((IWorldWriter)worldIn, blockpos, this.leaf, p_208519_5_);
                        }
                    }
                }
                for (int i3 = 0; i3 < i; ++i3) {
                    if (!DreamTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(i3)) && !DreamTreeFeature.func_214574_b((IWorldGenerationBaseReader)worldIn, (BlockPos)position.func_177981_b(i3))) continue;
                    this.func_227217_a_((IWorldWriter)worldIn, position.func_177981_b(i3), this.trunk, p_208519_5_);
                    changedBlocks.add(position.func_177981_b(i3).func_185334_h());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    protected int getHeight(Random random) {
        return this.minTreeHeight + random.nextInt(3);
    }

    protected static boolean func_214587_a(IWorldGenerationBaseReader p_214587_0_, BlockPos p_214587_1_) {
        if (!(p_214587_0_ instanceof IWorldReader)) {
            return p_214587_0_.func_217375_a(p_214587_1_, p_214573_0_ -> {
                Block block = p_214573_0_.func_177230_c();
                return p_214573_0_.func_196958_f() || p_214573_0_.func_203425_a(BlockTags.field_206952_E) || block == GNSBlocks.dream_grass_block || block == GNSBlocks.nightmare_grass_block || block == GNSBlocks.nightmare_grass_block || block == Blocks.field_196658_i || block == Blocks.field_150346_d || block.func_203417_a(BlockTags.field_200031_h) || block.func_203417_a(BlockTags.field_200030_g) || block == Blocks.field_150395_bd;
            });
        }
        return p_214587_0_.func_217375_a(p_214587_1_, state -> state.canBeReplacedByLogs((IWorldReader)p_214587_0_, p_214587_1_));
    }

    protected static boolean isSoil(IWorldGenerationBaseReader reader, BlockPos pos, IPlantable sapling) {
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, sapling));
    }

    public static boolean isDirtOrGrassBlock(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214582_0_ -> {
            Block block = p_214582_0_.func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == GNSBlocks.dream_grass_block || block == GNSBlocks.dream_dirt || block == GNSBlocks.nightmare_grass_block;
        });
    }
}

