/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.world.dream.features;

import com.google.common.collect.Lists;
import com.legacy.goodnightsleep.blocks.GNSBlocks;
import com.mojang.datafixers.Dynamic;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LogBlock;
import net.minecraft.state.IProperty;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.IWorldGenerationBaseReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraftforge.common.IPlantable;

public class GNSBigTreeFeature
extends AbstractTreeFeature<TreeFeatureConfig> {
    private BlockState OAK_LOG;
    private BlockState OAK_LEAVES;

    public GNSBigTreeFeature(Function<Dynamic<?>, ? extends TreeFeatureConfig> configFactoryIn, boolean doBlockNotifyIn, BlockState log, BlockState leaves) {
        super(configFactoryIn);
        this.OAK_LEAVES = leaves;
        this.OAK_LOG = log;
    }

    private void crossSection(IWorldGenerationReader worldIn, BlockPos pos, float p_208529_3_, MutableBoundingBox p_208529_4_, Set<BlockPos> set1) {
        int i = (int)((double)p_208529_3_ + 0.618);
        for (int j = -i; j <= i; ++j) {
            for (int k = -i; k <= i; ++k) {
                BlockPos blockpos;
                if (!(Math.pow((double)Math.abs(j) + 0.5, 2.0) + Math.pow((double)Math.abs(k) + 0.5, 2.0) <= (double)(p_208529_3_ * p_208529_3_)) || !GNSBigTreeFeature.func_214572_g((IWorldGenerationBaseReader)worldIn, (BlockPos)(blockpos = pos.func_177982_a(j, 0, k)))) continue;
                this.func_227217_a_((IWorldWriter)worldIn, blockpos, this.OAK_LEAVES, p_208529_4_);
            }
        }
    }

    private float treeShape(int p_208527_1_, int p_208527_2_) {
        if ((float)p_208527_2_ < (float)p_208527_1_ * 0.3f) {
            return -1.0f;
        }
        float f = (float)p_208527_1_ / 2.0f;
        float f1 = f - (float)p_208527_2_;
        float f2 = MathHelper.func_76129_c((float)(f * f - f1 * f1));
        if (f1 == 0.0f) {
            f2 = f;
        } else if (Math.abs(f1) >= f) {
            return 0.0f;
        }
        return f2 * 0.5f;
    }

    private float foliageShape(int y) {
        if (y >= 0 && y < 5) {
            return y != 0 && y != 4 ? 3.0f : 2.0f;
        }
        return -1.0f;
    }

    private void foliageCluster(IWorldGenerationReader worldIn, BlockPos pos, MutableBoundingBox p_202393_3_, Set<BlockPos> set1) {
        for (int i = 0; i < 5; ++i) {
            this.crossSection(worldIn, pos.func_177981_b(i), this.foliageShape(i), p_202393_3_, set1);
        }
    }

    private int makeLimb(Set<BlockPos> p_208523_1_, IWorldGenerationReader worldIn, BlockPos p_208523_3_, BlockPos p_208523_4_, boolean p_208523_5_, MutableBoundingBox p_208523_6_) {
        if (!p_208523_5_ && Objects.equals(p_208523_3_, p_208523_4_)) {
            return -1;
        }
        BlockPos blockpos = p_208523_4_.func_177982_a(-p_208523_3_.func_177958_n(), -p_208523_3_.func_177956_o(), -p_208523_3_.func_177952_p());
        int i = this.getGreatestDistance(blockpos);
        float f = (float)blockpos.func_177958_n() / (float)i;
        float f1 = (float)blockpos.func_177956_o() / (float)i;
        float f2 = (float)blockpos.func_177952_p() / (float)i;
        for (int j = 0; j <= i; ++j) {
            BlockPos blockpos1 = p_208523_3_.func_177963_a((double)(0.5f + (float)j * f), (double)(0.5f + (float)j * f1), (double)(0.5f + (float)j * f2));
            if (p_208523_5_) {
                this.func_227217_a_((IWorldWriter)worldIn, blockpos1, (BlockState)this.OAK_LOG.func_206870_a((IProperty)LogBlock.field_176298_M, (Comparable)this.getLoxAxis(p_208523_3_, blockpos1)), p_208523_6_);
                continue;
            }
            if (GNSBigTreeFeature.func_214587_a((IWorldGenerationBaseReader)worldIn, blockpos1)) continue;
            return j;
        }
        return -1;
    }

    private int getGreatestDistance(BlockPos posIn) {
        int i = MathHelper.func_76130_a((int)posIn.func_177958_n());
        int j = MathHelper.func_76130_a((int)posIn.func_177956_o());
        int k = MathHelper.func_76130_a((int)posIn.func_177952_p());
        if (k > i && k > j) {
            return k;
        }
        return j > i ? j : i;
    }

    private Direction.Axis getLoxAxis(BlockPos p_197170_1_, BlockPos p_197170_2_) {
        int j;
        Direction.Axis direction$axis = Direction.Axis.Y;
        int i = Math.abs(p_197170_2_.func_177958_n() - p_197170_1_.func_177958_n());
        int k = Math.max(i, j = Math.abs(p_197170_2_.func_177952_p() - p_197170_1_.func_177952_p()));
        if (k > 0) {
            if (i == k) {
                direction$axis = Direction.Axis.X;
            } else if (j == k) {
                direction$axis = Direction.Axis.Z;
            }
        }
        return direction$axis;
    }

    private void makeFoliage(IWorldGenerationReader worldIn, int p_208525_2_, BlockPos pos, List<FoliageCoordinates> p_208525_4_, MutableBoundingBox p_208525_5_, Set<BlockPos> set1) {
        for (FoliageCoordinates bigtreefeature$foliagecoordinates : p_208525_4_) {
            if (!this.trimBranches(p_208525_2_, bigtreefeature$foliagecoordinates.getBranchBase() - pos.func_177956_o())) continue;
            this.foliageCluster(worldIn, bigtreefeature$foliagecoordinates, p_208525_5_, set1);
        }
    }

    private boolean trimBranches(int p_208522_1_, int p_208522_2_) {
        return (double)p_208522_2_ >= (double)p_208522_1_ * 0.2;
    }

    private void makeTrunk(Set<BlockPos> p_208526_1_, IWorldGenerationReader p_208526_2_, BlockPos p_208526_3_, int p_208526_4_, MutableBoundingBox p_208526_5_) {
        this.makeLimb(p_208526_1_, p_208526_2_, p_208526_3_, p_208526_3_.func_177981_b(p_208526_4_), true, p_208526_5_);
    }

    private void makeBranches(Set<BlockPos> p_208524_1_, IWorldGenerationReader p_208524_2_, int p_208524_3_, BlockPos p_208524_4_, List<FoliageCoordinates> p_208524_5_, MutableBoundingBox p_208524_6_) {
        for (FoliageCoordinates bigtreefeature$foliagecoordinates : p_208524_5_) {
            int i = bigtreefeature$foliagecoordinates.getBranchBase();
            BlockPos blockpos = new BlockPos(p_208524_4_.func_177958_n(), i, p_208524_4_.func_177952_p());
            if (blockpos.equals((Object)bigtreefeature$foliagecoordinates) || !this.trimBranches(p_208524_3_, i - p_208524_4_.func_177956_o())) continue;
            this.makeLimb(p_208524_1_, p_208524_2_, blockpos, bigtreefeature$foliagecoordinates, true, p_208524_6_);
        }
    }

    protected boolean place(IWorldGenerationReader worldIn, Random rand, BlockPos position, Set<BlockPos> set1, Set<BlockPos> set2, MutableBoundingBox box, TreeFeatureConfig config) {
        int i1;
        int k;
        Random random = new Random(rand.nextLong());
        int i = this.checkLocation(set1, worldIn, position, 5 + random.nextInt(12), box);
        if (i == -1) {
            return false;
        }
        this.setDirtAt(worldIn, position.func_177977_b(), position);
        int j = (int)((double)i * 0.618);
        if (j >= i) {
            j = i - 1;
        }
        if ((k = (int)(1.382 + Math.pow(1.0 * (double)i / 13.0, 2.0))) < 1) {
            k = 1;
        }
        int l = position.func_177956_o() + j;
        ArrayList list = Lists.newArrayList();
        list.add(new FoliageCoordinates(position.func_177981_b(i1), l));
        for (i1 = i - 5; i1 >= 0; --i1) {
            float f = this.treeShape(i, i1);
            if (f < 0.0f) continue;
            for (int j1 = 0; j1 < k; ++j1) {
                BlockPos blockpos1;
                double d5;
                double d3;
                double d2 = 1.0 * (double)f * ((double)random.nextFloat() + 0.328);
                double d4 = d2 * Math.sin(d3 = (double)(random.nextFloat() * 2.0f) * Math.PI) + 0.5;
                BlockPos blockpos = position.func_177963_a(d4, (double)(i1 - 1), d5 = d2 * Math.cos(d3) + 0.5);
                if (this.makeLimb(set1, worldIn, blockpos, blockpos1 = blockpos.func_177981_b(5), false, box) != -1) continue;
                int k1 = position.func_177958_n() - blockpos.func_177958_n();
                int l1 = position.func_177952_p() - blockpos.func_177952_p();
                double d6 = (double)blockpos.func_177956_o() - Math.sqrt(k1 * k1 + l1 * l1) * 0.381;
                int i2 = d6 > (double)l ? l : (int)d6;
                BlockPos blockpos2 = new BlockPos(position.func_177958_n(), i2, position.func_177952_p());
                if (this.makeLimb(set1, worldIn, blockpos2, blockpos, false, box) != -1) continue;
                list.add(new FoliageCoordinates(blockpos, blockpos2.func_177956_o()));
            }
        }
        this.makeFoliage(worldIn, i, position, list, box, set1);
        this.makeTrunk(set1, worldIn, position, j, box);
        this.makeBranches(set1, worldIn, i, position, list, box);
        return true;
    }

    private int checkLocation(Set<BlockPos> p_208528_1_, IWorldGenerationReader p_208528_2_, BlockPos p_208528_3_, int p_208528_4_, MutableBoundingBox p_208528_5_) {
        if (!GNSBigTreeFeature.isSoil((IWorldGenerationBaseReader)p_208528_2_, p_208528_3_.func_177977_b(), (IPlantable)GNSBlocks.dream_sapling)) {
            return -1;
        }
        int i = this.makeLimb(p_208528_1_, p_208528_2_, p_208528_3_, p_208528_3_.func_177981_b(p_208528_4_ - 1), false, p_208528_5_);
        if (i == -1) {
            return p_208528_4_;
        }
        return i < 6 ? -1 : i;
    }

    protected static boolean func_214587_a(IWorldGenerationBaseReader p_214587_0_, BlockPos p_214587_1_) {
        if (!(p_214587_0_ instanceof IWorldReader)) {
            return p_214587_0_.func_217375_a(p_214587_1_, p_214573_0_ -> {
                Block block = p_214573_0_.func_177230_c();
                return p_214573_0_.func_196958_f() || p_214573_0_.func_203425_a(BlockTags.field_206952_E) || block == GNSBlocks.dream_grass_block || block == GNSBlocks.nightmare_grass_block || block == GNSBlocks.nightmare_grass_block || block == Blocks.field_150346_d || block == Blocks.field_196658_i || block.func_203417_a(BlockTags.field_200031_h) || block.func_203417_a(BlockTags.field_200030_g) || block == Blocks.field_150395_bd;
            });
        }
        return p_214587_0_.func_217375_a(p_214587_1_, state -> state.canBeReplacedByLogs((IWorldReader)p_214587_0_, p_214587_1_));
    }

    protected static boolean isSoil(IWorldGenerationBaseReader reader, BlockPos pos, IPlantable sapling) {
        if (!(reader instanceof IBlockReader) || sapling == null) {
            return GNSBigTreeFeature.isDirtOrGrassBlock(reader, pos);
        }
        return reader.func_217375_a(pos, state -> state.canSustainPlant((IBlockReader)reader, pos, Direction.UP, sapling));
    }

    public static boolean isDirtOrGrassBlock(IWorldGenerationBaseReader worldIn, BlockPos pos) {
        return worldIn.func_217375_a(pos, p_214582_0_ -> {
            Block block = p_214582_0_.func_177230_c();
            return block == Blocks.field_196658_i || block == Blocks.field_150346_d || block == GNSBlocks.dream_grass_block || block == GNSBlocks.dream_dirt || block == GNSBlocks.nightmare_grass_block;
        });
    }

    static class FoliageCoordinates
    extends BlockPos {
        private final int branchBase;

        public FoliageCoordinates(BlockPos pos, int p_i45635_2_) {
            super(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            this.branchBase = p_i45635_2_;
        }

        public int getBranchBase() {
            return this.branchBase;
        }
    }
}

