/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.world.general_features;

import com.legacy.goodnightsleep.GNSRegistry;
import com.legacy.goodnightsleep.blocks.GNSBlocks;
import com.legacy.goodnightsleep.world.BaseGNSBiome;
import com.legacy.goodnightsleep.world.dream.features.BigHopeMushroomFeature;
import com.legacy.goodnightsleep.world.dream.features.DreamOreFeature;
import com.legacy.goodnightsleep.world.dream.features.DreamOreFeatureConfig;
import com.legacy.goodnightsleep.world.dream.features.DreamSpongeFeature;
import com.legacy.goodnightsleep.world.dream.features.DreamTreeFeature;
import com.legacy.goodnightsleep.world.dream.features.GNSBigTreeFeature;
import com.legacy.goodnightsleep.world.general_features.DreamScatteredPlantFeature;
import com.legacy.goodnightsleep.world.nightmare.features.BigDespairMushroomFeature;
import com.legacy.goodnightsleep.world.nightmare.features.NetherSplashFeature;
import net.minecraft.block.Blocks;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.DefaultBiomeFeatures;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.feature.AbstractTreeFeature;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.TreeFeatureConfig;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.ChanceRangeConfig;
import net.minecraft.world.gen.placement.CountRangeConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.FrequencyConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="good_nights_sleep")
public class GNSFeatures {
    public static final AbstractTreeFeature<TreeFeatureConfig> DREAM_TREE = new DreamTreeFeature(TreeFeatureConfig::func_227338_a_, false);
    public static final AbstractTreeFeature<TreeFeatureConfig> CANDY_TREE = new DreamTreeFeature(TreeFeatureConfig::func_227338_a_, false, 5, GNSBlocks.white_log.func_176223_P(), GNSBlocks.candy_leaves.func_176223_P());
    public static final AbstractTreeFeature<TreeFeatureConfig> DIAMOND_TREE = new GNSBigTreeFeature(TreeFeatureConfig::func_227338_a_, false, GNSBlocks.dream_log.func_176223_P(), GNSBlocks.diamond_leaves.func_176223_P());
    public static final AbstractTreeFeature<TreeFeatureConfig> DEAD_TREE = new GNSBigTreeFeature(TreeFeatureConfig::func_227338_a_, false, GNSBlocks.dead_log.func_176223_P(), Blocks.field_150350_a.func_176223_P());
    public static final AbstractTreeFeature<TreeFeatureConfig> BLOOD_TREE = new DreamTreeFeature(TreeFeatureConfig::func_227338_a_, false, 5, GNSBlocks.blood_log.func_176223_P(), Blocks.field_150350_a.func_176223_P());
    public static final Feature<NoFeatureConfig> DREAM_SPONGE = new DreamSpongeFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> BIG_HOPE_MUSHROOM = new BigHopeMushroomFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> SCATTERED_PRESENTS = new DreamScatteredPlantFeature(NoFeatureConfig::func_214639_a, GNSBlocks.present.func_176223_P());
    public static final Feature<DreamOreFeatureConfig> DREAM_ORES = new DreamOreFeature(DreamOreFeatureConfig::deserialize);
    public static final Feature<NoFeatureConfig> NETHER_SPLASH = new NetherSplashFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> BIG_DESPAIR_MUSHROOM = new BigDespairMushroomFeature(NoFeatureConfig::func_214639_a);
    public static final Feature<NoFeatureConfig> SCATTERED_PUMPKINS = new DreamScatteredPlantFeature(NoFeatureConfig::func_214639_a, Blocks.field_150423_aK.func_176223_P());

    public static void init(RegistryEvent.Register<Feature<?>> event) {
        GNSRegistry.register(event.getRegistry(), "dream_tree", DREAM_TREE);
        GNSRegistry.register(event.getRegistry(), "candy_tree", CANDY_TREE);
        GNSRegistry.register(event.getRegistry(), "diamond_tree", DIAMOND_TREE);
        GNSRegistry.register(event.getRegistry(), "dead_tree", DEAD_TREE);
        GNSRegistry.register(event.getRegistry(), "blood_tree", BLOOD_TREE);
        GNSRegistry.register(event.getRegistry(), "dream_sponge", DREAM_SPONGE);
        GNSRegistry.register(event.getRegistry(), "big_hope_mushroom", BIG_HOPE_MUSHROOM);
        GNSRegistry.register(event.getRegistry(), "scattered_presents", SCATTERED_PRESENTS);
        GNSRegistry.register(event.getRegistry(), "dream_ores", DREAM_ORES);
        GNSRegistry.register(event.getRegistry(), "nether_splash", NETHER_SPLASH);
        GNSRegistry.register(event.getRegistry(), "big_despair_mushroom", BIG_DESPAIR_MUSHROOM);
        GNSRegistry.register(event.getRegistry(), "scattered_pumpkins", SCATTERED_PUMPKINS);
    }

    public static void addDreamOres(BaseGNSBiome biomeIn, OreFeatureConfig.FillerBlockType delusionConfig) {
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.dream_dirt.func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 256))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.coal_ore.func_176223_P(), 17)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 0, 0, 128))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.candy_ore.func_176223_P(), 15)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 0, 0, 128))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.rainbow_ore.func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 0, 0, 64))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.positite_ore.func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 0, 0, 16))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.lapis_ore.func_176223_P(), 7)).func_227228_a_(Placement.field_215035_u.func_227446_a_((IPlacementConfig)new DepthAverageConfig(1, 16, 16))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, Blocks.field_150426_aN.func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 0, 0, 7))));
    }

    public static void addDreamTrees(BaseGNSBiome biomeIn) {
        biomeIn.addDreamFeature(GenerationStage.Decoration.VEGETAL_DECORATION, DREAM_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.VEGETAL_DECORATION, CANDY_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.VEGETAL_DECORATION, DIAMOND_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.2f, 1))));
    }

    public static void addScatteredDreamFeatures(BaseGNSBiome biomeIn) {
        biomeIn.addDreamFeature(GenerationStage.Decoration.RAW_GENERATION, DREAM_SPONGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(20))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.VEGETAL_DECORATION, BIG_HOPE_MUSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.3f, 1))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.VEGETAL_DECORATION, SCATTERED_PRESENTS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(32))));
    }

    public static void addNightmareOres(BaseGNSBiome biomeIn) {
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150346_d.func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(10, 0, 0, 256))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150351_n.func_176223_P(), 33)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(8, 0, 0, 256))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150365_q.func_176223_P(), 17)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 0, 0, 128))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, GNSBlocks.necrum_ore.func_176223_P(), 15)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 0, 0, 128))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150366_p.func_176223_P(), 9)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(20, 0, 0, 64))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, GNSBlocks.zitrite_ore.func_176223_P(), 8)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(5, 0, 0, 32))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, GNSBlocks.negatite_ore.func_176223_P(), 5)).func_227228_a_(Placement.field_215028_n.func_227446_a_((IPlacementConfig)new CountRangeConfig(1, 0, 0, 16))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.UNDERGROUND_ORES, Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.NATURAL_STONE, Blocks.field_150369_x.func_176223_P(), 7)).func_227228_a_(Placement.field_215035_u.func_227446_a_((IPlacementConfig)new DepthAverageConfig(1, 16, 16))));
    }

    public static void addNightmareTrees(BaseGNSBiome biomeIn) {
        biomeIn.addDreamFeature(GenerationStage.Decoration.VEGETAL_DECORATION, DEAD_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 1))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.VEGETAL_DECORATION, BLOOD_TREE.func_225566_b_((IFeatureConfig)DefaultBiomeFeatures.field_226739_a_).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
    }

    public static void addScatteredNightmareFeatures(BaseGNSBiome biomeIn) {
        biomeIn.addDreamFeature(GenerationStage.Decoration.RAW_GENERATION, NETHER_SPLASH.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215017_c.func_227446_a_((IPlacementConfig)new FrequencyConfig(20))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.VEGETAL_DECORATION, BIG_DESPAIR_MUSHROOM.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215027_m.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
        biomeIn.addDreamFeature(GenerationStage.Decoration.VEGETAL_DECORATION, SCATTERED_PUMPKINS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(10))));
    }

    public static void addMushrooms(Biome biomeIn) {
        BlockClusterFeatureConfig HOPE_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.hope_mushroom.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        BlockClusterFeatureConfig DESPAIR_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.despair_mushroom.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
        if (BiomeDictionary.hasType((Biome)biomeIn, (BiomeDictionary.Type)BiomeDictionary.Type.NETHER)) {
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)HOPE_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215032_r.func_227446_a_((IPlacementConfig)new ChanceRangeConfig(0.3f, 0, 0, 128))));
            biomeIn.func_203611_a(GenerationStage.Decoration.UNDERGROUND_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DESPAIR_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215032_r.func_227446_a_((IPlacementConfig)new ChanceRangeConfig(0.3f, 0, 0, 128))));
        } else {
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)HOPE_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(8))));
            biomeIn.func_203611_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DESPAIR_MUSHROOM_CONFIG).func_227228_a_(Placement.field_215024_j.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
        }
    }
}

