/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.world.nightmare;

import com.legacy.goodnightsleep.GNSConfig;
import com.legacy.goodnightsleep.world.GNSBiomes;
import com.legacy.goodnightsleep.world.GNSDimensions;
import com.legacy.goodnightsleep.world.GNSTeleportationUtil;
import java.util.ArrayList;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.provider.BiomeProviderType;
import net.minecraft.world.biome.provider.IBiomeProviderSettings;
import net.minecraft.world.biome.provider.SingleBiomeProviderSettings;
import net.minecraft.world.dimension.Dimension;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.ChunkGeneratorType;
import net.minecraft.world.gen.GenerationSettings;
import net.minecraft.world.gen.OverworldGenSettings;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeDimension;

public class NightmareDimension
extends Dimension
implements IForgeDimension {
    public ArrayList<ServerPlayerEntity> nightmarePlayerList = new ArrayList();

    public NightmareDimension(World world, DimensionType type) {
        super(world, type, 0.0f);
    }

    public ChunkGenerator<?> func_186060_c() {
        OverworldGenSettings genSettings = (OverworldGenSettings)ChunkGeneratorType.field_206911_b.func_205483_a();
        genSettings.func_214969_a(Blocks.field_150348_b.func_176223_P());
        genSettings.func_214970_b(Blocks.field_150353_l.func_176223_P());
        return ChunkGeneratorType.field_206911_b.create(this.field_76579_a, BiomeProviderType.field_205461_c.func_205457_a((IBiomeProviderSettings)((SingleBiomeProviderSettings)BiomeProviderType.field_205461_c.func_226840_a_(this.field_76579_a.func_72912_H())).func_205436_a(GNSBiomes.NIGHTMARE_HILLS)), (GenerationSettings)genSettings);
    }

    public boolean func_76567_e() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_76568_b(int x, int z) {
        return true;
    }

    public float getCurrentMoonPhaseFactor(long time) {
        return 2.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public String getWelcomeMessage() {
        return "You dream of horrible things...";
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getStarBrightness(float brightness) {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float func_76571_f() {
        return 150.0f;
    }

    public DimensionType func_186058_p() {
        return GNSDimensions.dimensionType(false);
    }

    public BlockPos func_206920_a(ChunkPos p_206920_1_, boolean checkValid) {
        return null;
    }

    public BlockPos func_206921_a(int p_206921_1_, int p_206921_2_, boolean checkValid) {
        return null;
    }

    public boolean func_76569_d() {
        return true;
    }

    public float func_76563_a(long worldTime, float partialTicks) {
        if (!GNSConfig.disableTimePassing) {
            int j = (int)(worldTime % 48000L);
            float f1 = ((float)j + partialTicks) / 48000.0f - 0.25f;
            if (f1 < 0.0f) {
                f1 += 1.0f;
            }
            if (f1 > 1.0f) {
                f1 -= 1.0f;
            }
            float f2 = f1;
            f1 = 1.0f - (float)((Math.cos((double)f1 * Math.PI) + 1.0) / 2.0);
            f1 = f2 + (f1 - f2) / 3.0f;
            f1 += 0.5f;
            if (worldTime > 25000L) {
                ServerPlayerEntity playerMP;
                for (Object i : this.field_76579_a.func_217369_A()) {
                    if (!(i instanceof ServerPlayerEntity)) continue;
                    playerMP = (ServerPlayerEntity)i;
                    if (playerMP.field_71093_bK != GNSDimensions.dimensionType(false)) continue;
                    this.nightmarePlayerList.add(playerMP);
                }
                for (int var14 = 0; var14 < this.nightmarePlayerList.size(); ++var14) {
                    playerMP = this.nightmarePlayerList.get(var14);
                    BlockPos pos = playerMP.getBedLocation(DimensionType.field_223227_a_) != null ? playerMP.getBedLocation(DimensionType.field_223227_a_) : playerMP.field_70170_p.func_175694_M();
                    GNSTeleportationUtil.changeDimension(DimensionType.field_223227_a_, (Entity)playerMP, pos);
                }
            }
            return f1;
        }
        return 0.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3d func_76562_b(float celestialAngle, float partialTicks) {
        return new Vec3d(0.1, 0.0, 0.0);
    }

    public boolean func_191066_m() {
        return true;
    }

    public IForgeDimension.SleepResult canSleepAt(PlayerEntity player, BlockPos pos) {
        return IForgeDimension.SleepResult.DENY;
    }
}

