/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep;

import com.legacy.goodnightsleep.GNSConfig;
import com.legacy.goodnightsleep.blocks.util.ToolCompat;
import com.legacy.goodnightsleep.capabillity.DreamPlayer;
import com.legacy.goodnightsleep.capabillity.util.CapabilityStorage;
import com.legacy.goodnightsleep.capabillity.util.IDreamPlayer;
import com.legacy.goodnightsleep.client.GNSBlockColoring;
import com.legacy.goodnightsleep.client.GNSClientEvents;
import com.legacy.goodnightsleep.client.audio.GNSMusicHandler;
import com.legacy.goodnightsleep.client.render.GNSEntityRendering;
import com.legacy.goodnightsleep.client.render.GNSTileEntityRendering;
import com.legacy.goodnightsleep.client.resource_pack.GNSResourcePackHandler;
import com.legacy.goodnightsleep.data.GNSBlockTags;
import com.legacy.goodnightsleep.data.GNSItemTags;
import com.legacy.goodnightsleep.data.GNSMappingChanges;
import com.legacy.goodnightsleep.event.GNSEvents;
import com.legacy.goodnightsleep.event.GNSPlayerEvents;
import com.legacy.goodnightsleep.network.PacketHandler;
import com.legacy.goodnightsleep.registry.GNSBlocks;
import com.legacy.goodnightsleep.registry.GNSFeatures;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="good_nights_sleep")
public class GoodNightSleep {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String NAME = "Good Night's Sleep";
    public static final String MODID = "good_nights_sleep";
    public static final String OLD_MODID = "goodnightsleep";

    public static ResourceLocation locate(String name) {
        return new ResourceLocation(MODID, name);
    }

    public static ResourceLocation locateOld(String name) {
        return new ResourceLocation(OLD_MODID, name);
    }

    public static String find(String name) {
        return "good_nights_sleep:" + name;
    }

    public GoodNightSleep() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, GNSConfig.SERVER_SPEC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonInit);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientInit));
    }

    private void commonInit(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IDreamPlayer.class, (Capability.IStorage)new CapabilityStorage(), DreamPlayer::new);
        MinecraftForge.EVENT_BUS.addListener(biomeEvent -> GNSFeatures.addMushrooms(biomeEvent));
        MinecraftForge.EVENT_BUS.register((Object)new GNSMappingChanges());
        MinecraftForge.EVENT_BUS.register((Object)new GNSEvents());
        MinecraftForge.EVENT_BUS.register((Object)new GNSPlayerEvents());
        PacketHandler.register();
        ToolCompat.init();
        GNSBlockTags.init();
        GNSItemTags.init();
    }

    public void clientInit(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new GNSMusicHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GNSClientEvents());
        GNSTileEntityRendering.init();
        GNSEntityRendering.init();
        GNSResourcePackHandler.init();
        GNSBlockColoring.init();
        GNSClientEvents.initDimensionRenderInfo();
        GoodNightSleep.renderCutout(GNSBlocks.candy_sapling);
        GoodNightSleep.renderCutout(GNSBlocks.dream_sapling);
        GoodNightSleep.renderCutout(GNSBlocks.cyan_flower);
        GoodNightSleep.renderCutout(GNSBlocks.dead_flower);
        GoodNightSleep.renderCutout(GNSBlocks.orange_flower);
        GoodNightSleep.renderCutout(GNSBlocks.lolipop_bush);
        GoodNightSleep.renderCutout(GNSBlocks.dream_grass);
        GoodNightSleep.renderCutout(GNSBlocks.nightmare_grass);
        GoodNightSleep.renderCutout(GNSBlocks.prickly_nightmare_grass);
        GoodNightSleep.renderCutout(GNSBlocks.hope_mushroom);
        GoodNightSleep.renderCutout(GNSBlocks.despair_mushroom);
        GoodNightSleep.renderCutout(GNSBlocks.rainbow_berries);
        GoodNightSleep.renderCutout(GNSBlocks.potted_candy_sapling);
        GoodNightSleep.renderCutout(GNSBlocks.potted_dream_sapling);
        GoodNightSleep.renderCutout(GNSBlocks.potted_cyan_flower);
        GoodNightSleep.renderCutout(GNSBlocks.potted_dead_flower);
        GoodNightSleep.renderCutout(GNSBlocks.potted_orange_flower);
        GoodNightSleep.renderCutout(GNSBlocks.potted_hope_mushroom);
        GoodNightSleep.renderCutout(GNSBlocks.potted_despair_mushroom);
        GoodNightSleep.renderCutout(GNSBlocks.dream_door);
        GoodNightSleep.renderCutout(GNSBlocks.white_door);
        GoodNightSleep.renderCutout(GNSBlocks.dead_door);
        GoodNightSleep.renderCutout(GNSBlocks.blood_door);
        GoodNightSleep.renderCutout(GNSBlocks.dream_trapdoor);
        GoodNightSleep.renderCutout(GNSBlocks.white_trapdoor);
        GoodNightSleep.renderCutout(GNSBlocks.dead_trapdoor);
        GoodNightSleep.renderCutout(GNSBlocks.blood_trapdoor);
        RenderTypeLookup.setRenderLayer((Block)GNSBlocks.dream_grass_block, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)GNSBlocks.rainbow, (RenderType)RenderType.func_228645_f_());
        RenderTypeLookup.setRenderLayer((Block)GNSBlocks.dream_leaves, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)GNSBlocks.candy_leaves, (RenderType)RenderType.func_228641_d_());
        RenderTypeLookup.setRenderLayer((Block)GNSBlocks.diamond_leaves, (RenderType)RenderType.func_228641_d_());
    }

    private static void renderCutout(Block block) {
        RenderTypeLookup.setRenderLayer((Block)block, (RenderType)RenderType.func_228643_e_());
    }
}

