/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.data;

import com.google.common.collect.ImmutableList;
import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.blocks.GNSBedBlock;
import com.legacy.goodnightsleep.blocks.natural.GNSRainbowCropBlock;
import com.legacy.goodnightsleep.registry.GNSBlocks;
import com.legacy.goodnightsleep.registry.GNSEntityTypes;
import com.legacy.goodnightsleep.registry.GNSItems;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.EntityPredicate;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.StatePropertiesPredicate;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FlowerPotBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.data.loot.ChestLootTables;
import net.minecraft.data.loot.EntityLootTables;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.EntityType;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.loot.ConstantRange;
import net.minecraft.loot.ILootConditionConsumer;
import net.minecraft.loot.ILootFunctionConsumer;
import net.minecraft.loot.IRandomRange;
import net.minecraft.loot.ItemLootEntry;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.LootTables;
import net.minecraft.loot.RandomValueRange;
import net.minecraft.loot.StandaloneLootEntry;
import net.minecraft.loot.TagLootEntry;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.loot.conditions.BlockStateProperty;
import net.minecraft.loot.conditions.EntityHasProperty;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.loot.conditions.MatchTool;
import net.minecraft.loot.conditions.RandomChance;
import net.minecraft.loot.conditions.TableBonus;
import net.minecraft.loot.functions.ApplyBonus;
import net.minecraft.loot.functions.ILootFunction;
import net.minecraft.loot.functions.LootingEnchantBonus;
import net.minecraft.loot.functions.SetCount;
import net.minecraft.loot.functions.Smelt;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BedPart;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class GNSLootProv
extends LootTableProvider {
    public GNSLootProv(DataGenerator dataGeneratorIn) {
        super(dataGeneratorIn);
    }

    protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
        return ImmutableList.of((Object)Pair.of(() -> new BlockLoot(), (Object)LootParameterSets.field_216267_h), (Object)Pair.of(() -> new EntityLoot(), (Object)LootParameterSets.field_216263_d), (Object)Pair.of(() -> new ChestLoot(), (Object)LootParameterSets.field_216261_b));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
        map.forEach((location, table) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)location, (LootTable)table));
    }

    public String func_200397_b() {
        return "Good Night's Sleep Loot Tables";
    }

    public static interface LootPoolUtil {
        default public LootTable.Builder tableOf(List<LootPool.Builder> pools) {
            LootTable.Builder table = LootTable.func_216119_b();
            pools.forEach(pool -> table.func_216040_a(pool));
            return table;
        }

        default public LootTable.Builder tableOf(LootPool.Builder pool) {
            return LootTable.func_216119_b().func_216040_a(pool);
        }

        default public LootPool.Builder basicPool(IItemProvider item, int min, int max) {
            return LootPool.func_216096_a().func_216045_a(this.basicEntry(item, min, max));
        }

        default public LootPool.Builder basicPool(IItemProvider item) {
            return LootPool.func_216096_a().func_216045_a(this.basicEntry(item));
        }

        default public LootPool.Builder randItemPool(List<IItemProvider> items) {
            return this.poolOf(items.stream().map(i -> this.basicEntry((IItemProvider)i)).collect(Collectors.toList()));
        }

        default public LootPool.Builder poolOf(List<LootEntry.Builder<?>> lootEntries) {
            LootPool.Builder pool = LootPool.func_216096_a();
            lootEntries.forEach(entry -> pool.func_216045_a(entry));
            return pool;
        }

        default public StandaloneLootEntry.Builder<?> basicEntry(IItemProvider item, int min, int max) {
            return this.basicEntry(item).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)min, (float)max)));
        }

        default public StandaloneLootEntry.Builder<?> basicEntry(IItemProvider item) {
            return ItemLootEntry.func_216168_a((IItemProvider)item);
        }
    }

    private class BlockLoot
    extends BlockLootTables
    implements LootPoolUtil {
        private final ILootCondition.IBuilder SILK_TOUCH = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_218003_a(new EnchantmentPredicate(Enchantments.field_185306_r, MinMaxBounds.IntBound.func_211340_b((int)1))));
        private final ILootCondition.IBuilder SHEARS = MatchTool.func_216012_a((ItemPredicate.Builder)ItemPredicate.Builder.func_200309_a().func_200308_a((IItemProvider)Items.field_151097_aZ));
        private final ILootCondition.IBuilder SILK_TOUCH_OR_SHEARS = this.SHEARS.func_216297_a(this.SILK_TOUCH);
        private final ILootCondition.IBuilder NOT_SILK_TOUCH_OR_SHEARS = this.SILK_TOUCH_OR_SHEARS.func_216298_a();
        private float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

        private BlockLoot() {
        }

        protected void addTables() {
            this.blocks().forEach(block -> {
                if (block == GNSBlocks.dream_grass) {
                    this.func_218507_a((Block)block, this.dropRainbowSeeds((Block)block));
                } else if (block == GNSBlocks.nightmare_grass) {
                    this.func_218522_a((Block)block, BlockLootTables::func_218570_h);
                } else if (block == GNSBlocks.prickly_nightmare_grass) {
                    this.func_218522_a((Block)block, BlockLootTables::func_218570_h);
                } else if (block == GNSBlocks.dream_grass_block) {
                    this.silkOrElse((Block)block, (IItemProvider)GNSBlocks.dream_dirt);
                } else if (block == GNSBlocks.nightmare_grass_block) {
                    this.silkOrElse((Block)block, (IItemProvider)Blocks.field_150346_d);
                } else if (block == GNSBlocks.dream_farmland) {
                    this.func_218493_a((Block)block, (IItemProvider)GNSBlocks.dream_dirt);
                } else if (block == GNSBlocks.delusion_stone) {
                    this.silkOrElse((Block)block, (IItemProvider)GNSBlocks.delusion_cobblestone);
                } else if (block == GNSBlocks.dream_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)b, (IItemProvider)GNSBlocks.dream_sapling, (IItemProvider)Items.field_151055_y));
                } else if (block == GNSBlocks.candy_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)b, (IItemProvider)GNSBlocks.candy_sapling, (IItemProvider)Items.field_151055_y));
                } else if (block == GNSBlocks.diamond_leaves) {
                    this.func_218522_a((Block)block, b -> this.leaves((Block)b, (IItemProvider)GNSBlocks.dream_sapling, (IItemProvider)Items.field_151055_y));
                } else if (block instanceof SlabBlock) {
                    this.func_218522_a((Block)block, BlockLootTables::func_218513_d);
                } else if (block == GNSBlocks.candy_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218519_a((Block)b, (LootEntry.Builder)((LootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)b, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)GNSItems.candy).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))))));
                } else if (block == GNSBlocks.necrum_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218519_a((Block)b, (LootEntry.Builder)((LootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)b, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)GNSItems.necrum).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215871_b((Enchantment)Enchantments.field_185308_t))))));
                } else if (block == GNSBlocks.positite_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218476_a((Block)b, (Item)GNSItems.positite));
                } else if (block == GNSBlocks.negatite_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218476_a((Block)b, (Item)GNSItems.negatite));
                } else if (block == GNSBlocks.rainbow_ore) {
                    this.func_218522_a((Block)block, b -> this.dropRainbow((Block)b));
                } else if (block == GNSBlocks.present) {
                    this.func_218522_a((Block)block, b -> this.dropPresent((Block)b));
                } else if (block instanceof DoorBlock) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218562_a((Block)b, (Property)DoorBlock.field_176523_O, (Comparable)DoubleBlockHalf.LOWER));
                } else if (block instanceof FlowerPotBlock) {
                    this.func_218547_a((Block)block);
                } else if (block == GNSBlocks.lapis_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218519_a((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)Items.field_196128_bn).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)4.0f, (float)9.0f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215869_a((Enchantment)Enchantments.field_185308_t))))));
                } else if (block == GNSBlocks.coal_ore) {
                    this.func_218522_a((Block)block, b -> BlockLoot.func_218476_a((Block)block, (Item)Items.field_151044_h));
                } else if (block instanceof GNSBedBlock) {
                    this.func_218522_a((Block)block, bed -> BlockLoot.func_218562_a((Block)bed, (Property)GNSBedBlock.field_176472_a, (Comparable)BedPart.HEAD));
                } else if (block instanceof GNSRainbowCropBlock) {
                    BlockStateProperty.Builder growthCondition = BlockStateProperty.func_215985_a((Block)block).func_227567_a_(StatePropertiesPredicate.Builder.func_227191_a_().func_227192_a_((Property)GNSRainbowCropBlock.field_176488_a, ((GNSRainbowCropBlock)((Object)block)).func_185526_g()));
                    if (block == GNSBlocks.rainbow_berries) {
                        this.func_218522_a((Block)block, arg_0 -> this.lambda$null$13((ILootCondition.IBuilder)growthCondition, arg_0));
                    }
                } else {
                    this.func_218492_c((Block)block);
                }
            });
        }

        protected Iterable<Block> getKnownBlocks() {
            return this.blocks()::iterator;
        }

        protected LootTable.Builder dropRainbow(Block block) {
            return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)GNSBlocks.rainbow_ore).func_216086_a(50))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_150352_o).func_216086_a(10))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Blocks.field_150366_p).func_216086_a(10))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151137_ax).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(1))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)GNSItems.candy).func_216086_a(20).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))))));
        }

        protected LootTable.Builder dropPresent(Block block) {
            return LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)GNSItems.rainbow_ingot).func_216086_a(30))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151043_k).func_216086_a(10))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151042_j).func_216086_a(10))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151137_ax).func_216086_a(10).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)4.0f))))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151166_bC).func_216086_a(5))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)GNSItems.candy).func_216086_a(30).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)3.0f))))).func_216045_a((LootEntry.Builder)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)block).func_212840_b_(this.SILK_TOUCH)).func_216080_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)GNSItems.positite).func_216086_a(5))));
        }

        private Stream<Block> blocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals("good_nights_sleep") && !b.func_220068_i().equals((Object)LootTables.field_186419_a));
        }

        private void droppingSeedTag(Block block, ITag.INamedTag<Item> tag) {
            this.func_218507_a(block, BlockLoot.func_218511_b((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)((StandaloneLootEntry.Builder)TagLootEntry.func_216176_b(tag).func_212840_b_(RandomChance.func_216004_a((float)0.125f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)2))))));
        }

        protected LootTable.Builder dropRainbowSeeds(Block block) {
            return BlockLoot.func_218511_b((Block)block, (LootEntry.Builder)((LootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)((StandaloneLootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)GNSItems.rainbow_seeds).func_212840_b_(RandomChance.func_216004_a((float)0.125f))).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215865_a((Enchantment)Enchantments.field_185308_t, (int)2)))));
        }

        private void silkOrElse(Block withSilk, IItemProvider without) {
            this.func_218522_a(withSilk, b -> BlockLoot.func_218515_b((Block)b, (IItemProvider)without));
        }

        private LootTable.Builder leaves(Block block, IItemProvider sapling, IItemProvider stick) {
            return BlockLoot.func_218535_c((Block)block, (LootEntry.Builder)((StandaloneLootEntry.Builder)BlockLoot.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)sapling))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])this.DEFAULT_SAPLING_DROP_RATES))).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(this.NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)ItemLootEntry.func_216168_a((IItemProvider)stick).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)1.0f, (float)2.0f))))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f}))));
        }

        private LootTable.Builder leavesFruit(Block block, IItemProvider sapling, IItemProvider stick, IItemProvider fruit) {
            float baseChance = 0.05f;
            float[] fortuneChances = new float[]{1.1111112f, 1.25f, 1.6666667f, 5.0f};
            return this.leaves(block, sapling, stick).func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_212840_b_(this.NOT_SILK_TOUCH_OR_SHEARS).func_216045_a(((StandaloneLootEntry.Builder)BlockLoot.func_218560_a((IItemProvider)block, (ILootConditionConsumer)ItemLootEntry.func_216168_a((IItemProvider)fruit))).func_212840_b_(TableBonus.func_215955_a((Enchantment)Enchantments.field_185308_t, (float[])new float[]{baseChance, baseChance * fortuneChances[0], baseChance * fortuneChances[1], baseChance * fortuneChances[2], baseChance * fortuneChances[3]}))));
        }

        private LootTable.Builder crop(ILootCondition.IBuilder growthCondition, Block block, IItemProvider food) {
            return this.crop(growthCondition, block, food, food);
        }

        private LootTable.Builder crop(ILootCondition.IBuilder growthCondition, Block block, IItemProvider food, IItemProvider seed) {
            LootPool.Builder seedPool = LootPool.func_216096_a().func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)seed).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)3).func_212840_b_(growthCondition)));
            LootPool.Builder foodPool = LootPool.func_216096_a().func_212840_b_(growthCondition).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)food).func_212841_b_((ILootFunction.IBuilder)ApplyBonus.func_215870_a((Enchantment)Enchantments.field_185308_t, (float)0.5714286f, (int)1)));
            return (LootTable.Builder)BlockLoot.func_218552_a((IItemProvider)block, (ILootFunctionConsumer)LootTable.func_216119_b().func_216040_a(seedPool).func_216040_a(foodPool));
        }

        private /* synthetic */ LootTable.Builder lambda$null$13(ILootCondition.IBuilder growthCondition, Block b) {
            return this.crop(growthCondition, b, (IItemProvider)GNSItems.rainbow_berries);
        }
    }

    private class EntityLoot
    extends EntityLootTables
    implements LootPoolUtil {
        private EntityLoot() {
        }

        protected void addTables() {
            this.func_218582_a(GNSEntityTypes.UNICORN, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151116_aA).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))));
            this.func_218582_a(GNSEntityTypes.GUMMY_BEAR, LootTable.func_216119_b());
            this.func_218582_a(GNSEntityTypes.BABY_CREEPER, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)Items.field_151016_H).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)0.0f, (float)1.0f))))).func_216040_a(LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TagLootEntry.func_216176_b((ITag)ItemTags.field_232907_V_)).func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.KILLER, (EntityPredicate.Builder)EntityPredicate.Builder.func_203996_a().func_217989_a((ITag)EntityTypeTags.field_219764_a)))));
            this.func_218582_a(GNSEntityTypes.HEROBRINE, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)GNSItems.negatite).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)0.0f, (float)2.0f))))));
            this.func_218582_a(GNSEntityTypes.TORMENTER, LootTable.func_216119_b().func_216040_a(LootPool.func_216096_a().func_216046_a((IRandomRange)ConstantRange.func_215835_a((int)1)).func_216045_a((LootEntry.Builder)ItemLootEntry.func_216168_a((IItemProvider)GNSItems.necrum).func_212841_b_((ILootFunction.IBuilder)SetCount.func_215932_a((IRandomRange)RandomValueRange.func_215837_a((float)2.0f, (float)3.0f))))));
            this.func_218582_a(GNSEntityTypes.SPAWNER_ENTITY, LootTable.func_216119_b());
        }

        private LootPool.Builder lootingPool(IItemProvider item, int min, int max, int minLooting, int maxLooting) {
            return this.basicPool(item, min, max).func_212841_b_((ILootFunction.IBuilder)LootingEnchantBonus.func_215915_a((RandomValueRange)RandomValueRange.func_215837_a((float)minLooting, (float)maxLooting)));
        }

        private LootPool.Builder smeltingPool(IItemProvider item, int min, int max, int minLooting, int maxLooting) {
            return this.lootingPool(item, min, max, minLooting, maxLooting).func_212841_b_((ILootFunction.IBuilder)Smelt.func_215953_b().func_212840_b_(EntityHasProperty.func_215999_a((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)field_218586_a)));
        }

        private String entityName(EntityType<?> entity) {
            return entity.getRegistryName().func_110623_a();
        }

        protected Iterable<EntityType<?>> getKnownEntities() {
            return ForgeRegistries.ENTITIES.getValues().stream().filter(e -> e.getRegistryName().func_110624_b().contains("good_nights_sleep"))::iterator;
        }
    }

    private class ChestLoot
    extends ChestLootTables
    implements LootPoolUtil {
        private ChestLoot() {
        }

        public void accept(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
        }

        private ResourceLocation locate(String name) {
            return GoodNightSleep.locate("chests/" + name);
        }
    }
}

