/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.registry;

import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.registry.GNSBlocks;
import com.legacy.goodnightsleep.world.biome_provider.DreamBiomeProvider;
import com.legacy.goodnightsleep.world.biome_provider.NightmareBiomeProvider;
import com.mojang.serialization.Lifecycle;
import java.lang.reflect.Constructor;
import java.util.OptionalLong;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.Dimension;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.FuzzedBiomeMagnifier;
import net.minecraft.world.biome.IBiomeMagnifier;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.DimensionSettings;
import net.minecraft.world.gen.NoiseChunkGenerator;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.NoiseSettings;
import net.minecraft.world.gen.settings.ScalingSettings;
import net.minecraft.world.gen.settings.SlideSettings;

public class GNSDimensions {
    public static final ResourceLocation DREAM_ID = GoodNightSleep.locate("good_dream");
    public static final ResourceLocation NIGHTMARE_ID = GoodNightSleep.locate("nightmare");
    public static final RegistryKey<World> DREAM = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)DREAM_ID);
    public static final RegistryKey<World> NIGHTMARE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)NIGHTMARE_ID);
    public static final RegistryKey<DimensionSettings> DREAM_NOISE_SETTINGS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)GoodNightSleep.locate("dream"));
    public static final RegistryKey<DimensionSettings> NIGHTMARE_NOISE_SETTINGS = RegistryKey.func_240903_a_((RegistryKey)Registry.field_243549_ar, (ResourceLocation)NIGHTMARE_ID);
    public static final RegistryKey<DimensionType> DREAM_TYPE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)GoodNightSleep.locate("dream"));
    public static final RegistryKey<DimensionType> NIGHTMARE_TYPE = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239698_ad_, (ResourceLocation)NIGHTMARE_ID);
    public static final RegistryKey<Dimension> DREAM_DIM = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)DREAM_ID);
    public static final RegistryKey<Dimension> NIGHTMARE_DIM = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239700_af_, (ResourceLocation)NIGHTMARE_ID);

    public static ResourceLocation getDimensionLocations(boolean dream) {
        return GNSDimensions.getDimensionKeys(dream).func_240901_a_();
    }

    public static RegistryKey<World> getDimensionKeys(boolean dream) {
        return dream ? DREAM : NIGHTMARE;
    }

    public static void init(SimpleRegistry<Dimension> simpleRegistry, MutableRegistry<DimensionType> mutableRegistry, MutableRegistry<Biome> biomeRegistry, MutableRegistry<DimensionSettings> dimSettingsRegistry, long seed) {
        Function<RegistryKey, DimensionSettings> dreamSettings = noiseSettings -> GNSDimensions.createNoiseSettings(new DimensionStructuresSettings(false), false, GNSBlocks.delusion_stone.func_176223_P(), Blocks.field_150355_j.func_176223_P(), DREAM_NOISE_SETTINGS.func_240901_a_());
        Function<DimensionSettings, ChunkGenerator> dreamGenerator = s -> GNSDimensions.createDreamChunkGenerator((Registry<Biome>)biomeRegistry, (Registry<DimensionSettings>)dimSettingsRegistry, seed);
        Supplier<DimensionType> dreamDimensionType = () -> GNSDimensions.createDimSettings(OptionalLong.of(6000L), false, false, DREAM_ID);
        Function<RegistryKey, DimensionSettings> nightmareSettings = noiseSettings -> GNSDimensions.createNoiseSettings(new DimensionStructuresSettings(false), false, Blocks.field_150348_b.func_176223_P(), Blocks.field_150353_l.func_176223_P(), NIGHTMARE_NOISE_SETTINGS.func_240901_a_());
        Function<DimensionSettings, ChunkGenerator> nightmareGenerator = s -> GNSDimensions.createNightmareChunkGenerator((Registry<Biome>)biomeRegistry, (Registry<DimensionSettings>)dimSettingsRegistry, seed);
        Supplier<DimensionType> nightmareDimensionType = () -> GNSDimensions.createDimSettings(OptionalLong.of(18000L), true, true, NIGHTMARE_ID);
        Dimension dreamDim = new Dimension(dreamDimensionType, dreamGenerator.apply(dreamSettings.apply(DREAM_NOISE_SETTINGS)));
        Dimension nightmareDim = new Dimension(nightmareDimensionType, nightmareGenerator.apply(nightmareSettings.apply(NIGHTMARE_NOISE_SETTINGS)));
        simpleRegistry.func_218381_a(DREAM_DIM, (Object)dreamDim, Lifecycle.stable());
        simpleRegistry.func_218381_a(NIGHTMARE_DIM, (Object)nightmareDim, Lifecycle.stable());
    }

    public static void initNoiseSettings() {
        GNSDimensions.registerNoiseSettings(DREAM_NOISE_SETTINGS, GNSDimensions.createNoiseSettings(new DimensionStructuresSettings(false), false, GNSBlocks.delusion_stone.func_176223_P(), Blocks.field_150355_j.func_176223_P(), DREAM_NOISE_SETTINGS.func_240901_a_()));
        GNSDimensions.registerNoiseSettings(NIGHTMARE_NOISE_SETTINGS, GNSDimensions.createNoiseSettings(new DimensionStructuresSettings(false), false, Blocks.field_150348_b.func_176223_P(), Blocks.field_150353_l.func_176223_P(), NIGHTMARE_NOISE_SETTINGS.func_240901_a_()));
    }

    public static DimensionSettings createNoiseSettings(DimensionStructuresSettings structureSettingsIn, boolean flag1, BlockState fillerBlockIn, BlockState fluidBlockIn, ResourceLocation settingsLocationIn) {
        try {
            Constructor constructor = DimensionSettings.class.getDeclaredConstructor(DimensionStructuresSettings.class, NoiseSettings.class, BlockState.class, BlockState.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            constructor.setAccessible(true);
            return (DimensionSettings)constructor.newInstance(structureSettingsIn, new NoiseSettings(256, new ScalingSettings(0.9999999814507745, 0.9999999814507745, 80.0, 160.0), new SlideSettings(-10, 3, 0), new SlideSettings(-30, 0, 0), 1, 2, 1.0, -0.46875, true, true, false, flag1), fillerBlockIn, fluidBlockIn, -10, 0, 63, false);
        }
        catch (Exception e) {
            GoodNightSleep.LOGGER.error("Failed to create dimension settings. This issue should be reported!");
            e.printStackTrace();
            return null;
        }
    }

    private static DimensionSettings registerNoiseSettings(RegistryKey<DimensionSettings> settingsKeyIn, DimensionSettings dimSettingsIn) {
        WorldGenRegistries.func_243664_a((Registry)WorldGenRegistries.field_243658_j, (ResourceLocation)settingsKeyIn.func_240901_a_(), (Object)dimSettingsIn);
        return dimSettingsIn;
    }

    private static ChunkGenerator createDreamChunkGenerator(Registry<Biome> biomeRegistry, Registry<DimensionSettings> dimSettingsRegistry, long seed) {
        return new NoiseChunkGenerator((BiomeProvider)DreamBiomeProvider.DreamPreset.dreamPreset.func_242619_a(biomeRegistry, seed), seed, () -> (DimensionSettings)dimSettingsRegistry.func_243576_d(DREAM_NOISE_SETTINGS));
    }

    private static ChunkGenerator createNightmareChunkGenerator(Registry<Biome> biomeRegistry, Registry<DimensionSettings> dimSettingsRegistry, long seed) {
        return new NoiseChunkGenerator((BiomeProvider)NightmareBiomeProvider.NightmarePreset.nightmarePreset.func_242619_a(biomeRegistry, seed), seed, () -> (DimensionSettings)dimSettingsRegistry.func_243576_d(NIGHTMARE_NOISE_SETTINGS));
    }

    private static DimensionType createDimSettings(OptionalLong time, boolean ultrawarm, boolean piglinSafe, ResourceLocation effectsId) {
        return new DimensionType(time, true, false, ultrawarm, true, 1.0, false, piglinSafe, true, false, false, 256, (IBiomeMagnifier)FuzzedBiomeMagnifier.INSTANCE, BlockTags.field_241277_aC_.func_230234_a_(), effectsId, 0.0f){};
    }
}

