/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.registry;

import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.entity.GNSSpawnerEntity;
import com.legacy.goodnightsleep.entity.HerobrineEntity;
import com.legacy.goodnightsleep.entity.TormenterEntity;
import com.legacy.goodnightsleep.entity.dream.BabyCreeperEntity;
import com.legacy.goodnightsleep.entity.dream.GummyBearEntity;
import com.legacy.goodnightsleep.entity.dream.UnicornEntity;
import com.legacy.goodnightsleep.registry.GNSBlocks;
import com.legacy.goodnightsleep.registry.GNSRegistry;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.registries.ObjectHolder;

@ObjectHolder(value="good_nights_sleep")
public class GNSEntityTypes {
    public static final EntityType<UnicornEntity> UNICORN = GNSEntityTypes.buildEntity("unicorn", EntityType.Builder.func_220322_a(UnicornEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.3964844f, 1.6f));
    public static final EntityType<GummyBearEntity> GUMMY_BEAR = GNSEntityTypes.buildEntity("gummy_bear", EntityType.Builder.func_220322_a(GummyBearEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.6f, 0.7f));
    public static final EntityType<BabyCreeperEntity> BABY_CREEPER = GNSEntityTypes.buildEntity("baby_creeper", EntityType.Builder.func_220322_a(BabyCreeperEntity::new, (EntityClassification)EntityClassification.MONSTER).func_220321_a(0.6f, 1.3f));
    public static final EntityType<TormenterEntity> TORMENTER = GNSEntityTypes.buildEntity("tormenter", EntityType.Builder.func_220322_a(TormenterEntity::new, (EntityClassification)EntityClassification.MONSTER));
    public static final EntityType<HerobrineEntity> HEROBRINE = GNSEntityTypes.buildEntity("herobrine", EntityType.Builder.func_220322_a(HerobrineEntity::new, (EntityClassification)EntityClassification.MONSTER));
    public static final EntityType<GNSSpawnerEntity> SPAWNER_ENTITY = GNSEntityTypes.buildEntity("gns_spawner", EntityType.Builder.func_220322_a(GNSSpawnerEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(1.0f, 1.0f));

    public static void init(RegistryEvent.Register<EntityType<?>> event) {
        GNSRegistry.register(event.getRegistry(), "unicorn", UNICORN);
        GNSRegistry.register(event.getRegistry(), "gummy_bear", GUMMY_BEAR);
        GNSRegistry.register(event.getRegistry(), "baby_creeper", BABY_CREEPER);
        GNSRegistry.register(event.getRegistry(), "tormenter", TORMENTER);
        GNSRegistry.register(event.getRegistry(), "herobrine", HEROBRINE);
        GNSRegistry.register(event.getRegistry(), "gns_spawner", SPAWNER_ENTITY);
        EntitySpawnPlacementRegistry.func_209343_a(TORMENTER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(HEROBRINE, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(BABY_CREEPER, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, MonsterEntity::func_223325_c);
        EntitySpawnPlacementRegistry.func_209343_a(UNICORN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GNSEntityTypes::animalSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(GUMMY_BEAR, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GNSEntityTypes::animalSpawnConditions);
        EntitySpawnPlacementRegistry.func_209343_a(SPAWNER_ENTITY, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, GNSEntityTypes::otherSpawnConditions);
        GNSEntityTypes.registerAttributes();
    }

    private static void registerAttributes() {
        GlobalEntityTypeAttributes.put(UNICORN, (AttributeModifierMap)UnicornEntity.func_234237_fg_().func_233813_a_());
        GlobalEntityTypeAttributes.put(GUMMY_BEAR, (AttributeModifierMap)MobEntity.func_233666_p_().func_233813_a_());
        GlobalEntityTypeAttributes.put(BABY_CREEPER, (AttributeModifierMap)CreeperEntity.func_234278_m_().func_233813_a_());
        GlobalEntityTypeAttributes.put(TORMENTER, (AttributeModifierMap)TormenterEntity.registerAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(HEROBRINE, (AttributeModifierMap)HerobrineEntity.registerAttributes().func_233813_a_());
        GlobalEntityTypeAttributes.put(SPAWNER_ENTITY, (AttributeModifierMap)MobEntity.func_233666_p_().func_233813_a_());
    }

    public static boolean animalSpawnConditions(EntityType<? extends AnimalEntity> entityIn, IWorld worldIn, SpawnReason reasonIn, BlockPos posIn, Random randIn) {
        return worldIn.func_180495_p(posIn.func_177977_b()).func_177230_c() == GNSBlocks.dream_grass_block && worldIn.func_226659_b_(posIn, 0) > 8;
    }

    public static boolean otherSpawnConditions(EntityType<? extends MobEntity> entityIn, IWorld worldIn, SpawnReason reasonIn, BlockPos posIn, Random randIn) {
        return (worldIn.func_180495_p(posIn.func_177977_b()).func_177230_c() == GNSBlocks.nightmare_grass_block || worldIn.func_180495_p(posIn.func_177977_b()).func_177230_c() == GNSBlocks.dream_grass_block) && worldIn.func_175710_j(posIn);
    }

    private static <T extends Entity> EntityType<T> buildEntity(String key, EntityType.Builder<T> builder) {
        return builder.func_206830_a(GoodNightSleep.find(key));
    }
}

