/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.registry;

import com.legacy.goodnightsleep.registry.GNSBlocks;
import com.legacy.goodnightsleep.registry.GNSRegistry;
import com.legacy.goodnightsleep.world.carver.GNSCanyonWorldCarver;
import com.legacy.goodnightsleep.world.carver.GNSCaveWorldCarver;
import com.legacy.goodnightsleep.world.dream.features.DreamSpongeFeature;
import com.legacy.goodnightsleep.world.dream.features.FatHopeMushroomFeature;
import com.legacy.goodnightsleep.world.dream.features.TallHopeMushroomFeature;
import com.legacy.goodnightsleep.world.general_features.DreamScatteredPlantFeature;
import com.legacy.goodnightsleep.world.nightmare.features.NetherSplashFeature;
import com.mojang.serialization.Codec;
import java.util.OptionalInt;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.state.Property;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeGenerationSettings;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.blockplacer.BlockPlacer;
import net.minecraft.world.gen.blockplacer.SimpleBlockPlacer;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.SimpleBlockStateProvider;
import net.minecraft.world.gen.blockstateprovider.WeightedBlockStateProvider;
import net.minecraft.world.gen.carver.ICarverConfig;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.AbstractFeatureSizeType;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.BigMushroomFeatureConfig;
import net.minecraft.world.gen.feature.BlockClusterFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.FeatureSpread;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.feature.OreFeatureConfig;
import net.minecraft.world.gen.feature.ProbabilityConfig;
import net.minecraft.world.gen.feature.TwoLayerFeature;
import net.minecraft.world.gen.feature.template.BlockMatchRuleTest;
import net.minecraft.world.gen.feature.template.RuleTest;
import net.minecraft.world.gen.foliageplacer.BlobFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FancyFoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.placement.AtSurfaceWithExtraConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.DepthAverageConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoiseDependant;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.FancyTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.StraightTrunkPlacer;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;

public class GNSFeatures {
    public static final Feature<BigMushroomFeatureConfig> TALL_HOPE_MUSHROOM = new TallHopeMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
    public static final Feature<BigMushroomFeatureConfig> FAT_HOPE_MUSHROOM = new FatHopeMushroomFeature((Codec<BigMushroomFeatureConfig>)BigMushroomFeatureConfig.field_236528_a_);
    public static final Feature<NoFeatureConfig> DREAM_SPONGE = new DreamSpongeFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static final Feature<NoFeatureConfig> SCATTERED_PRESENTS = new DreamScatteredPlantFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, GNSBlocks.present.func_176223_P());
    public static final Feature<NoFeatureConfig> NETHER_SPLASH = new NetherSplashFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_);
    public static final Feature<NoFeatureConfig> SCATTERED_PUMPKINS = new DreamScatteredPlantFeature((Codec<NoFeatureConfig>)NoFeatureConfig.field_236558_a_, Blocks.field_150423_aK.func_176223_P());
    public static final RuleTest DELUSION_RULE_TEST = new BlockMatchRuleTest(GNSBlocks.delusion_stone);
    public static final BlockClusterFeatureConfig DREAM_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.dream_grass.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig NIGHTMARE_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.nightmare_grass.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig DREAM_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(GNSBlocks.cyan_flower.func_176223_P(), 1).func_227407_a_(GNSBlocks.orange_flower.func_176223_P(), 1).func_227407_a_(GNSBlocks.lolipop_bush.func_176223_P(), 2), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig LOLIPOP_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.lolipop_bush.func_176223_P()), (BlockPlacer)SimpleBlockPlacer.field_236447_c_).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig PRICKLY_GRASS_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.prickly_nightmare_grass.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(32).func_227322_d_();
    public static final BlockClusterFeatureConfig DEAD_FLOWER_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new WeightedBlockStateProvider().func_227407_a_(GNSBlocks.dead_flower.func_176223_P(), 1), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227322_d_();
    public static final BlockClusterFeatureConfig HOPE_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.hope_mushroom.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final BlockClusterFeatureConfig DESPAIR_MUSHROOM_CONFIG = new BlockClusterFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.despair_mushroom.func_176223_P()), (BlockPlacer)new SimpleBlockPlacer()).func_227315_a_(64).func_227317_b_().func_227322_d_();
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> DREAM_TREE = GNSFeatures.createConfiguredFeature("dream_tree", GNSFeatures.createBasicTree(GNSBlocks.dream_log.func_176223_P(), GNSBlocks.dream_leaves.func_176223_P(), 4, 1));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> CANDY_TREE = GNSFeatures.createConfiguredFeature("candy_tree", GNSFeatures.createBasicTree(GNSBlocks.white_log.func_176223_P(), GNSBlocks.candy_leaves.func_176223_P(), 5));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> LARGE_CANDY_TREE = GNSFeatures.createConfiguredFeature("large_candy_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.white_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.candy_leaves.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 4), (AbstractTrunkPlacer)new StraightTrunkPlacer(7, 3, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_()));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> DIAMOND_TREE = GNSFeatures.createConfiguredFeature("diamond_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.dream_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.diamond_leaves.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_()));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> DEAD_TREE = GNSFeatures.createConfiguredFeature("dead_tree", GNSFeatures.createBasicTree(GNSBlocks.dead_log.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 5));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> BLOOD_TREE = GNSFeatures.createConfiguredFeature("blood_tree", GNSFeatures.createBasicTree(GNSBlocks.blood_log.func_176223_P(), Blocks.field_150350_a.func_176223_P(), 5));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> LARGE_DEAD_TREE = GNSFeatures.createConfiguredFeature("large_dead_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.dead_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(4))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_()));
    public static final ConfiguredFeature<BaseTreeFeatureConfig, ?> LARGE_BLOOD_TREE = GNSFeatures.createConfiguredFeature("large_blood_tree", Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(GNSBlocks.blood_log.func_176223_P()), (BlockStateProvider)new SimpleBlockStateProvider(Blocks.field_150350_a.func_176223_P()), (FoliagePlacer)new FancyFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)4), 4), (AbstractTrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (AbstractFeatureSizeType)new TwoLayerFeature(0, 0, 0, OptionalInt.of(8))).func_236700_a_().func_236702_a_(Heightmap.Type.MOTION_BLOCKING).func_225568_b_()));
    public static final ConfiguredFeature<BigMushroomFeatureConfig, ?> HUGE_HOPE_MUSHROOM = GNSFeatures.createConfiguredFeature("huge_hope_mushroom", Feature.field_202318_R.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.hope_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 2)));
    public static final ConfiguredFeature<BigMushroomFeatureConfig, ?> HUGE_DESPAIR_MUSHROOM = GNSFeatures.createConfiguredFeature("huge_despair_mushroom", Feature.field_202319_S.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.despair_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 3)));
    public static final ConfiguredFeature<?, ?> TALLER_HOPE_MUSHROOM = GNSFeatures.createConfiguredFeature("taller_hope_mushroom", TALL_HOPE_MUSHROOM.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.hope_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 2)));
    public static final ConfiguredFeature<?, ?> SLIGHTLY_LARGER_HOPE_MUSHROOM = GNSFeatures.createConfiguredFeature("taller_hope_mushroom", TALL_HOPE_MUSHROOM.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.hope_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 3)));
    public static final ConfiguredFeature<?, ?> VERY_LARGE_HOPE_MUSHROOM = GNSFeatures.createConfiguredFeature("taller_hope_mushroom", FAT_HOPE_MUSHROOM.func_225566_b_((IFeatureConfig)new BigMushroomFeatureConfig((BlockStateProvider)new SimpleBlockStateProvider((BlockState)GNSBlocks.hope_mushroom_block.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), (BlockStateProvider)new SimpleBlockStateProvider((BlockState)((BlockState)Blocks.field_196706_do.func_176223_P().func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)HugeMushroomBlock.field_196460_A, (Comparable)Boolean.valueOf(false))), 5)));
    public static final ConfiguredFeature<?, ?> HOPE_MUSHROOM_PATCH = GNSFeatures.createConfiguredFeature("hope_mushroom_patch", Feature.field_227248_z_.func_225566_b_((IFeatureConfig)HOPE_MUSHROOM_CONFIG).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(8))));
    public static final ConfiguredFeature<?, ?> DESPAIR_MUSHROOM_PATCH = GNSFeatures.createConfiguredFeature("despair_mushroom_patch", Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DESPAIR_MUSHROOM_CONFIG).func_227228_a_(Placement.field_242898_b.func_227446_a_((IPlacementConfig)new ChanceConfig(4))));
    public static final ConfiguredFeature<?, ?> NETHER_HOPE_MUSHROOM_PATCH = GNSFeatures.createConfiguredFeature("nether_hope_mushroom_patch", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)HOPE_MUSHROOM_CONFIG).func_242733_d(128)).func_242729_a(8));
    public static final ConfiguredFeature<?, ?> NETHER_DESPAIR_MUSHROOM_PATCH = GNSFeatures.createConfiguredFeature("nether_despair_mushroom_patch", (ConfiguredFeature)((ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)DESPAIR_MUSHROOM_CONFIG).func_242733_d(128)).func_242729_a(4));

    public static void init(RegistryEvent.Register<Feature<?>> event) {
        GNSRegistry.register(event.getRegistry(), "tall_hope_mushroom", TALL_HOPE_MUSHROOM);
        GNSRegistry.register(event.getRegistry(), "fat_hope_mushroom", FAT_HOPE_MUSHROOM);
        GNSRegistry.register(event.getRegistry(), "dream_sponge", DREAM_SPONGE);
        GNSRegistry.register(event.getRegistry(), "scattered_presents", SCATTERED_PRESENTS);
        GNSRegistry.register(event.getRegistry(), "nether_splash", NETHER_SPLASH);
        GNSRegistry.register(event.getRegistry(), "scattered_pumpkins", SCATTERED_PUMPKINS);
    }

    public static void addDreamOres(BiomeGenerationSettings.Builder biomeIn) {
        RuleTest delusionConfig = DELUSION_RULE_TEST;
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.dream_dirt.func_176223_P(), 33)).func_242733_d(256)).func_242728_a()).func_242731_b(10));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.coal_ore.func_176223_P(), 17)).func_242733_d(128)).func_242728_a()).func_242731_b(20));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.candy_ore.func_176223_P(), 15)).func_242733_d(64)).func_242728_a()).func_242731_b(20));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.rainbow_ore.func_176223_P(), 9)).func_242733_d(64)).func_242728_a()).func_242731_b(20));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.positite_ore.func_176223_P(), 8)).func_242733_d(16)).func_242728_a()).func_242731_b(1));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, GNSBlocks.lapis_ore.func_176223_P(), 7)).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(16, 16))).func_242728_a());
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(delusionConfig, Blocks.field_150426_aN.func_176223_P(), 8)).func_242733_d(7)).func_242728_a()).func_242731_b(1));
    }

    public static void addDreamTrees(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, DREAM_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, CANDY_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, DIAMOND_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.2f, 1))));
    }

    public static void addScatteredDreamFeatures(BiomeGenerationSettings.Builder biomeIn) {
        GNSFeatures.addDreamSponges(biomeIn);
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)SCATTERED_PRESENTS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(32));
    }

    public static void addDreamSponges(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, (ConfiguredFeature)DREAM_SPONGE.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(20));
    }

    public static void addHugeHopeMushrooms(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, HUGE_HOPE_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.3f, 1))));
    }

    public static void addHopeMushroomFields(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, HUGE_HOPE_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 1))));
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, SLIGHTLY_LARGER_HOPE_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 1.0f, 2))));
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, VERY_LARGE_HOPE_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.1f, 1))));
    }

    public static void addNightmareOres(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150346_d.func_176223_P(), 33)).func_242733_d(256)).func_242728_a()).func_242731_b(10));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150351_n.func_176223_P(), 33)).func_242733_d(256)).func_242728_a()).func_242731_b(8));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150365_q.func_176223_P(), 17)).func_242733_d(128)).func_242728_a()).func_242731_b(20));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GNSBlocks.necrum_ore.func_176223_P(), 15)).func_242733_d(128)).func_242728_a()).func_242731_b(20));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150366_p.func_176223_P(), 9)).func_242733_d(64)).func_242728_a()).func_242731_b(20));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GNSBlocks.zitrite_ore.func_176223_P(), 8)).func_242733_d(32)).func_242728_a()).func_242731_b(5));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)((ConfiguredFeature)((ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, GNSBlocks.negatite_ore.func_176223_P(), 5)).func_242733_d(16)).func_242728_a()).func_242731_b(1));
        biomeIn.func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, (ConfiguredFeature)Feature.field_202290_aj.func_225566_b_((IFeatureConfig)new OreFeatureConfig(OreFeatureConfig.FillerBlockType.field_241882_a, Blocks.field_150369_x.func_176223_P(), 7)).func_227228_a_(Placement.field_242910_o.func_227446_a_((IPlacementConfig)new DepthAverageConfig(16, 16))).func_242728_a());
    }

    public static void addNightmareTrees(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, LARGE_DEAD_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.5f, 1))));
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, BLOOD_TREE.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
    }

    public static void addScatteredNightmareFeatures(BiomeGenerationSettings.Builder biomeIn, int pumpkinFrequency) {
        biomeIn.func_242513_a(GenerationStage.Decoration.RAW_GENERATION, (ConfiguredFeature)NETHER_SPLASH.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(20));
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)SCATTERED_PUMPKINS.func_225566_b_((IFeatureConfig)IFeatureConfig.field_202429_e).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244002_m).func_242729_a(pumpkinFrequency));
    }

    public static void addHugeDespairMushrooms(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, HUGE_DESPAIR_MUSHROOM.func_227228_a_(Features.Placements.field_244001_l).func_227228_a_(Placement.field_242902_f.func_227446_a_((IPlacementConfig)new AtSurfaceWithExtraConfig(0, 0.4f, 1))));
    }

    public static void addNoiseBasedGrass(BiomeGenerationSettings.Builder biomeIn, BlockClusterFeatureConfig config) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Features.Placements.field_244002_m).func_227228_a_(Placement.field_242900_d.func_227446_a_((IPlacementConfig)new NoiseDependant(-0.8, 5, 10))));
    }

    public static void addGrass(BiomeGenerationSettings.Builder biomeIn, BlockClusterFeatureConfig config, int frequency) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Feature.field_227248_z_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Features.Placements.field_244002_m).func_242731_b(frequency));
    }

    public static void addFlowers(BiomeGenerationSettings.Builder biomeIn, BlockClusterFeatureConfig config, int frequency) {
        biomeIn.func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, (ConfiguredFeature)Feature.field_227247_y_.func_225566_b_((IFeatureConfig)config).func_227228_a_(Features.Placements.field_244000_k).func_227228_a_(Features.Placements.field_244001_l).func_242731_b(frequency));
    }

    public static void addCarvers(BiomeGenerationSettings.Builder biomeIn) {
        biomeIn.func_242512_a(GenerationStage.Carving.AIR, Carvers.DELUSION_CAVE_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.14285715f)));
        biomeIn.func_242512_a(GenerationStage.Carving.AIR, Carvers.DELUSION_CANYON_CARVER.func_242761_a((ICarverConfig)new ProbabilityConfig(0.02f)));
    }

    public static void addMushrooms(BiomeLoadingEvent eventIn) {
        if (eventIn.getName().toString().contains("good_nights_sleep") || eventIn.getCategory() == Biome.Category.THEEND || eventIn.getCategory() == Biome.Category.NONE) {
            return;
        }
        if (eventIn.getCategory() == Biome.Category.NETHER) {
            eventIn.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NETHER_HOPE_MUSHROOM_PATCH);
            eventIn.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, NETHER_DESPAIR_MUSHROOM_PATCH);
        } else {
            eventIn.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, HOPE_MUSHROOM_PATCH);
            eventIn.getGeneration().func_242513_a(GenerationStage.Decoration.VEGETAL_DECORATION, DESPAIR_MUSHROOM_PATCH);
        }
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> createBasicTree(BlockState log, BlockState leaves, int height) {
        return GNSFeatures.createBasicTree(log, leaves, height, 2);
    }

    public static ConfiguredFeature<BaseTreeFeatureConfig, ?> createBasicTree(BlockState log, BlockState leaves, int height, int randHeight) {
        return Feature.field_236291_c_.func_225566_b_((IFeatureConfig)new BaseTreeFeatureConfig.Builder((BlockStateProvider)new SimpleBlockStateProvider(log), (BlockStateProvider)new SimpleBlockStateProvider(leaves), (FoliagePlacer)new BlobFoliagePlacer(FeatureSpread.func_242252_a((int)2), FeatureSpread.func_242252_a((int)0), 3), (AbstractTrunkPlacer)new StraightTrunkPlacer(height, randHeight, 0), (AbstractFeatureSizeType)new TwoLayerFeature(1, 0, 1)).func_236700_a_().func_225568_b_());
    }

    private static <FC extends IFeatureConfig> ConfiguredFeature<FC, ?> createConfiguredFeature(String nameIn, ConfiguredFeature<FC, ?> featureIn) {
        return (ConfiguredFeature)Registry.func_218325_a((Registry)WorldGenRegistries.field_243653_e, (String)nameIn, featureIn);
    }

    public static class Carvers {
        public static final WorldCarver<ProbabilityConfig> DELUSION_CAVE_CARVER = new GNSCaveWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_, 256);
        public static final WorldCarver<ProbabilityConfig> DELUSION_CANYON_CARVER = new GNSCanyonWorldCarver((Codec<ProbabilityConfig>)ProbabilityConfig.field_236576_b_);

        public static void init(RegistryEvent.Register<WorldCarver<?>> event) {
            GNSRegistry.register(event.getRegistry(), "delusion_cave_carver", DELUSION_CAVE_CARVER);
            GNSRegistry.register(event.getRegistry(), "delusion_canyon_carver", DELUSION_CANYON_CARVER);
        }
    }
}

