/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.goodnightsleep.registry;

import com.legacy.goodnightsleep.GoodNightSleep;
import com.legacy.goodnightsleep.client.audio.GNSSounds;
import com.legacy.goodnightsleep.item.GNSCreativeTabs;
import com.legacy.goodnightsleep.registry.GNSBiomes;
import com.legacy.goodnightsleep.registry.GNSBlocks;
import com.legacy.goodnightsleep.registry.GNSEntityTypes;
import com.legacy.goodnightsleep.registry.GNSFeatures;
import com.legacy.goodnightsleep.registry.GNSItems;
import com.legacy.goodnightsleep.tile_entity.GNSTileEntityTypes;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.carver.WorldCarver;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="good_nights_sleep", bus=Mod.EventBusSubscriber.Bus.MOD)
public class GNSRegistry {
    public static final RegistryKey<Registry<Biome>> GNS_BIOME_KEY = GNSRegistry.createKey("worldgen/biome");

    @SubscribeEvent
    public static void onRegisterSounds(RegistryEvent.Register<SoundEvent> event) {
        GNSSounds.init(event);
    }

    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        GNSBlocks.init(event);
    }

    @SubscribeEvent
    public static void onRegisterItems(RegistryEvent.Register<Item> event) {
        GNSItems.init(event);
        for (int i3 = 0; i3 < GNSBlocks.gnsBlockList.size(); ++i3) {
            GNSRegistry.register(event.getRegistry(), GNSBlocks.gnsBlockList.get(i3).getRegistryName().toString().replace("good_nights_sleep:", ""), new BlockItem(GNSBlocks.gnsBlockList.get(i3), new Item.Properties().func_200916_a(GNSCreativeTabs.blocks)));
        }
    }

    @SubscribeEvent
    public static void onRegisterEntityTypes(RegistryEvent.Register<EntityType<?>> event) {
        GNSEntityTypes.init(event);
    }

    @SubscribeEvent
    public static void registerTileEntityTypes(RegistryEvent.Register<TileEntityType<?>> event) {
        GNSTileEntityTypes.init(event);
    }

    @SubscribeEvent
    public static void onRegisterBiomes(RegistryEvent.Register<Biome> event) {
        GNSBiomes.init(event);
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        GNSFeatures.init(event);
    }

    @SubscribeEvent
    public static void onRegisterWorldCarvers(RegistryEvent.Register<WorldCarver<?>> event) {
        GNSFeatures.Carvers.init(event);
    }

    public static <T extends IForgeRegistryEntry<T>> void register(IForgeRegistry<T> registry, String name, T object) {
        object.setRegistryName(GoodNightSleep.locate(name));
        registry.register(object);
    }

    public static <T> RegistryKey<Registry<T>> createKey(String name) {
        return RegistryKey.func_240904_a_((ResourceLocation)GoodNightSleep.locate(name));
    }
}

