/*
 * Decompiled with CFR 0.152.
 */
package lykrast.gunswithoutroses.entity;

import lykrast.gunswithoutroses.registry.Holders;
import lykrast.gunswithoutroses.registry.ModEntities;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.AbstractFireballEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class BulletEntity
extends AbstractFireballEntity {
    private double damage = 1.0;
    private boolean ignoreInvulnerability = false;
    private double knockbackStrength = 0.0;
    protected int field_70173_aa;
    private static final double STOP_TRESHOLD = 0.01;

    public BulletEntity(EntityType<? extends BulletEntity> p_i50160_1_, World p_i50160_2_) {
        super(p_i50160_1_, p_i50160_2_);
    }

    public BulletEntity(World worldIn, LivingEntity shooter) {
        this(worldIn, shooter, 0.0, 0.0, 0.0);
        this.func_70107_b(shooter.func_226277_ct_(), shooter.func_226280_cw_() - 0.1, shooter.func_226281_cx_());
    }

    public BulletEntity(World worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ) {
        super(ModEntities.BULLET, shooter, accelX, accelY, accelZ, worldIn);
    }

    public BulletEntity(World worldIn, double x, double y, double z, double accelX, double accelY, double accelZ) {
        super(ModEntities.BULLET, x, y, z, accelX, accelY, accelZ, worldIn);
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > 200 || this.func_213322_ci().func_189985_c() < 0.01) {
            this.func_70106_y();
        }
        ++this.field_70173_aa;
        super.func_70071_h_();
    }

    protected void func_213868_a(EntityRayTraceResult raytrace) {
        super.func_213868_a(raytrace);
        if (!this.field_70170_p.field_72995_K) {
            boolean damaged;
            Entity target = raytrace.func_216348_a();
            Entity shooter = this.func_234616_v_();
            if (this.func_70027_ad()) {
                target.func_70015_d(5);
            }
            int lastHurtResistant = target.field_70172_ad;
            if (this.ignoreInvulnerability) {
                target.field_70172_ad = 0;
            }
            if ((damaged = target.func_70097_a(new IndirectEntityDamageSource("arrow", (Entity)this, shooter).func_76349_b(), (float)this.damage)) && target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                if (this.knockbackStrength > 0.0) {
                    Vector3d vec;
                    double actualKnockback = this.knockbackStrength;
                    if (Holders.Hanami.INSTABILITY != null && livingTarget.func_70644_a(Holders.Hanami.INSTABILITY)) {
                        actualKnockback *= (double)(2 + livingTarget.func_70660_b(Holders.Hanami.INSTABILITY).func_76458_c());
                    }
                    if ((vec = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a(actualKnockback)).func_189985_c() > 0.0) {
                        livingTarget.func_70024_g(vec.field_72450_a, 0.1, vec.field_72449_c);
                    }
                }
                if (shooter instanceof LivingEntity) {
                    this.func_174815_a((LivingEntity)shooter, target);
                }
            } else if (!damaged && this.ignoreInvulnerability) {
                target.field_70172_ad = lastHurtResistant;
            }
        }
    }

    protected void func_70227_a(RayTraceResult result) {
        super.func_70227_a(result);
        if (!this.field_70170_p.field_72995_K) {
            this.func_70106_y();
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74780_a("damage", this.damage);
        compound.func_74757_a("ignoreinv", this.ignoreInvulnerability);
        compound.func_74780_a("knockback", this.knockbackStrength);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.damage = compound.func_74769_h("damage");
        this.ignoreInvulnerability = compound.func_74767_n("ignoreinv");
        this.knockbackStrength = compound.func_74769_h("knockback");
    }

    public void setDamage(double damage) {
        this.damage = damage;
    }

    public double getDamage() {
        return this.damage;
    }

    public void setIgnoreInvulnerability(boolean ignoreInvulnerability) {
        this.ignoreInvulnerability = ignoreInvulnerability;
    }

    public void setKnockbackStrength(double knockbackStrength) {
        this.knockbackStrength = knockbackStrength;
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    protected boolean func_184564_k() {
        return false;
    }

    protected float func_82341_c() {
        return 1.0f;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

