/*
 * Decompiled with CFR 0.152.
 */
package lykrast.gunswithoutroses.item;

import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import lykrast.gunswithoutroses.entity.BulletEntity;
import lykrast.gunswithoutroses.item.BulletItem;
import lykrast.gunswithoutroses.registry.ModEnchantments;
import lykrast.gunswithoutroses.registry.ModItems;
import lykrast.gunswithoutroses.registry.ModSounds;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GunItem
extends ShootableItem {
    protected int bonusDamage;
    protected double damageMultiplier;
    protected int fireDelay;
    protected double inaccuracy;
    private int enchantability;
    protected boolean ignoreInvulnerability = false;
    protected double chanceFreeShot = 0.0;
    protected SoundEvent fireSound = ModSounds.gun;
    private static final Predicate<ItemStack> BULLETS = stack -> stack.func_77973_b() instanceof BulletItem;

    public GunItem(Item.Properties properties, int bonusDamage, double damageMultiplier, int fireDelay, double inaccuracy, int enchantability) {
        super(properties);
        this.bonusDamage = bonusDamage;
        this.damageMultiplier = damageMultiplier;
        this.enchantability = enchantability;
        this.fireDelay = fireDelay;
        this.inaccuracy = inaccuracy;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack gun = player.func_184586_b(hand);
        ItemStack ammo = player.func_213356_f(gun);
        if (!ammo.func_190926_b() || player.field_71075_bZ.field_75098_d) {
            BulletItem bulletItem;
            if (ammo.func_190926_b() || ammo.func_77973_b() == Items.field_151032_g) {
                ammo = new ItemStack((IItemProvider)ModItems.flintBullet);
            }
            BulletItem bulletItem2 = bulletItem = ammo.func_77973_b() instanceof BulletItem ? ammo.func_77973_b() : ModItems.flintBullet;
            if (!world.field_72995_K) {
                boolean bulletFree = player.field_71075_bZ.field_75098_d || !this.shouldConsumeAmmo(gun, player);
                this.shoot(world, player, gun, ammo, bulletItem, bulletFree);
                gun.func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(player.func_184600_cs()));
                if (!bulletFree) {
                    bulletItem.consume(ammo, player);
                }
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), this.fireSound, SoundCategory.PLAYERS, 1.0f, field_77697_d.nextFloat() * 0.4f + 0.8f);
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
            player.func_184811_cZ().func_185145_a((Item)this, this.getFireDelay(gun, player));
            return ActionResult.func_226249_b_((Object)gun);
        }
        return ActionResult.func_226251_d_((Object)gun);
    }

    protected void shoot(World world, PlayerEntity player, ItemStack gun, ItemStack ammo, BulletItem bulletItem, boolean bulletFree) {
        BulletEntity shot = bulletItem.createProjectile(world, ammo, (LivingEntity)player);
        shot.func_234612_a_((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, (float)this.getInaccuracy(gun, player));
        shot.setDamage((shot.getDamage() + this.getBonusDamage(gun, player)) * this.getDamageMultiplier(gun, player));
        shot.setIgnoreInvulnerability(this.ignoreInvulnerability);
        world.func_217376_c((Entity)shot);
    }

    public boolean shouldConsumeAmmo(ItemStack stack, PlayerEntity player) {
        if (this.chanceFreeShot > 0.0 && field_77697_d.nextDouble() < this.chanceFreeShot) {
            return false;
        }
        int preserving = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.preserving, (ItemStack)stack);
        return preserving < 1 || field_77697_d.nextInt(preserving + 2) < 2;
    }

    public double getBonusDamage(ItemStack stack, @Nullable PlayerEntity player) {
        int impact = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.impact, (ItemStack)stack);
        return (double)this.bonusDamage + (impact >= 1 ? 0.5 * (double)(impact + 1) : 0.0);
    }

    public double getDamageMultiplier(ItemStack stack, @Nullable PlayerEntity player) {
        return this.damageMultiplier;
    }

    public int getFireDelay(ItemStack stack, @Nullable PlayerEntity player) {
        return Math.max(1, this.fireDelay - (int)((double)(this.fireDelay * EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.sleightOfHand, (ItemStack)stack)) * 0.15));
    }

    public double getInaccuracy(ItemStack stack, @Nullable PlayerEntity player) {
        return this.inaccuracy / ((double)EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.bullseye, (ItemStack)stack) + 1.0);
    }

    public double getInverseChanceFreeShot(ItemStack stack, @Nullable PlayerEntity player) {
        double chance = 1.0 - this.chanceFreeShot;
        int preserving = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.preserving, (ItemStack)stack);
        if (preserving >= 1) {
            chance *= 2.0 / (double)(preserving + 2);
        }
        return chance;
    }

    protected boolean isDamageModified(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.impact, (ItemStack)stack) >= 1;
    }

    protected boolean isFireDelayModified(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.sleightOfHand, (ItemStack)stack) >= 1;
    }

    protected boolean isInaccuracyModified(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.bullseye, (ItemStack)stack) >= 1;
    }

    protected boolean isChanceFreeShotModified(ItemStack stack) {
        return EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.preserving, (ItemStack)stack) >= 1;
    }

    public GunItem ignoreInvulnerability(boolean ignoreInvulnerability) {
        this.ignoreInvulnerability = ignoreInvulnerability;
        return this;
    }

    public GunItem chanceFreeShot(double chanceFreeShot) {
        this.chanceFreeShot = chanceFreeShot;
        return this;
    }

    public GunItem fireSound(SoundEvent fireSound) {
        this.fireSound = fireSound;
        return this;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment == ModEnchantments.bullseye && this.inaccuracy <= 0.0) {
            return false;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_()) {
            double damageMultiplier = this.getDamageMultiplier(stack, null);
            double damageBonus = this.getBonusDamage(stack, null) * damageMultiplier;
            if (damageMultiplier != 1.0) {
                if (damageBonus != 0.0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gunswithoutroses.gun.damage.both" + (this.isDamageModified(stack) ? ".modified" : ""), new Object[]{String.format(Locale.ROOT, "%.2f", damageMultiplier), String.format(Locale.ROOT, "%.2f", damageBonus)}));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gunswithoutroses.gun.damage.mult" + (this.isDamageModified(stack) ? ".modified" : ""), new Object[]{String.format(Locale.ROOT, "%.2f", damageMultiplier)}));
                }
            } else if (damageBonus != 0.0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gunswithoutroses.gun.damage.flat" + (this.isDamageModified(stack) ? ".modified" : ""), new Object[]{String.format(Locale.ROOT, "%.2f", damageBonus)}));
            }
            int fireDelay = this.getFireDelay(stack, null);
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gunswithoutroses.gun.firerate" + (this.isFireDelayModified(stack) ? ".modified" : ""), new Object[]{fireDelay, 1200 / fireDelay}));
            double inaccuracy = this.getInaccuracy(stack, null);
            if (inaccuracy <= 0.0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gunswithoutroses.gun.accuracy.perfect" + (this.isInaccuracyModified(stack) ? ".modified" : "")));
            } else {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gunswithoutroses.gun.accuracy" + (this.isInaccuracyModified(stack) ? ".modified" : ""), new Object[]{String.format(Locale.ROOT, "%.2f", 1.0 / inaccuracy)}));
            }
            double inverseChanceFree = this.getInverseChanceFreeShot(stack, null);
            if (inverseChanceFree < 1.0) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gunswithoutroses.gun.chance_free" + (this.isChanceFreeShotModified(stack) ? ".modified" : ""), new Object[]{(int)((1.0 - inverseChanceFree) * 100.0)}));
            }
            if (this.ignoreInvulnerability) {
                tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gunswithoutroses.gun.ignore_invulnerability").func_240699_a_(TextFormatting.GRAY));
            }
            this.addExtraStatsTooltip(stack, world, tooltip);
        } else {
            tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.gunswithoutroses.shift"));
        }
    }

    protected void addExtraStatsTooltip(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip) {
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77619_b() {
        return this.enchantability;
    }

    public Predicate<ItemStack> func_220004_b() {
        return BULLETS;
    }

    public int func_230305_d_() {
        return 15;
    }
}

