/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi;

import com.github.franckyi.guapi.IParent;
import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.event.IEventListener;
import com.github.franckyi.guapi.node.TextFieldBase;
import com.github.franckyi.guapi.scene.IBackground;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Scene
implements IScreenEventListener,
IParent {
    private final Set<IEventListener<GuiScreenEvent.MouseClickedEvent>> onMouseClickedListeners;
    private final Set<IEventListener<GuiScreenEvent.MouseReleasedEvent>> onMouseReleasedListeners;
    private final Set<IEventListener<GuiScreenEvent.MouseDragEvent>> onMouseDraggedListeners;
    private final Set<IEventListener<GuiScreenEvent.MouseScrollEvent>> onMouseScrolledListeners;
    private final Set<IEventListener<GuiScreenEvent.KeyboardKeyPressedEvent>> onKeyPressedListeners;
    private final Set<IEventListener<GuiScreenEvent.KeyboardKeyReleasedEvent>> onKeyReleasedListeners;
    private final Set<IEventListener<GuiScreenEvent.KeyboardCharTypedEvent>> onCharTypedListeners;
    private final Set<IEventListener<GuiScreenEvent.InitGuiEvent>> onInitGuiListeners;
    private final Set<IEventListener<GuiScreenEvent.DrawScreenEvent>> onDrawScreenListeners;
    private final Set<IEventListener<GuiScreenEvent.BackgroundDrawnEvent>> onBackgroundDrawnListeners;
    private final Set<IEventListener<GuiScreenEvent.PotionShiftEvent>> onPotionShiftListeners;
    private final Set<Runnable> onGuiClosedListeners;
    private final Set<Runnable> onResizeListeners;
    private final Set<Runnable> onTickListeners;
    private final GUAPIScreen screen = new GUAPIScreen(this);
    private Screen oldScreen;
    private Node content;
    private boolean guiPauseGame;
    private boolean guiCloseWithEscape;
    private IBackground background;

    public Scene() {
        this(null);
    }

    public Scene(Node content) {
        if (content != null) {
            this.content = content;
            content.setParent(this);
        }
        this.guiPauseGame = true;
        this.guiCloseWithEscape = true;
        this.background = IBackground.DEFAULT;
        this.onMouseClickedListeners = new HashSet<IEventListener<GuiScreenEvent.MouseClickedEvent>>();
        this.onMouseReleasedListeners = new HashSet<IEventListener<GuiScreenEvent.MouseReleasedEvent>>();
        this.onMouseDraggedListeners = new HashSet<IEventListener<GuiScreenEvent.MouseDragEvent>>();
        this.onMouseScrolledListeners = new HashSet<IEventListener<GuiScreenEvent.MouseScrollEvent>>();
        this.onKeyPressedListeners = new HashSet<IEventListener<GuiScreenEvent.KeyboardKeyPressedEvent>>();
        this.onKeyReleasedListeners = new HashSet<IEventListener<GuiScreenEvent.KeyboardKeyReleasedEvent>>();
        this.onCharTypedListeners = new HashSet<IEventListener<GuiScreenEvent.KeyboardCharTypedEvent>>();
        this.onInitGuiListeners = new HashSet<IEventListener<GuiScreenEvent.InitGuiEvent>>();
        this.onDrawScreenListeners = new HashSet<IEventListener<GuiScreenEvent.DrawScreenEvent>>();
        this.onBackgroundDrawnListeners = new HashSet<IEventListener<GuiScreenEvent.BackgroundDrawnEvent>>();
        this.onPotionShiftListeners = new HashSet<IEventListener<GuiScreenEvent.PotionShiftEvent>>();
        this.onGuiClosedListeners = new HashSet<Runnable>();
        this.onResizeListeners = new HashSet<Runnable>();
        this.onTickListeners = new HashSet<Runnable>();
    }

    public GUAPIScreen getScreen() {
        return this.screen;
    }

    public Node getContent() {
        return this.content;
    }

    public void setContent(Node content) {
        if (this.getContent() != null) {
            this.getContent().setParent(null);
        }
        this.content = content;
        if (content != null) {
            content.setParent(this);
        }
    }

    public boolean doesGuiPauseGame() {
        return this.guiPauseGame;
    }

    public void setGuiPauseGame(boolean guiPauseGame) {
        this.guiPauseGame = guiPauseGame;
    }

    public boolean doesGuiCloseWithEscape() {
        return this.guiCloseWithEscape;
    }

    public void setGuiCloseWithEscape(boolean guiCloseWithEscape) {
        this.guiCloseWithEscape = guiCloseWithEscape;
    }

    public boolean isContentFullScreen() {
        return this.getContent() != null && this.getContent().getPrefWidth() == this.getScreen().field_230708_k_ - this.getContent().getMargin().getHorizontal() && this.getContent().getPrefHeight() == this.getScreen().field_230709_l_ - this.getContent().getMargin().getVertical();
    }

    public void setContentFullScreen() {
        if (this.getContent() != null) {
            this.getContent().setPrefSize(this.getScreen().field_230708_k_ - this.getContent().getMargin().getHorizontal(), this.getScreen().field_230709_l_ - this.getContent().getMargin().getVertical());
        }
    }

    public IBackground getBackground() {
        return this.background;
    }

    public void setBackground(IBackground background) {
        this.background = background;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.MouseClickedEvent>> getOnMouseClickedListeners() {
        return this.onMouseClickedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.MouseReleasedEvent>> getOnMouseReleasedListeners() {
        return this.onMouseReleasedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.MouseDragEvent>> getOnMouseDraggedListeners() {
        return this.onMouseDraggedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.MouseScrollEvent>> getOnMouseScrolledListeners() {
        return this.onMouseScrolledListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.KeyboardKeyPressedEvent>> getOnKeyPressedListeners() {
        return this.onKeyPressedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.KeyboardKeyReleasedEvent>> getOnKeyReleasedListeners() {
        return this.onKeyReleasedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.KeyboardCharTypedEvent>> getOnCharTypedListeners() {
        return this.onCharTypedListeners;
    }

    public Set<IEventListener<GuiScreenEvent.InitGuiEvent>> getOnInitGuiListeners() {
        return this.onInitGuiListeners;
    }

    public Set<IEventListener<GuiScreenEvent.DrawScreenEvent>> getOnDrawScreenListeners() {
        return this.onDrawScreenListeners;
    }

    public Set<IEventListener<GuiScreenEvent.BackgroundDrawnEvent>> getOnBackgroundDrawnListeners() {
        return this.onBackgroundDrawnListeners;
    }

    public Set<IEventListener<GuiScreenEvent.PotionShiftEvent>> getOnPotionShiftListeners() {
        return this.onPotionShiftListeners;
    }

    public Set<Runnable> getOnGuiClosedListeners() {
        return this.onGuiClosedListeners;
    }

    public Set<Runnable> getOnResizeListeners() {
        return this.onResizeListeners;
    }

    public Set<Runnable> getOnTickListeners() {
        return this.onTickListeners;
    }

    protected void onInitGui(GuiScreenEvent.InitGuiEvent event) {
        this.getOnInitGuiListeners().forEach(listener -> listener.handle(event));
    }

    protected void onDrawScreen(GuiScreenEvent.DrawScreenEvent event) {
        this.getOnDrawScreenListeners().forEach(listener -> listener.handle(event));
    }

    protected void onBackgroundDrawn(GuiScreenEvent.BackgroundDrawnEvent event) {
        this.getOnBackgroundDrawnListeners().forEach(listener -> listener.handle(event));
    }

    protected void onPotionShift(GuiScreenEvent.PotionShiftEvent event) {
        this.getOnPotionShiftListeners().forEach(listener -> listener.handle(event));
    }

    @Override
    public boolean onKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent event) {
        this.getScreen().func_231046_a_(event.getKeyCode(), event.getScanCode(), event.getModifiers());
        return IScreenEventListener.super.onKeyPressed(event);
    }

    protected void onGuiClosed() {
        this.getOnGuiClosedListeners().forEach(Runnable::run);
    }

    protected void onResize() {
        this.getOnResizeListeners().forEach(Runnable::run);
    }

    protected void onTick() {
        this.getOnTickListeners().forEach(Runnable::run);
        if (this.content instanceof IParent) {
            this.tick((IParent)((Object)this.content));
        }
    }

    private void tick(IParent parent) {
        for (IScreenEventListener iScreenEventListener : parent.getChildren()) {
            if (iScreenEventListener instanceof TextFieldBase) {
                ((TextFieldBase)iScreenEventListener).tick();
                continue;
            }
            if (!(iScreenEventListener instanceof IParent)) continue;
            this.tick((IParent)((Object)iScreenEventListener));
        }
    }

    public void show() {
        this.oldScreen = Scene.mc.field_71462_r;
        mc.func_147108_a((Screen)this.screen);
    }

    public void close() {
        mc.func_147108_a(this.oldScreen);
    }

    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        if (this.getContent() != null && this.getContent().isVisible()) {
            this.getContent().render(matrixStack, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void updateChildrenPos() {
        if (this.getContent() != null) {
            this.getContent().setPosition(this.content.getMargin().getLeft(), this.content.getMargin().getTop());
        }
    }

    public List<IScreenEventListener> getChildren() {
        return Collections.singletonList(this.content);
    }

    public static class GUAPIScreen
    extends Screen {
        private final Scene scene;
        private final Set<Tooltip> tooltips;

        public GUAPIScreen(Scene scene) {
            super(ITextComponent.func_244388_a((String)""));
            this.scene = scene;
            this.tooltips = new HashSet<Tooltip>();
        }

        public Scene getScene() {
            return this.scene;
        }

        public void func_231158_b_(Minecraft mc, int width, int height) {
            boolean flag = this.getScene().isContentFullScreen();
            super.func_231158_b_(mc, width, height);
            if (flag) {
                this.getScene().setContentFullScreen();
            } else {
                this.getScene().updateChildrenPos();
            }
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.getScene().getBackground().draw(this, matrixStack);
            this.getScene().render(matrixStack, mouseX, mouseY, partialTicks);
            this.tooltips.forEach(tooltip -> this.renderToolTip(matrixStack, Lists.transform((List)((Tooltip)tooltip).textLines, ITextComponent::func_241878_f), mouseX, mouseY, this.field_230712_o_));
            this.tooltips.clear();
        }

        public boolean func_231178_ax__() {
            return this.getScene().doesGuiCloseWithEscape();
        }

        public boolean func_231177_au__() {
            return this.getScene().doesGuiPauseGame();
        }

        public void func_231164_f_() {
            this.getScene().onGuiClosed();
            super.func_231164_f_();
        }

        public void func_231152_a_(Minecraft mcIn, int w, int h) {
            super.func_231152_a_(mcIn, w, h);
            this.getScene().onResize();
        }

        public void func_231023_e_() {
            this.getScene().onTick();
        }

        public void func_230457_a_(MatrixStack matrixStack, ItemStack stack, int x, int y) {
            super.func_230457_a_(matrixStack, stack, x, y);
        }

        public void func_238652_a_(MatrixStack matrixStack, ITextComponent text, int x, int y) {
            this.tooltips.add(new Tooltip(Collections.singletonList(text), x, y, this.field_230712_o_));
        }

        public void func_243308_b(MatrixStack matrixStack, List<ITextComponent> text, int x, int y) {
            this.tooltips.add(new Tooltip(text, x, y, this.field_230712_o_));
        }

        public void renderTooltip(String text, int x, int y) {
            this.tooltips.add(Tooltip.create(Collections.singletonList(text), x, y, this.field_230712_o_));
        }

        public void renderTooltip(List<String> textLines, int x, int y) {
            this.tooltips.add(Tooltip.create(textLines, x, y, this.field_230712_o_));
        }

        public void renderTooltip(List<String> textLines, int x, int y, FontRenderer font) {
            this.tooltips.add(Tooltip.create(textLines, x, y, font));
        }

        private static class Tooltip {
            private final List<ITextComponent> textLines;
            private final int x;
            private final int y;
            private final FontRenderer font;

            private Tooltip(List<ITextComponent> textLines, int x, int y, FontRenderer font) {
                this.textLines = textLines;
                this.x = x;
                this.y = y;
                this.font = font;
            }

            private static Tooltip create(List<String> textLines, int x, int y, FontRenderer font) {
                return new Tooltip(textLines.stream().map(ITextComponent::func_244388_a).collect(Collectors.toList()), x, y, font);
            }
        }
    }

    public static class ScreenEventHandler {
        @SubscribeEvent
        public static void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
            ScreenEventHandler.handle(event, Scene::onInitGui);
        }

        @SubscribeEvent
        public static void onDrawScreen(GuiScreenEvent.DrawScreenEvent.Post event) {
            ScreenEventHandler.handle(event, Scene::onDrawScreen);
        }

        @SubscribeEvent
        public static void onBackgroundDrawn(GuiScreenEvent.BackgroundDrawnEvent event) {
            ScreenEventHandler.handle(event, Scene::onBackgroundDrawn);
        }

        @SubscribeEvent
        public static void onPotionShift(GuiScreenEvent.PotionShiftEvent event) {
            ScreenEventHandler.handle(event, Scene::onPotionShift);
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
            ScreenEventHandler.handle(event, IScreenEventListener::onMouseClicked);
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onMouseReleased(GuiScreenEvent.MouseReleasedEvent.Pre event) {
            ScreenEventHandler.handle(event, IScreenEventListener::onMouseReleased);
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onMouseDragged(GuiScreenEvent.MouseDragEvent.Pre event) {
            ScreenEventHandler.handle(event, IScreenEventListener::onMouseDragged);
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onMouseScrolled(GuiScreenEvent.MouseScrollEvent.Pre event) {
            ScreenEventHandler.handle(event, IScreenEventListener::onMouseScrolled);
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onKeyboardKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
            ScreenEventHandler.handle(event, Scene::onKeyPressed);
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onKeyboardKeyReleased(GuiScreenEvent.KeyboardKeyReleasedEvent.Pre event) {
            ScreenEventHandler.handle(event, IScreenEventListener::onKeyReleased);
        }

        @SubscribeEvent(priority=EventPriority.HIGH)
        public static void onKeyboardCharTyped(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
            ScreenEventHandler.handle(event, IScreenEventListener::onCharTyped);
        }

        private static <T extends GuiScreenEvent> void handle(T event, BiConsumer<Scene, T> eh) {
            Scene scene;
            if (event != null && event.getGui() instanceof GUAPIScreen && (scene = ((GUAPIScreen)event.getGui()).getScene()) != null) {
                eh.accept(scene, (Scene)event);
            }
        }
    }
}

