/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.gui.IGuiView;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.util.text.ITextComponent;

public class Button
extends Node<GuiButtonView> {
    protected Button(GuiButtonView view) {
        super(view);
        this.computeSize();
        this.updateSize();
    }

    public Button(String text) {
        this(text, new String[0]);
    }

    public Button(String text, String ... tooltip) {
        this(new GuiButtonView(text, tooltip));
    }

    public Button() {
        this("Button");
    }

    public String getText() {
        return ((GuiButtonView)this.getView()).func_230458_i_().getString();
    }

    public void setText(String text) {
        ((GuiButtonView)this.getView()).func_238482_a_(ITextComponent.func_244388_a((String)text));
        this.computeWidth();
        this.updateWidth();
    }

    public boolean isDisabled() {
        return !((GuiButtonView)this.getView()).field_230693_o_;
    }

    public void setDisabled(boolean disabled) {
        ((GuiButtonView)this.getView()).field_230693_o_ = !disabled;
    }

    public List<ITextComponent> getTooltipText() {
        return ((GuiButtonView)this.getView()).tooltipText;
    }

    @Override
    protected void computeWidth() {
        this.setComputedWidth(Button.mc.field_71466_p.func_78256_a(this.getText()) + this.getPadding().getVertical() + 10);
    }

    @Override
    protected void computeHeight() {
        this.setComputedHeight(20 + this.getPadding().getHorizontal());
    }

    public static class GuiButtonView
    extends net.minecraft.client.gui.widget.button.Button
    implements IGuiView {
        protected final List<ITextComponent> tooltipText;

        public GuiButtonView(String text, String[] tooltip) {
            super(0, 0, 0, 0, ITextComponent.func_244388_a((String)text), b -> {});
            this.tooltipText = Stream.of(tooltip).map(ITextComponent::func_244388_a).collect(Collectors.toList());
        }

        @Override
        public int getViewX() {
            return this.field_230690_l_;
        }

        @Override
        public void setViewX(int x) {
            this.field_230690_l_ = x;
        }

        @Override
        public int getViewY() {
            return this.field_230691_m_;
        }

        @Override
        public void setViewY(int y) {
            this.field_230691_m_ = y;
        }

        @Override
        public int getViewWidth() {
            return super.func_230998_h_();
        }

        @Override
        public void setViewWidth(int width) {
            super.func_230991_b_(width);
        }

        @Override
        public int getViewHeight() {
            return this.field_230689_k_;
        }

        @Override
        public void setViewHeight(int height) {
            this.field_230689_k_ = height;
        }

        @Override
        public boolean isViewVisible() {
            return this.field_230694_p_;
        }

        @Override
        public void setViewVisible(boolean visible) {
            this.field_230694_p_ = visible;
        }

        @Override
        public void renderView(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            if (this.func_230449_g_() && !this.tooltipText.isEmpty()) {
                IScreenEventListener.mc.field_71462_r.func_243308_b(matrixStack, this.tooltipText, mouseX, mouseY);
            }
        }
    }
}

