/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.IValueNode;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.Scene;
import com.github.franckyi.guapi.gui.IGuiView;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.gui.GuiUtils;

public class CheckBox
extends Node<GuiCheckBoxView>
implements IValueNode<Boolean> {
    private final Set<BiConsumer<Boolean, Boolean>> onValueChangedListeners = new HashSet<BiConsumer<Boolean, Boolean>>();

    public CheckBox() {
        this("", false);
    }

    public CheckBox(String text) {
        this(text, false);
    }

    public CheckBox(boolean checked) {
        this("", checked);
    }

    public CheckBox(String text, boolean checked) {
        super(new GuiCheckBoxView(text, checked, new String[0]));
        this.computeSize();
        this.updateSize();
    }

    public String getText() {
        return ((GuiCheckBoxView)this.getView()).func_230458_i_().getString();
    }

    public void setText(String text) {
        ((GuiCheckBoxView)this.getView()).func_238482_a_(ITextComponent.func_244388_a((String)text));
    }

    public boolean getValue() {
        return ((GuiCheckBoxView)this.getView()).isChecked();
    }

    public void setValue(boolean checked) {
        boolean old = this.getValue();
        ((GuiCheckBoxView)this.getView()).setChecked(checked);
        if (old != checked) {
            this.onValueChanged(old, checked);
        }
    }

    public List<String> getTooltipText() {
        return ((GuiCheckBoxView)this.getView()).tooltipText;
    }

    public boolean isDisabled() {
        return !((GuiCheckBoxView)this.getView()).field_230693_o_;
    }

    public void setDisabled(boolean disabled) {
        ((GuiCheckBoxView)this.getView()).field_230693_o_ = !disabled;
    }

    public int getSpacing() {
        return ((GuiCheckBoxView)this.getView()).spacing;
    }

    public void setSpacing(int spacing) {
        ((GuiCheckBoxView)this.getView()).spacing = spacing;
    }

    @Override
    protected void computeWidth() {
        this.setComputedWidth(11 + this.getSpacing() + CheckBox.mc.field_71466_p.func_78256_a(this.getText()));
    }

    @Override
    protected void computeHeight() {
        this.setComputedHeight(11);
    }

    @Override
    public boolean onMouseClicked(GuiScreenEvent.MouseClickedEvent event) {
        if (super.onMouseClicked(event)) {
            this.setValue(!this.getValue());
            return true;
        }
        return false;
    }

    @Override
    public Set<BiConsumer<Boolean, Boolean>> getOnValueChangedListeners() {
        return this.onValueChangedListeners;
    }

    public static class GuiCheckBoxView
    extends Button
    implements IGuiView {
        private int spacing = 4;
        private boolean checked;
        private final List<String> tooltipText;
        private Scene.GUAPIScreen screen;

        public GuiCheckBoxView(String displayString, boolean checked, String ... tooltipText) {
            super(0, 0, 0, 0, ITextComponent.func_244388_a((String)displayString), b -> {});
            this.checked = checked;
            this.tooltipText = Lists.newArrayList((Object[])tooltipText);
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        @Override
        public int getViewX() {
            return this.field_230690_l_;
        }

        @Override
        public void setViewX(int x) {
            this.field_230690_l_ = x;
        }

        @Override
        public int getViewY() {
            return this.field_230691_m_;
        }

        @Override
        public void setViewY(int y) {
            this.field_230691_m_ = y;
        }

        @Override
        public int getViewWidth() {
            return super.func_230998_h_();
        }

        @Override
        public void setViewWidth(int width) {
            super.func_230991_b_(width);
        }

        @Override
        public int getViewHeight() {
            return this.field_230689_k_;
        }

        @Override
        public void setViewHeight(int height) {
            this.field_230689_k_ = height;
        }

        @Override
        public boolean isViewVisible() {
            return this.field_230694_p_;
        }

        @Override
        public void setViewVisible(boolean visible) {
            this.field_230694_p_ = visible;
        }

        @Override
        public void renderView(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            int boxSize = this.field_230689_k_;
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)field_230687_i_, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (int)46, (int)boxSize, (int)this.field_230689_k_, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.func_230927_p_());
            if (this.checked) {
                GuiCheckBoxView.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)IScreenEventListener.mc.field_71466_p, (String)"x", (int)(this.field_230690_l_ + boxSize / 2 + 1), (int)(this.field_230691_m_ + 1), (int)0xE0E0E0);
            }
            GuiCheckBoxView.func_238475_b_((MatrixStack)matrixStack, (FontRenderer)IScreenEventListener.mc.field_71466_p, (ITextComponent)this.func_230458_i_(), (int)(this.field_230690_l_ + boxSize + this.spacing), (int)(this.field_230691_m_ + 2), (int)0xFFFFFF);
            if (this.inBounds(mouseX, mouseY)) {
                if (this.screen == null) {
                    this.screen = (Scene.GUAPIScreen)IScreenEventListener.mc.field_71462_r;
                }
                this.screen.renderTooltip(this.tooltipText, mouseX, mouseY);
            }
        }
    }
}

