/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.IValueNode;
import com.github.franckyi.guapi.node.Button;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.client.gui.FontRenderer;
import net.minecraftforge.client.event.GuiScreenEvent;

public class EnumButton<T>
extends Button
implements IValueNode<T> {
    private List<T> values;
    private T value;
    private int index;
    private Function<T, String> renderer;
    private final Set<BiConsumer<T, T>> onValueChangedListeners;

    @SafeVarargs
    public EnumButton(T ... values) {
        this((List<T>)new ArrayList<T>(Arrays.asList(values)));
    }

    public EnumButton(List<T> values) {
        this.values = values;
        this.renderer = Objects::toString;
        this.index = 0;
        this.onValueChangedListeners = new HashSet<BiConsumer<T, T>>();
        if (!values.isEmpty()) {
            this.value = values.get(0);
        }
        this.updateText();
    }

    public List<T> getValues() {
        return this.values;
    }

    public void setValues(List<T> values) {
        this.values = values;
        if (values.contains(this.value)) {
            this.index = this.getValues().indexOf(this.value);
        }
    }

    public T getValue() {
        return this.value;
    }

    public void setValue(T value) {
        if (this.values.contains(value)) {
            T old = this.value;
            this.value = value;
            this.index = this.getValues().indexOf(value);
            this.updateText();
            if (old != value) {
                this.onValueChanged(old, value);
            }
        }
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        if (index < this.values.size()) {
            this.index = index;
            this.value = this.getValues().get(index);
            this.updateText();
        }
    }

    public Function<T, String> getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Function<T, String> renderer) {
        this.renderer = renderer;
        this.updateText();
    }

    private void updateText() {
        if (this.getValue() != null) {
            this.setText(this.getRenderer().apply(this.getValue()));
        }
    }

    private void cycleValue() {
        T oldVal = this.value;
        if (this.getIndex() == this.getValues().size() - 1) {
            this.setIndex(0);
        } else {
            this.setIndex(this.getIndex() + 1);
        }
        T newVal = this.value;
        if (oldVal != newVal) {
            this.onValueChanged(oldVal, newVal);
        }
    }

    @Override
    public boolean onMouseClicked(GuiScreenEvent.MouseClickedEvent event) {
        if (super.onMouseClicked(event)) {
            this.cycleValue();
            return true;
        }
        return false;
    }

    @Override
    protected void computeWidth() {
        if (this.getValues() != null && !this.getValues().isEmpty()) {
            this.setComputedWidth(this.getValues().stream().map(this.getRenderer()).mapToInt(arg_0 -> ((FontRenderer)EnumButton.mc.field_71466_p).func_78256_a(arg_0)).max().orElse(0) + 10);
        } else if (this.value != null) {
            this.setComputedWidth(EnumButton.mc.field_71466_p.func_78256_a(this.renderer.apply(this.value)) + 10);
        } else {
            this.setComputedWidth(0);
        }
    }

    @Override
    public Set<BiConsumer<T, T>> getOnValueChangedListeners() {
        return this.onValueChangedListeners;
    }
}

