/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.gui.AbstractGuiView;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;

public class Label
extends Node<GuiLabelView> {
    public Label(String text) {
        this(text, 0xFFFFFF);
    }

    public Label(String text, int color) {
        super(new GuiLabelView(text, color));
        this.computeSize();
        this.updateSize();
    }

    public Label(String text, Color color) {
        this(text, color.getRGB());
    }

    public String getText() {
        return ((GuiLabelView)this.getView()).text;
    }

    public void setText(String text) {
        if (!((GuiLabelView)this.getView()).text.equals(text)) {
            ((GuiLabelView)this.getView()).text = text;
            this.computeWidth();
            this.updateWidth();
        }
    }

    public int getColor() {
        return ((GuiLabelView)this.getView()).color;
    }

    public void setColor(int color) {
        ((GuiLabelView)this.getView()).color = color;
    }

    public void setColor(Color color) {
        this.setColor(color.getRGB());
    }

    public boolean isCentered() {
        return ((GuiLabelView)this.getView()).centered;
    }

    public void setCentered(boolean centered) {
        ((GuiLabelView)this.getView()).centered = centered;
    }

    @Override
    protected void computeWidth() {
        this.setComputedWidth(Label.mc.field_71466_p.func_78256_a(((GuiLabelView)this.getView()).text) + this.getPadding().getVertical());
    }

    @Override
    protected void computeHeight() {
        Label.mc.field_71466_p.getClass();
        this.setComputedHeight(9 + this.getPadding().getHorizontal());
    }

    public static class GuiLabelView
    extends AbstractGuiView {
        private String text;
        private boolean centered;
        private int color;

        public GuiLabelView(String text, int color) {
            this.text = text;
            this.color = color;
        }

        @Override
        public void renderView(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.visible) {
                RenderSystem.enableBlend();
                RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                int i = this.y + this.height / 2 - 4;
                if (this.centered) {
                    GuiLabelView.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)IScreenEventListener.mc.field_71466_p, (String)this.text, (int)(this.x + this.width / 2), (int)i, (int)this.color);
                } else {
                    GuiLabelView.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)IScreenEventListener.mc.field_71466_p, (String)this.text, (int)this.x, (int)i, (int)this.color);
                }
            }
        }
    }
}

