/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.IParent;
import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.event.IEventListener;
import com.github.franckyi.guapi.gui.IGuiView;
import com.github.franckyi.guapi.math.Insets;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ListExtended<E extends ExtendedList.AbstractListEntry>
extends Node<GuiListExtendedView>
implements IParent {
    private int lazySlotHeight;

    public ListExtended(int slotHeight) {
        super(new GuiListExtendedView(slotHeight));
        this.lazySlotHeight = slotHeight;
        this.computeSize();
        this.updateSize();
    }

    public int getSlotHeight() {
        return this.lazySlotHeight;
    }

    public void setSlotHeight(int slotHeight) {
        if (this.lazySlotHeight != slotHeight) {
            try {
                ((GuiListExtendedView)this.getView()).setSlotHeight(slotHeight);
                this.lazySlotHeight = slotHeight;
                this.computeHeight();
                this.updateHeight();
            }
            catch (ObfuscationReflectionHelper.UnableToAccessFieldException | ObfuscationReflectionHelper.UnableToFindFieldException e) {
                e.printStackTrace();
            }
        }
    }

    public Insets getOffset() {
        return ((GuiListExtendedView)this.getView()).getOffset();
    }

    public void setOffset(Insets offset) {
        ((GuiListExtendedView)this.getView()).setOffset(offset);
    }

    @Override
    public void updateChildrenPos() {
        this.computeSize();
        this.updateSize();
    }

    public List<E> getChildren() {
        return ((GuiListExtendedView)this.getView()).func_231039_at__();
    }

    @Override
    protected void computeWidth() {
        this.setComputedWidth(200);
    }

    @Override
    protected void computeHeight() {
        this.setComputedHeight(200);
    }

    public static class NodeEntry<T extends Node<?>>
    extends ExtendedList.AbstractListEntry<NodeEntry<T>>
    implements IScreenEventListener,
    IParent {
        private final Set<IEventListener<GuiScreenEvent.MouseClickedEvent>> onMouseClickedListeners;
        private final Set<IEventListener<GuiScreenEvent.MouseReleasedEvent>> onMouseReleasedListeners;
        private final Set<IEventListener<GuiScreenEvent.MouseDragEvent>> onMouseDraggedListeners;
        private final Set<IEventListener<GuiScreenEvent.MouseScrollEvent>> onMouseScrolledListeners;
        private final Set<IEventListener<GuiScreenEvent.KeyboardKeyPressedEvent>> onKeyPressedListeners;
        private final Set<IEventListener<GuiScreenEvent.KeyboardKeyReleasedEvent>> onKeyReleasedListeners;
        private final Set<IEventListener<GuiScreenEvent.KeyboardCharTypedEvent>> onCharTypedListeners;
        private final T node;

        public NodeEntry(T node) {
            this.node = node;
            ((Node)node).setParent(this);
            this.onMouseClickedListeners = new HashSet<IEventListener<GuiScreenEvent.MouseClickedEvent>>();
            this.onMouseReleasedListeners = new HashSet<IEventListener<GuiScreenEvent.MouseReleasedEvent>>();
            this.onMouseDraggedListeners = new HashSet<IEventListener<GuiScreenEvent.MouseDragEvent>>();
            this.onMouseScrolledListeners = new HashSet<IEventListener<GuiScreenEvent.MouseScrollEvent>>();
            this.onKeyPressedListeners = new HashSet<IEventListener<GuiScreenEvent.KeyboardKeyPressedEvent>>();
            this.onKeyReleasedListeners = new HashSet<IEventListener<GuiScreenEvent.KeyboardKeyReleasedEvent>>();
            this.onCharTypedListeners = new HashSet<IEventListener<GuiScreenEvent.KeyboardCharTypedEvent>>();
        }

        public T getNode() {
            return this.node;
        }

        protected GuiListExtendedView<NodeEntry<T>> getList() {
            return (GuiListExtendedView)this.field_230666_a_;
        }

        public void func_230432_a_(MatrixStack matrixStack, int index, int entryTop, int entryLeft, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
            GuiListExtendedView<NodeEntry<T>> list = this.getList();
            int width = entryWidth - list.getOffset().getHorizontal() - 5;
            if (entryLeft != ((Node)this.node).getX() || entryTop != ((Node)this.node).getY()) {
                ((Node)this.node).setPosition(entryLeft + 4, entryTop);
            }
            if (width != ((Node)this.node).getWidth() || entryHeight != ((Node)this.node).getHeight()) {
                ((Node)this.node).setPrefSize(width - 10, entryHeight);
            }
            ((Node)this.node).render(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public Set<IEventListener<GuiScreenEvent.MouseClickedEvent>> getOnMouseClickedListeners() {
            return this.onMouseClickedListeners;
        }

        @Override
        public Set<IEventListener<GuiScreenEvent.MouseReleasedEvent>> getOnMouseReleasedListeners() {
            return this.onMouseReleasedListeners;
        }

        @Override
        public Set<IEventListener<GuiScreenEvent.MouseDragEvent>> getOnMouseDraggedListeners() {
            return this.onMouseDraggedListeners;
        }

        @Override
        public Set<IEventListener<GuiScreenEvent.MouseScrollEvent>> getOnMouseScrolledListeners() {
            return this.onMouseScrolledListeners;
        }

        @Override
        public Set<IEventListener<GuiScreenEvent.KeyboardKeyPressedEvent>> getOnKeyPressedListeners() {
            return this.onKeyPressedListeners;
        }

        @Override
        public Set<IEventListener<GuiScreenEvent.KeyboardKeyReleasedEvent>> getOnKeyReleasedListeners() {
            return this.onKeyReleasedListeners;
        }

        @Override
        public Set<IEventListener<GuiScreenEvent.KeyboardCharTypedEvent>> getOnCharTypedListeners() {
            return this.onCharTypedListeners;
        }

        @Override
        public boolean onMouseClicked(GuiScreenEvent.MouseClickedEvent event) {
            if (((Node)this.node).getView().isViewVisible() && ((Node)this.node).getView().func_231044_a_(event.getMouseX(), event.getMouseY(), event.getButton())) {
                IScreenEventListener.super.onMouseClicked(event);
                ((Node)this.node).onMouseClicked(event);
                return true;
            }
            return false;
        }

        @Override
        public boolean onMouseReleased(GuiScreenEvent.MouseReleasedEvent event) {
            if (((Node)this.node).getView().isViewVisible() && ((Node)this.node).getView().func_231048_c_(event.getMouseX(), event.getMouseY(), event.getButton())) {
                IScreenEventListener.super.onMouseReleased(event);
                ((Node)this.node).onMouseReleased(event);
                return true;
            }
            return false;
        }

        @Override
        public boolean onMouseDragged(GuiScreenEvent.MouseDragEvent event) {
            if (((Node)this.node).getView().isViewVisible() && ((Node)this.node).getView().func_231045_a_(event.getMouseX(), event.getMouseY(), event.getMouseButton(), event.getDragX(), event.getDragY())) {
                IScreenEventListener.super.onMouseDragged(event);
                ((Node)this.node).onMouseDragged(event);
                return true;
            }
            return false;
        }

        @Override
        public boolean onMouseScrolled(GuiScreenEvent.MouseScrollEvent event) {
            if (((Node)this.node).getView().isViewVisible() && ((Node)this.node).getView().func_231043_a_(event.getMouseX(), event.getMouseY(), event.getScrollDelta())) {
                IScreenEventListener.super.onMouseScrolled(event);
                ((Node)this.node).onMouseScrolled(event);
                return true;
            }
            return false;
        }

        @Override
        public boolean onKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent event) {
            if (((Node)this.node).getView().isViewVisible() && ((Node)this.node).getView().func_231046_a_(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
                IScreenEventListener.super.onKeyPressed(event);
                ((Node)this.node).onKeyPressed(event);
                return true;
            }
            return false;
        }

        @Override
        public boolean onKeyReleased(GuiScreenEvent.KeyboardKeyReleasedEvent event) {
            if (((Node)this.node).getView().isViewVisible() && ((Node)this.node).getView().func_223281_a_(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
                IScreenEventListener.super.onKeyReleased(event);
                ((Node)this.node).onKeyReleased(event);
                return true;
            }
            return false;
        }

        @Override
        public boolean onCharTyped(GuiScreenEvent.KeyboardCharTypedEvent event) {
            if (((Node)this.node).getView().isViewVisible() && ((Node)this.node).getView().func_231042_a_(event.getCodePoint(), event.getModifiers())) {
                IScreenEventListener.super.onCharTyped(event);
                ((Node)this.node).onCharTyped(event);
                return true;
            }
            return false;
        }

        @Override
        public void updateChildrenPos() {
            ((Node)this.getNode()).computeSize();
            ((Node)this.getNode()).updateSize();
            if (this.getNode() instanceof IParent) {
                ((IParent)this.getNode()).updateChildrenPos();
            }
        }

        @Override
        public List<? extends IScreenEventListener> getChildren() {
            return Collections.singletonList(this.node);
        }
    }

    public static class GuiListExtendedView<E extends ExtendedList.AbstractListEntry<E>>
    extends ExtendedList<E>
    implements IGuiView {
        private Insets offset = Insets.NONE;
        private boolean visible = true;
        private int realHeight;

        public GuiListExtendedView(int slotHeight) {
            super(IScreenEventListener.mc, 0, 0, 0, 0, slotHeight);
        }

        public void setSlotHeight(int slotHeight) {
            ObfuscationReflectionHelper.setPrivateValue(AbstractList.class, (Object)this, (Object)slotHeight, (String)"itemHeight");
        }

        public Insets getOffset() {
            return this.offset;
        }

        public void setOffset(Insets offset) {
            int x = this.getViewX();
            int y = this.getViewY();
            this.offset = offset;
            this.field_230675_l_ = x + offset.getLeft();
            this.field_230674_k_ = x + this.field_230670_d_ - offset.getRight();
            this.field_230672_i_ = y + offset.getTop();
            this.field_230673_j_ = y + this.realHeight - offset.getBottom();
        }

        @Override
        public int getViewX() {
            return this.field_230675_l_ - this.offset.getLeft();
        }

        @Override
        public void setViewX(int x) {
            this.field_230675_l_ = x + this.offset.getLeft();
            this.field_230674_k_ = x + this.field_230670_d_ - this.offset.getRight();
        }

        @Override
        public int getViewY() {
            return this.field_230672_i_ - this.offset.getTop();
        }

        @Override
        public void setViewY(int y) {
            this.field_230672_i_ = y + this.offset.getTop();
            this.field_230673_j_ = y + this.realHeight - this.offset.getBottom();
        }

        @Override
        public int getViewWidth() {
            return this.field_230670_d_;
        }

        @Override
        public void setViewWidth(int width) {
            this.field_230670_d_ = width;
            this.field_230674_k_ = this.field_230675_l_ + width;
        }

        @Override
        public int getViewHeight() {
            return this.realHeight;
        }

        @Override
        public void setViewHeight(int height) {
            this.realHeight = height;
            this.field_230673_j_ = this.field_230672_i_ + height;
        }

        @Override
        public boolean isViewVisible() {
            return this.visible;
        }

        @Override
        public void setViewVisible(boolean visible) {
            this.visible = visible;
        }

        protected int func_230952_d_() {
            return this.field_230674_k_ - 7;
        }

        public int func_230949_c_() {
            return this.getWidth();
        }

        @Override
        public void renderView(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }

        @Override
        public boolean func_223281_a_(int p_keyReleased_1_, int p_keyReleased_2_, int p_keyReleased_3_) {
            return super.func_223281_a_(p_keyReleased_1_, p_keyReleased_2_, p_keyReleased_3_);
        }

        @Override
        public boolean func_231042_a_(char charTyped, int modifiers) {
            return IGuiView.super.func_231042_a_(charTyped, modifiers);
        }

        public void setHeight(int height) {
            this.field_230671_e_ = height;
        }
    }
}

