/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client;

import com.github.franckyi.ibeeditor.client.ClientUtils;
import com.github.franckyi.ibeeditor.client.gui.editor.block.BlockEditor;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.EntityEditor;
import com.github.franckyi.ibeeditor.client.gui.editor.item.ItemEditor;
import com.github.franckyi.ibeeditor.common.IBEConfiguration;
import com.github.franckyi.ibeeditor.common.network.IBENetworkHandler;
import com.github.franckyi.ibeeditor.common.network.editor.block.InitBlockEditorRequest;
import com.github.franckyi.ibeeditor.common.network.editor.item.BlockInventoryItemEditorMessage;
import com.github.franckyi.ibeeditor.common.network.editor.item.EntityInventoryItemEditorMessage;
import com.github.franckyi.ibeeditor.common.network.editor.item.MainHandItemEditorMessage;
import com.github.franckyi.ibeeditor.common.network.editor.item.PlayerInventoryItemEditorMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.items.CapabilityItemHandler;

public final class EditorHelper {
    private static final ITextComponent MUST_CREATIVE = ITextComponent.func_244388_a((String)(TextFormatting.RED + "You must be in creative mode in order to use the editor."));
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static boolean serverEnabled;
    private static BlockPos warningPos;

    public static boolean openEditor() {
        return EditorHelper.openEntityEditor() || EditorHelper.openBlockEditor() || EditorHelper.openItemEditor() || EditorHelper.openSelfEditor();
    }

    public static boolean openItemEditor() {
        ItemStack heldItem = EditorHelper.mc.field_71439_g.func_184614_ca();
        if (!heldItem.func_190926_b()) {
            EditorHelper.openItemEditorMainHand(heldItem);
            return true;
        }
        return false;
    }

    public static boolean openEntityEditor() {
        RayTraceResult res = EditorHelper.mc.field_71476_x;
        if (res instanceof EntityRayTraceResult) {
            EditorHelper.openEntityEditor(((EntityRayTraceResult)res).func_216348_a());
            return true;
        }
        return false;
    }

    public static boolean openBlockEditor() {
        BlockRayTraceResult block;
        RayTraceResult res = EditorHelper.mc.field_71476_x;
        if (res instanceof BlockRayTraceResult && !EditorHelper.mc.field_71441_e.func_175623_d((block = (BlockRayTraceResult)res).func_216350_a())) {
            EditorHelper.openBlockEditor(block.func_216350_a());
            return true;
        }
        return false;
    }

    public static boolean openSelfEditor() {
        EditorHelper.openEntityEditor((Entity)EditorHelper.mc.field_71439_g);
        return true;
    }

    private static void openItemEditorMainHand(ItemStack itemStack) {
        if (EditorHelper.checkPermissions()) {
            if (EditorHelper.isServerEnabled()) {
                ItemEditor.withConsumer(itemStack, itemStack1 -> IBENetworkHandler.getModChannel().sendToServer((Object)new MainHandItemEditorMessage((ItemStack)itemStack1)));
            } else if (EditorHelper.mc.field_71442_b.func_78758_h()) {
                ItemEditor.withConsumer(itemStack, itemStack1 -> EditorHelper.mc.field_71442_b.func_78761_a(itemStack1, EditorHelper.mc.field_71439_g.field_71071_by.field_70461_c + EditorHelper.mc.field_71439_g.field_71071_by.field_70462_a.size()));
            } else {
                ItemEditor.withConsumer(itemStack, itemStack1 -> ClientUtils.handleCommand(ClientUtils.getReplaceItemCommandForPlayerMainHand(itemStack1)));
            }
        }
    }

    static void openItemEditorFromPlayerInventory(Slot slot) {
        if (EditorHelper.checkPermissions()) {
            if (EditorHelper.isServerEnabled()) {
                ItemEditor.withConsumer(slot.func_75211_c(), itemStack -> IBENetworkHandler.getModChannel().sendToServer((Object)new PlayerInventoryItemEditorMessage((ItemStack)itemStack, slot.getSlotIndex())));
            } else if (EditorHelper.mc.field_71442_b.func_78758_h()) {
                ItemEditor.withConsumer(slot.func_75211_c(), itemStack1 -> {});
            } else {
                ItemEditor.withConsumer(slot.func_75211_c(), itemStack1 -> ClientUtils.handleCommand(ClientUtils.getReplaceItemCommandForPlayer(itemStack1, slot)));
            }
        }
    }

    static void openItemEditorFromBlockInventory(Slot slot, BlockPos blockPos) {
        if (EditorHelper.checkPermissions()) {
            if (EditorHelper.isServerEnabled()) {
                ItemEditor.withConsumer(slot.func_75211_c(), itemStack -> IBENetworkHandler.getModChannel().sendToServer((Object)new BlockInventoryItemEditorMessage((ItemStack)itemStack, slot.getSlotIndex(), blockPos)));
            } else {
                ItemEditor.withConsumer(slot.func_75211_c(), itemStack -> ClientUtils.handleCommand(ClientUtils.getReplaceItemCommandForBlock(itemStack, slot, blockPos)));
            }
        }
    }

    static void openItemEditorFromEntityInventory(Slot slot, Entity entity) {
        if (EditorHelper.checkPermissions()) {
            if (EditorHelper.isServerEnabled()) {
                ItemEditor.withConsumer(slot.func_75211_c(), itemStack -> IBENetworkHandler.getModChannel().sendToServer((Object)new EntityInventoryItemEditorMessage((ItemStack)itemStack, slot.getSlotIndex(), entity.func_145782_y())));
            } else {
                ItemEditor.withConsumer(slot.func_75211_c(), itemStack -> ClientUtils.handleCommand(ClientUtils.getReplaceItemCommandForEntity(itemStack, slot, entity)));
            }
        }
    }

    private static void openEntityEditor(Entity entity) {
        if (EditorHelper.checkPermissions()) {
            new EntityEditor(entity);
        }
    }

    private static void openBlockEditor(BlockPos blockPos) {
        if (EditorHelper.checkPermissions()) {
            if (EditorHelper.isServerEnabled()) {
                IBENetworkHandler.getModChannel().sendToServer((Object)new InitBlockEditorRequest(blockPos));
            } else {
                TileEntity te = EditorHelper.mc.field_71441_e.func_175625_s(blockPos);
                if (te != null && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
                    if (!blockPos.equals((Object)warningPos)) {
                        EditorHelper.mc.field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("[IBE Editor] Be careful, editing this block will delete all the items it contains! Open the editor again if you want to continue.").func_240699_a_(TextFormatting.RED), null);
                        warningPos = blockPos;
                        return;
                    }
                    warningPos = null;
                }
                new BlockEditor(blockPos, te);
            }
        }
    }

    private static boolean checkPermissions() {
        if (!((Boolean)IBEConfiguration.CLIENT.creativeModeOnly.get()).booleanValue() || EditorHelper.mc.field_71439_g.func_184812_l_()) {
            return true;
        }
        EditorHelper.mc.field_71439_g.func_145747_a(MUST_CREATIVE, null);
        return false;
    }

    public static boolean isServerEnabled() {
        return serverEnabled;
    }

    public static void setServerEnabled(boolean serverEnabled) {
        EditorHelper.serverEnabled = serverEnabled;
    }
}

