/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.clipboard;

import com.github.franckyi.ibeeditor.IBEEditorMod;
import com.github.franckyi.ibeeditor.client.IBENotification;
import com.github.franckyi.ibeeditor.client.clipboard.EntityClipboardEntry;
import com.github.franckyi.ibeeditor.client.clipboard.ItemClipboardEntry;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.TextFormatting;

public class IBEClipboard {
    private static final int VERSION = 101;
    private static IBEClipboard instance;
    private boolean disabled;
    private final Path path;
    private final PacketBuffer buffer;
    private final List<ItemClipboardEntry> items;
    private final List<EntityClipboardEntry> entities;

    private IBEClipboard() {
        instance = this;
        this.path = Paths.get("config", "ibeeditor-clipboard.dat");
        this.buffer = new PacketBuffer(Unpooled.buffer());
        this.entities = new ArrayList<EntityClipboardEntry>();
        this.items = new ArrayList<ItemClipboardEntry>();
    }

    public static IBEClipboard getInstance() {
        return instance == null ? new IBEClipboard() : instance;
    }

    public void addEntity(Entity entity) {
        EntityClipboardEntry entry = new EntityClipboardEntry(entity);
        if (this.entities.contains(entry)) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.YELLOW + "This entity is already saved to the clipboard.");
        } else {
            this.entities.add(entry);
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Entity copied to clipboard.");
            this.save();
        }
    }

    public void removeEntity(EntityClipboardEntry entry) {
        if (this.entities.remove(entry)) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Entity successfully removed from clipboard.");
            this.save();
        } else {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.YELLOW + "This entity isn't saved to the clipboard.");
        }
    }

    public void addItem(ItemStack item) {
        ItemClipboardEntry entry = new ItemClipboardEntry(item);
        if (this.items.contains(entry)) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.YELLOW + "This item is already saved to the clipboard.");
        } else {
            this.items.add(entry);
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Item copied to clipboard.");
            this.save();
        }
    }

    public void removeItem(ItemClipboardEntry entry) {
        if (this.items.remove(entry)) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Item successfully removed from clipboard.");
            this.save();
        } else {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.YELLOW + "This item isn't saved to the clipboard.");
        }
    }

    public List<ItemClipboardEntry> getItems() {
        return this.items;
    }

    public List<EntityClipboardEntry> getEntities() {
        return this.entities;
    }

    public void save() {
        this.save(false);
    }

    private void save(boolean firstInit) {
        block7: {
            if (!this.disabled) {
                try {
                    this.buffer.writeInt(101);
                    this.buffer.writeInt(this.items.size());
                    this.items.forEach(entry -> entry.write(this.buffer));
                    this.buffer.writeInt(this.entities.size());
                    this.entities.forEach(entry -> entry.write(this.buffer));
                    OutputStream output = Files.newOutputStream(this.path, new OpenOption[0]);
                    this.buffer.readBytes(output, this.buffer.readableBytes());
                    output.close();
                    if (firstInit) {
                        IBEEditorMod.LOGGER.info("Clipboard created successfully.");
                        IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Thanks for using IBE Editor !");
                        break block7;
                    }
                    IBENotification.show(IBENotification.Type.CLIPBOARD, 3, TextFormatting.GREEN + "IBE Clipboard successfully saved to disk.");
                }
                catch (Exception e) {
                    if (firstInit) {
                        IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.RED + TextFormatting.BOLD.toString() + "IBE Clipboard first initialisation failed. See logs for details.", TextFormatting.RED + e.toString());
                    } else {
                        IBENotification.show(IBENotification.Type.CLIPBOARD, 3, TextFormatting.RED + TextFormatting.BOLD.toString() + "IBE Clipboard saving failed. See logs for details.", TextFormatting.RED + e.toString());
                    }
                    IBEEditorMod.LOGGER.throwing((Throwable)e);
                }
            } else {
                IBENotification.show(IBENotification.Type.CLIPBOARD, 3, TextFormatting.RED + "The IBE Clipboard is disabled.", TextFormatting.RED + "An error occured on startup. See logs for details.");
            }
        }
    }

    public void load() {
        try {
            this.entities.clear();
            this.items.clear();
            if (Files.exists(this.path, new LinkOption[0])) {
                boolean toConvert;
                int itemsSize;
                InputStream input = Files.newInputStream(this.path, new OpenOption[0]);
                this.buffer.writeBytes(input, input.available());
                input.close();
                int version = this.buffer.readInt();
                if (version < 100) {
                    itemsSize = version;
                    toConvert = true;
                    IBENotification.show(IBENotification.Type.CLIPBOARD, 3, TextFormatting.GREEN + "Converting IBE Clipboard to new format (version " + 101 + ").");
                    IBEEditorMod.LOGGER.warn("Converting IBE Clipboard to new format (version 101).");
                } else if (version == 101) {
                    itemsSize = this.buffer.readInt();
                    toConvert = false;
                } else {
                    IBENotification.show(IBENotification.Type.CLIPBOARD, 3, TextFormatting.RED + TextFormatting.BOLD.toString() + "IBE Clipboard version " + version + " is not supported.");
                    IBEEditorMod.LOGGER.error("IBE Clipboard version " + version + " is not supported.");
                    return;
                }
                for (int i = 0; i < itemsSize; ++i) {
                    this.items.add(new ItemClipboardEntry(this.buffer, toConvert));
                }
                int entitiesSize = this.buffer.readInt();
                for (int i = 0; i < entitiesSize; ++i) {
                    this.entities.add(new EntityClipboardEntry(this.buffer));
                }
                if (toConvert) {
                    this.save();
                }
                IBENotification.show(IBENotification.Type.CLIPBOARD, 3, TextFormatting.GREEN + "IBE Clipboard successfully loaded from disk.");
            } else {
                IBEEditorMod.LOGGER.info("Clipboard doesn't exist. Creating one.");
                this.save(true);
            }
        }
        catch (Exception e) {
            this.disabled = true;
            IBENotification.show(IBENotification.Type.CLIPBOARD, 3, TextFormatting.RED + TextFormatting.BOLD.toString() + "IBE Clipboard corrupted. See logs for details.", TextFormatting.RED + e.toString());
            IBEEditorMod.LOGGER.throwing((Throwable)e);
        }
    }
}

