/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.base;

import com.github.franckyi.guapi.Scene;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.group.VBox;
import com.github.franckyi.guapi.math.Insets;
import com.github.franckyi.guapi.math.Pos;
import com.github.franckyi.guapi.node.Button;
import com.github.franckyi.guapi.node.Label;
import com.github.franckyi.guapi.node.ListExtended;
import com.github.franckyi.guapi.scene.IBackground;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractCategory;
import com.github.franckyi.ibeeditor.common.IBEConfiguration;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.TextFormatting;

public abstract class AbstractEditor
extends Scene {
    protected final VBox content = (VBox)this.getContent();
    protected final HBox header = new HBox(5);
    protected final Label headerLabel;
    protected final HBox body;
    protected final ListExtended<CategoryEntry> categories;
    protected final List<AbstractCategory> propertiesList;
    protected final HBox footer;
    protected final Button doneButton;
    protected final Button cancelButton;
    protected final Button applyButton;
    protected int currentIndex;

    public AbstractEditor(String headerText) {
        super(new VBox());
        this.header.setPrefHeight(30);
        this.header.setAlignment(Pos.CENTER);
        this.headerLabel = new Label(TextFormatting.BOLD + headerText);
        this.body = new HBox();
        this.categories = new ListExtended(20);
        this.categories.setOffset(new Insets(0, 10, 10, 10));
        this.propertiesList = new ArrayList<AbstractCategory>();
        this.footer = new HBox(20);
        this.footer.setPrefHeight(20);
        this.doneButton = new Button(TextFormatting.GREEN + "Done");
        this.doneButton.setPrefWidth(80);
        this.doneButton.getOnMouseClickedListeners().add(event -> {
            this.apply();
            this.close();
        });
        this.cancelButton = new Button(TextFormatting.RED + "Close");
        this.cancelButton.setPrefWidth(80);
        this.cancelButton.getOnMouseClickedListeners().add(event -> this.close());
        this.applyButton = new Button(TextFormatting.GREEN + "Apply");
        this.applyButton.setPrefWidth(80);
        this.applyButton.getOnMouseClickedListeners().add(event -> this.apply());
        this.header.getChildren().add(this.headerLabel);
        this.body.getChildren().add(this.categories);
        this.footer.getChildren().add(this.doneButton);
        this.footer.getChildren().add(this.cancelButton);
        this.footer.getChildren().add(this.applyButton);
        this.footer.setAlignment(Pos.CENTER);
        this.content.getChildren().add(this.header);
        this.content.getChildren().add(this.body);
        this.content.getChildren().add(this.footer);
        this.setContentFullScreen();
        this.setBackground(IBackground.texturedBackground(1));
        this.getOnInitGuiListeners().add(e -> {
            this.setContentFullScreen();
            this.scaleChildrenSize();
        });
        this.setGuiPauseGame((Boolean)IBEConfiguration.CLIENT.doesGuiPauseGame.get());
    }

    protected void apply() {
        this.propertiesList.forEach(AbstractCategory::apply);
    }

    protected void scaleChildrenSize() {
        this.header.setPrefWidth(this.content.getWidth());
        this.footer.setPrefWidth(this.content.getWidth());
        this.categories.setPrefSize(this.content.getWidth() / 3, this.content.getHeight() - 60);
        ((ListExtended.GuiListExtendedView)this.categories.getView()).setHeight(this.content.getHeight());
        if (this.propertiesList.isEmpty()) {
            this.categories.setVisible(false);
        } else {
            this.scalePropertiesSize(this.propertiesList.get(this.currentIndex));
        }
    }

    protected void scalePropertiesSize(AbstractCategory category) {
        category.setPrefSize(2 * this.content.getWidth() / 3, this.content.getHeight() - 60);
        ((ListExtended.GuiListExtendedView)category.getView()).setHeight(this.content.getHeight());
        category.getChildren().forEach(p -> p.updateSize(this.propertiesList.get(this.currentIndex).getWidth()));
    }

    protected AbstractCategory addCategory(String name, AbstractCategory category) {
        this.categories.getChildren().add(new CategoryEntry(name));
        this.propertiesList.add(category);
        return category;
    }

    public void onCategoryClicked(CategoryEntry category) {
        int categoryIndex = this.categories.getChildren().indexOf(category);
        if (this.currentIndex != categoryIndex) {
            Label oldCategoryLabel = (Label)this.categories.getChildren().get(this.currentIndex).getNode();
            oldCategoryLabel.setText("  " + oldCategoryLabel.getText().substring(6));
            this.currentIndex = categoryIndex;
            AbstractCategory propertyList = this.propertiesList.get(categoryIndex);
            this.body.getChildren().set(1, propertyList);
            this.scalePropertiesSize(propertyList);
            Label newCategoryLabel = (Label)this.categories.getChildren().get(this.currentIndex).getNode();
            newCategoryLabel.setText(" " + TextFormatting.YELLOW + " " + TextFormatting.BOLD + newCategoryLabel.getText().substring(2));
        }
    }

    @Override
    public void show() {
        if (!this.propertiesList.isEmpty()) {
            this.currentIndex = 0;
            this.body.getChildren().add(this.propertiesList.get(0));
            Label categoryLabel = (Label)this.categories.getChildren().get(0).getNode();
            categoryLabel.setText(" " + TextFormatting.YELLOW + " " + TextFormatting.BOLD + categoryLabel.getText().substring(2));
        }
        super.show();
    }

    @Override
    public void render(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.body.render(matrixStack, mouseX, mouseY, partialTicks);
        this.footer.render(matrixStack, mouseX, mouseY, partialTicks);
        this.header.render(matrixStack, mouseX, mouseY, partialTicks);
        if (this.propertiesList.isEmpty()) {
            AbstractGui.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)AbstractEditor.mc.field_71466_p, (String)"No parameters available !", (int)(this.getScreen().field_230708_k_ / 2), (int)(this.body.getY() + this.body.getHeight() / 2 - 4), (int)TextFormatting.DARK_RED.func_211163_e());
        }
    }

    protected <X> void applyConfigurations(List<? extends AbstractEditorConfiguration<X, Object>> configurations, X x) {
        configurations.forEach(configuration -> {
            if (configuration.getCondition().test(x)) {
                this.addCategory(configuration.getName(), configuration.getCategoryBuilder().apply(configuration.getCaster().apply(x)));
            }
        });
    }

    public class CategoryEntry
    extends ListExtended.NodeEntry<Label> {
        public CategoryEntry(String name) {
            super(new Label("  " + name));
            ((Label)this.getNode()).setCentered(true);
            this.getOnMouseClickedListeners().add(e -> AbstractEditor.this.onCategoryClicked(this));
        }
    }

    protected static abstract class AbstractEditorConfiguration<X, T> {
        private final Predicate<X> condition;
        private final Function<X, T> caster;
        private final String name;
        private final Function<T, AbstractCategory> categoryBuilder;

        protected AbstractEditorConfiguration(Predicate<X> condition, Function<X, T> caster, String name, Function<T, AbstractCategory> categoryBuilder) {
            this.condition = condition;
            this.caster = caster;
            this.name = name;
            this.categoryBuilder = categoryBuilder;
        }

        public Predicate<X> getCondition() {
            return this.condition;
        }

        public Function<X, T> getCaster() {
            return this.caster;
        }

        public String getName() {
            return this.name;
        }

        public Function<T, AbstractCategory> getCategoryBuilder() {
            return this.categoryBuilder;
        }
    }
}

