/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.base.property.custom;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.math.Pos;
import com.github.franckyi.guapi.node.IntegerField;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.LabeledProperty;
import java.awt.Color;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.util.text.TextFormatting;

public class ColorProperty
extends LabeledProperty<Color> {
    protected IntegerField red;
    protected IntegerField green;
    protected IntegerField blue;
    protected HBox previewGroup;

    public ColorProperty(String name, Color initialValue, Consumer<Color> action) {
        super(name, initialValue, action, 70);
    }

    @Override
    protected Color getValue() {
        return new Color((Integer)this.red.getValue(), (Integer)this.green.getValue(), (Integer)this.blue.getValue());
    }

    @Override
    protected void setValue(Color value) {
        this.red.setValue(value.getRed());
        this.green.setValue(value.getGreen());
        this.blue.setValue(value.getBlue());
    }

    @Override
    protected void build() {
        super.build();
        Node[] nodeArray = new Node[4];
        this.red = new IntegerField(0, 0, 255);
        nodeArray[0] = this.red;
        this.green = new IntegerField(0, 0, 255);
        nodeArray[1] = this.green;
        this.blue = new IntegerField(0, 0, 255);
        nodeArray[2] = this.blue;
        this.previewGroup = new HBox();
        nodeArray[3] = this.previewGroup;
        this.addAll(nodeArray);
        this.red.setPrefWidth(26);
        this.green.setPrefWidth(26);
        this.blue.setPrefWidth(26);
        this.previewGroup.setAlignment(Pos.CENTER);
        this.red.getTooltipText().add(TextFormatting.RED + "Red");
        this.green.getTooltipText().add(TextFormatting.GREEN + "Green");
        this.blue.getTooltipText().add(TextFormatting.BLUE + "Blue");
        BiConsumer<Integer, Integer> e = (a, b) -> this.setValue(this.getValue());
        this.red.getOnValueChangedListeners().add(e);
        this.green.getOnValueChangedListeners().add(e);
        this.blue.getOnValueChangedListeners().add(e);
    }

    @Override
    public void updateSize(int listWidth) {
        this.previewGroup.setPrefWidth(listWidth - 0 - 219);
    }
}

