/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.item;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.math.Insets;
import com.github.franckyi.guapi.math.Pos;
import com.github.franckyi.guapi.node.DoubleField;
import com.github.franckyi.guapi.node.EnumButton;
import com.github.franckyi.guapi.node.TextField;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.category.EditableCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.IEditableCategoryProperty;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class AttributeModifiersCategory
extends EditableCategory<AttributeModifierModel> {
    private final List<AttributeModifierModel> initialModifiers;
    private final ItemStack itemStack;
    private final List<AttributeModifierModel> modifiers;

    public AttributeModifiersCategory(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.modifiers = this.getModifiers(arg_0 -> ((ItemStack)itemStack).func_111283_C(arg_0));
        this.initialModifiers = this.getModifiers(slot -> itemStack.func_77973_b().getAttributeModifiers(slot, itemStack));
        this.getChildren().add(new EditableCategory.AddButton((EditableCategory)this, "Add attribute modifier"));
        this.modifiers.forEach(this::addProperty);
    }

    private List<AttributeModifierModel> getModifiers(Function<EquipmentSlotType, Multimap<Attribute, AttributeModifier>> getAttributeModifiers) {
        ArrayList<AttributeModifierModel> res = new ArrayList<AttributeModifierModel>();
        Stream.of(EquipmentSlotType.values()).forEach(slot -> ((Multimap)getAttributeModifiers.apply((EquipmentSlotType)slot)).asMap().forEach((attribute, modifiers) -> modifiers.stream().map(modifier -> new AttributeModifierModel(attribute.getRegistryName(), (AttributeModifier)modifier, (EquipmentSlotType)slot)).forEach(res::add)));
        return res;
    }

    @Override
    public void apply() {
        this.itemStack.func_196082_o().func_82580_o("AttributeModifiers");
        this.modifiers.clear();
        super.apply();
        if (!this.modifiers.equals(this.initialModifiers)) {
            this.modifiers.forEach(modifier -> {
                Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(modifier.getAttributeName());
                if (attribute != null) {
                    this.itemStack.func_185129_a(attribute, modifier.getModifier(), modifier.getSlot());
                }
            });
        }
    }

    @Override
    protected AbstractProperty<AttributeModifierModel> createNewProperty(AttributeModifierModel initialValue, int index) {
        return new PropertyAttributeModifier(index, initialValue, this.modifiers::add);
    }

    @Override
    protected AttributeModifierModel getDefaultPropertyValue() {
        return new AttributeModifierModel(new ResourceLocation(""), new AttributeModifier("", 0.0, AttributeModifier.Operation.ADDITION), EquipmentSlotType.MAINHAND);
    }

    public class PropertyAttributeModifier
    extends AbstractProperty<AttributeModifierModel>
    implements IEditableCategoryProperty {
        private final IEditableCategoryProperty.PropertyControls controls;
        private TextField nameField;
        private EnumButton<EquipmentSlotType> slotButton;
        private EnumButton<AttributeModifier.Operation> operationButton;
        private DoubleField amountField;

        public PropertyAttributeModifier(int index, AttributeModifierModel initialValue, Consumer<AttributeModifierModel> action) {
            super(initialValue, action);
            this.controls = new IEditableCategoryProperty.PropertyControls(AttributeModifiersCategory.this, index);
            IEditableCategoryProperty.super.build();
        }

        @Override
        public AttributeModifierModel getValue() {
            return new AttributeModifierModel(ResourceLocation.func_208304_a((String)this.nameField.getValue()), new AttributeModifier(((AttributeModifierModel)this.initialValue).getModifier().func_111167_a(), ((AttributeModifierModel)this.initialValue).getModifier().func_111166_b(), ((Double)this.amountField.getValue()).doubleValue(), this.operationButton.getValue()), this.slotButton.getValue());
        }

        @Override
        protected void setValue(AttributeModifierModel value) {
            this.nameField.setValue(value.getAttributeName().toString());
            this.slotButton.setValue(value.getSlot());
            this.operationButton.setValue(value.getModifier().func_220375_c());
            this.amountField.setValue(value.getModifier().func_111164_d());
        }

        @Override
        public void build() {
            ((HBox)this.getNode()).setAlignment(Pos.LEFT);
            Node[] nodeArray = new Node[4];
            this.nameField = new TextField(((AttributeModifierModel)this.initialValue).getAttributeName().toString());
            nodeArray[0] = this.nameField;
            this.slotButton = new EnumButton<EquipmentSlotType>((T[])EquipmentSlotType.values());
            nodeArray[1] = this.slotButton;
            this.operationButton = new EnumButton<AttributeModifier.Operation>((T[])AttributeModifier.Operation.values());
            nodeArray[2] = this.operationButton;
            this.amountField = new DoubleField(((AttributeModifierModel)this.initialValue).getModifier().func_111164_d());
            nodeArray[3] = this.amountField;
            this.addAll(nodeArray);
            this.nameField.getTooltipText().add("Attribute name");
            this.slotButton.setValue(((AttributeModifierModel)this.initialValue).getSlot());
            this.slotButton.setRenderer(aSlot -> StringUtils.capitalize((String)aSlot.func_188450_d().toLowerCase()));
            this.slotButton.getTooltipText().add(ITextComponent.func_244388_a((String)"Slot"));
            this.operationButton.setValue(((AttributeModifierModel)this.initialValue).getModifier().func_220375_c());
            this.operationButton.setRenderer(operation -> Integer.toString(operation.func_220371_a()));
            this.operationButton.setPrefWidth(12);
            this.operationButton.getTooltipText().add(ITextComponent.func_244388_a((String)"Operation"));
            this.amountField.setMargin(Insets.left(2));
            this.amountField.getTooltipText().add("Amount");
        }

        @Override
        public void updateSize(int listWidth) {
            this.amountField.setPrefWidth(listWidth - 0 - 252);
        }

        @Override
        public IEditableCategoryProperty.PropertyControls getControls() {
            return this.controls;
        }
    }

    protected static class AttributeModifierModel {
        private final ResourceLocation attributeName;
        private final AttributeModifier modifier;
        private final EquipmentSlotType slot;

        public AttributeModifierModel(ResourceLocation attributeName, AttributeModifier modifier, EquipmentSlotType slot) {
            this.attributeName = attributeName;
            this.modifier = modifier;
            this.slot = slot;
        }

        public ResourceLocation getAttributeName() {
            return this.attributeName;
        }

        public AttributeModifier getModifier() {
            return this.modifier;
        }

        public EquipmentSlotType getSlot() {
            return this.slot;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof AttributeModifierModel) {
                AttributeModifierModel model = (AttributeModifierModel)obj;
                return this.slot.equals((Object)model.slot) && this.modifier.func_111166_b().equals(model.modifier.func_111166_b()) && this.modifier.func_220375_c() == model.modifier.func_220375_c() && this.modifier.func_111164_d() == model.modifier.func_111164_d() && this.attributeName.equals((Object)model.attributeName);
            }
            return false;
        }
    }
}

