/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.item;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.math.Pos;
import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.PropertyInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.function.Consumer;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EnchantmentsCategory
extends AbstractCategory {
    private final ItemStack itemStack;

    public EnchantmentsCategory(ItemStack itemStack) {
        this.itemStack = itemStack;
        ListNBT enchTag = itemStack.func_77986_q();
        HashMap<IForgeRegistryEntry, Integer> itemEnch = new HashMap<IForgeRegistryEntry, Integer>(enchTag.size());
        for (int i2 = 0; i2 < enchTag.size(); ++i2) {
            CompoundNBT c = enchTag.func_150305_b(i2);
            String id = c.func_74779_i("id");
            int level = c.func_74762_e("lvl");
            itemEnch.put(ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(id)), level);
        }
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>(ForgeRegistries.ENCHANTMENTS.getValues());
        enchantments.sort(new EnchantmentComparator());
        for (Enchantment e : enchantments) {
            this.getChildren().add(new PropertyEnchantment(itemStack, e, itemEnch.getOrDefault(e, 0), i -> this.setEnchantment(e, (int)i)));
        }
    }

    private void setEnchantment(Enchantment ench, int value) {
        if (value > 0) {
            this.itemStack.func_77966_a(ench, value);
        }
    }

    @Override
    public void apply() {
        this.itemStack.func_196082_o().func_82580_o("Enchantments");
        super.apply();
    }

    public static class PropertyEnchantment
    extends PropertyInteger {
        protected TexturedButton plusButton;
        protected TexturedButton minusButton;
        protected Enchantment enchantment;

        public PropertyEnchantment(ItemStack itemStack, Enchantment enchantment, Integer initialValue, Consumer<Integer> action) {
            super(enchantment.func_200305_d(0).func_230531_f_().getString(), initialValue, action, 0, 127);
            this.enchantment = enchantment;
            this.nameLabel.setPrefWidth(-1);
            this.nameLabel.setColor(enchantment.func_190936_d() ? TextFormatting.RED.func_211163_e() : (enchantment.func_92089_a(itemStack) ? TextFormatting.GREEN.func_211163_e() : 0xFFFFFF));
            this.updateButtons(initialValue);
        }

        @Override
        protected void build() {
            super.build();
            Node[] nodeArray = new Node[2];
            this.plusButton = new TexturedButton("add.png", TextFormatting.GREEN + "+1 level");
            nodeArray[0] = this.plusButton;
            this.minusButton = new TexturedButton("minus.png", TextFormatting.RED + "-1 level");
            nodeArray[1] = this.minusButton;
            this.addAll(nodeArray);
            this.numberField.getOnValueChangedListeners().add((oldVal, newVal) -> this.updateButtons((int)newVal));
            this.plusButton.getOnMouseClickedListeners().add(event -> this.setValue((Integer)this.getValue() + (((Integer)this.getValue()).equals(this.numberField.getMax()) ? 0 : 1)));
            this.minusButton.getOnMouseClickedListeners().add(event -> this.setValue((Integer)this.getValue() - (((Integer)this.getValue()).equals(this.numberField.getMin()) ? 0 : 1)));
            ((HBox)this.getNode()).setAlignment(Pos.RIGHT);
        }

        private void updateButtons(int val) {
            this.plusButton.setDisabled(val == (Integer)this.numberField.getMax());
            this.minusButton.setDisabled(val == (Integer)this.numberField.getMin());
        }

        @Override
        public void updateSize(int listWidth) {
            this.numberField.setPrefWidth(listWidth - 0 - 250);
        }
    }

    private class EnchantmentComparator
    implements Comparator<Enchantment> {
        private EnchantmentComparator() {
        }

        @Override
        public int compare(Enchantment e1, Enchantment e2) {
            if (e1.func_190936_d()) {
                if (e2.func_190936_d()) {
                    return e1.func_77320_a().compareTo(e2.func_77320_a());
                }
                return 1;
            }
            if (e2.func_190936_d()) {
                return -1;
            }
            if (e1.func_92089_a(EnchantmentsCategory.this.itemStack)) {
                if (e2.func_92089_a(EnchantmentsCategory.this.itemStack)) {
                    return e1.func_77320_a().compareTo(e2.func_77320_a());
                }
                return -1;
            }
            if (e2.func_92089_a(EnchantmentsCategory.this.itemStack)) {
                return 1;
            }
            return e1.func_77320_a().compareTo(e2.func_77320_a());
        }
    }
}

