/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.item;

import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.ibeeditor.client.IBENotification;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.CapabilityProviderEditor;
import com.github.franckyi.ibeeditor.client.gui.editor.block.BlockStateCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.AttributeModifiersCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.BlockCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.EnchantmentsCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.GeneralItemCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.HideFlagsCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.PotionCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.SpawnEggCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.ToolsItemCategory;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.item.TippedArrowItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.util.text.TextFormatting;

public class ItemEditor
extends CapabilityProviderEditor
implements BlockStateCategory.IBlockStateContainer {
    private final ItemStack itemStack;
    private BlockState blockState;
    private final Predicate<ItemStack> action;

    public static void withConsumer(ItemStack itemStack, Consumer<ItemStack> action) {
        new ItemEditor(itemStack, itemStack1 -> {
            action.accept((ItemStack)itemStack1);
            return true;
        });
    }

    public static void withPredicate(ItemStack itemStack, Predicate<ItemStack> action) {
        new ItemEditor(itemStack, action);
    }

    private ItemEditor(ItemStack itemStack, Predicate<ItemStack> action) {
        super("Item Editor :");
        this.itemStack = itemStack;
        this.action = action;
        this.header.getChildren().add(new TexturedButton(itemStack));
        this.addCategory("General", new GeneralItemCategory(itemStack));
        if (itemStack.func_77973_b() instanceof PotionItem || itemStack.func_77973_b() instanceof TippedArrowItem) {
            this.addCategory("Potion effects", new PotionCategory(itemStack));
        }
        if (itemStack.func_77973_b() instanceof SpawnEggItem) {
            this.addCategory("Spawn entity", new SpawnEggCategory(itemStack, (SpawnEggItem)itemStack.func_77973_b()));
        }
        if (itemStack.func_77973_b() instanceof BlockItem) {
            this.initBlock((BlockItem)itemStack.func_77973_b());
            this.addCategory("Block State", new BlockStateCategory(this, this::applyBlock));
        }
        this.applyConfigurations(this.getCapabilityConfigurations(), itemStack);
        this.addCategory("Enchantments", new EnchantmentsCategory(itemStack));
        this.addCategory("Attribute modifiers", new AttributeModifiersCategory(itemStack));
        this.addCategory("Hide Flags", new HideFlagsCategory(itemStack));
        if (itemStack.func_77973_b() instanceof BlockItem) {
            this.addCategory("Can place on", new BlockCategory(itemStack, "CanPlaceOn"));
        }
        this.addCategory("Can destroy", new BlockCategory(itemStack, "CanDestroy"));
        this.addCategory("Tools", new ToolsItemCategory(itemStack));
        this.show();
    }

    @Override
    protected void apply() {
        ItemStack baseStack = this.itemStack.func_77946_l();
        this.propertiesList.subList(1, this.propertiesList.size()).forEach(AbstractCategory::apply);
        ((AbstractCategory)this.propertiesList.get(0)).apply();
        this.header.getChildren().set(1, new TexturedButton(this.itemStack));
        if (baseStack.equals(this.itemStack, false)) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.YELLOW + "Nothing to save.");
        } else if (this.action.test(this.itemStack)) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Item saved.");
        }
    }

    private void initBlock(BlockItem item) {
        ItemEditor.mc.field_71417_B.func_198032_j();
        this.blockState = item.func_179223_d().func_176223_P();
        CompoundNBT tag = this.itemStack.func_179543_a("BlockStateTag");
        if (tag != null) {
            this.blockState.func_235904_r_().forEach(property -> {
                String name = property.func_177701_a();
                if (tag.func_74764_b(name)) {
                    if (property instanceof IntegerProperty) {
                        this.blockState = (BlockState)this.blockState.func_206870_a((Property)((IntegerProperty)property), (Comparable)Integer.valueOf(tag.func_74762_e(name)));
                    } else if (property instanceof BooleanProperty) {
                        this.blockState = (BlockState)this.blockState.func_206870_a((Property)((BooleanProperty)property), (Comparable)Boolean.valueOf(tag.func_74779_i(name).equalsIgnoreCase("true")));
                    } else if (property instanceof EnumProperty) {
                        EnumProperty property1 = (EnumProperty)property;
                        this.blockState = (BlockState)this.blockState.func_206870_a((Property)property1, (Comparable)property1.func_185929_b(tag.func_74779_i(name)).orElse(null));
                    }
                }
            });
        }
    }

    private void applyBlock() {
        CompoundNBT tag = new CompoundNBT();
        this.blockState.func_235904_r_().forEach(property -> {
            if (property instanceof IntegerProperty) {
                tag.func_74768_a(property.func_177701_a(), ((Integer)this.blockState.func_177229_b((Property)((IntegerProperty)property))).intValue());
            } else if (property instanceof BooleanProperty) {
                tag.func_74778_a(property.func_177701_a(), (Boolean)this.blockState.func_177229_b((Property)((BooleanProperty)property)) != false ? "true" : "false");
            } else if (property instanceof EnumProperty) {
                tag.func_74778_a(property.func_177701_a(), this.blockState.func_177229_b((Property)((EnumProperty)property)).toString());
            }
        });
        this.itemStack.func_196082_o().func_218657_a("BlockStateTag", (INBT)tag);
    }

    @Override
    public BlockState getBlockState() {
        return this.blockState;
    }

    @Override
    public void setBlockState(BlockState blockState) {
        this.blockState = blockState;
    }
}

