/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.item;

import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.category.EditableCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.custom.ColorProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.custom.ItemPotionEffectProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.custom.model.PotionEffectModel;
import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;

public class PotionCategory
extends EditableCategory<PotionEffectModel> {
    private final ItemStack itemStack;
    private final List<EffectInstance> effects;

    public PotionCategory(ItemStack itemStack) {
        super(1);
        this.itemStack = itemStack;
        this.effects = PotionUtils.func_185190_b((ItemStack)itemStack);
        this.addAll(new PotionColorProperty(new Color(PotionUtils.func_190932_c((ItemStack)itemStack)), this::setColor), new EditableCategory.AddButton((EditableCategory)this, "Add potion effect"));
        this.effects.forEach(potionEffect -> this.addProperty(new PotionEffectModel((EffectInstance)potionEffect, false)));
    }

    private void setColor(Color color) {
        int c = color.getRGB();
        if (c != PotionUtils.func_185181_a((Collection)PotionUtils.func_185189_a((ItemStack)this.itemStack))) {
            this.itemStack.func_196082_o().func_74768_a("CustomPotionColor", c);
        }
    }

    private void addEffect(PotionEffectModel effect) {
        if (effect != null && !effect.isDisabled()) {
            this.effects.add(effect);
        }
    }

    @Override
    protected AbstractProperty<PotionEffectModel> createNewProperty(PotionEffectModel initialValue, int index) {
        return new ItemPotionEffectProperty(this, index, initialValue, this::addEffect);
    }

    @Override
    protected PotionEffectModel getDefaultPropertyValue() {
        return new PotionEffectModel(Effects.field_76424_c);
    }

    @Override
    public void apply() {
        this.effects.clear();
        this.itemStack.func_196082_o().func_82580_o("CustomPotionEffects");
        this.itemStack.func_196082_o().func_82580_o("CustomPotionColor");
        this.getChildren().subList(1, this.getChildren().size()).forEach(AbstractProperty::apply);
        ((AbstractProperty)this.getChildren().get(0)).apply();
        PotionUtils.func_185184_a((ItemStack)this.itemStack, this.effects);
    }

    private class PotionColorProperty
    extends ColorProperty {
        private TexturedButton refreshButton;

        public PotionColorProperty(Color initialValue, Consumer<Color> action) {
            super("Potion color", initialValue, action);
        }

        @Override
        protected void setValue(Color value) {
            super.setValue(value);
            ItemStack stack = new ItemStack((IItemProvider)Items.field_151068_bn);
            stack.func_196082_o().func_74768_a("CustomPotionColor", value.getRGB());
            TexturedButton previewButton = new TexturedButton(stack, false);
            previewButton.getTooltipText().add(ITextComponent.func_244388_a((String)"Preview"));
            this.previewGroup.getChildren().set(0, previewButton);
        }

        @Override
        protected void build() {
            super.build();
            this.refreshButton = new TexturedButton("download.png", TextFormatting.AQUA + "Calculate color from effects");
            ((HBox)this.getNode()).getChildren().add(5, this.refreshButton);
            this.refreshButton.getOnMouseClickedListeners().add(e -> {
                List children = PotionCategory.this.getChildren();
                List effects = children.subList(1, children.size() - 1).stream().map(abstractProperty -> ((ItemPotionEffectProperty)abstractProperty).getValue()).filter(Objects::nonNull).collect(Collectors.toList());
                effects.addAll(PotionUtils.func_185191_c((ItemStack)PotionCategory.this.itemStack).func_185170_a());
                this.setValue(new Color(PotionUtils.func_185181_a(effects)));
            });
            TexturedButton previewButton = new TexturedButton(new ItemStack((IItemProvider)Items.field_151068_bn), false);
            previewButton.getTooltipText().add(ITextComponent.func_244388_a((String)"Preview"));
            this.previewGroup.getChildren().add(previewButton);
        }

        @Override
        public void updateSize(int listWidth) {
            this.previewGroup.setPrefWidth(listWidth - 0 - 240);
        }
    }
}

