/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.item;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.math.Pos;
import com.github.franckyi.guapi.node.Button;
import com.github.franckyi.guapi.node.Label;
import com.github.franckyi.ibeeditor.client.ClientUtils;
import com.github.franckyi.ibeeditor.client.EntityIcons;
import com.github.franckyi.ibeeditor.client.clipboard.EntityClipboardEntry;
import com.github.franckyi.ibeeditor.client.gui.clipboard.AbstractClipboard;
import com.github.franckyi.ibeeditor.client.gui.clipboard.SelectionClipboard;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.entity.EntityEditor;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.SpawnEggItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class SpawnEggCategory
extends AbstractCategory {
    private final ItemStack itemStack;
    private final SpawnEggItem item;
    private CompoundNBT spawnData;

    public SpawnEggCategory(ItemStack itemStack, SpawnEggItem item) {
        this.itemStack = itemStack;
        this.item = item;
        this.spawnData = itemStack.func_190925_c("EntityTag");
        this.addEntityProperty();
    }

    private void addEntityProperty() {
        this.getChildren().add(0, new EntityProperty(EntityType.func_220327_a((String)this.spawnData.func_74779_i("id")).orElse(this.item.func_208076_b(this.itemStack.func_77978_p())), this.spawnData, this::setEntity, this::setEntity));
    }

    private void setEntity(EntityClipboardEntry entry) {
        this.setData(entry.getEntityTag());
    }

    private void setEntity(Entity entity) {
        this.setData(ClientUtils.getCleanEntityTag(entity));
    }

    private void setData(CompoundNBT tag) {
        this.spawnData = tag;
        this.getChildren().remove(0);
        this.addEntityProperty();
    }

    @Override
    public void apply() {
        super.apply();
        this.itemStack.func_196082_o().func_218657_a("EntityTag", (INBT)this.spawnData);
    }

    private static class EntityProperty
    extends AbstractProperty<Void> {
        private final Label entityLabel;

        public EntityProperty(EntityType<?> entityType, CompoundNBT spawnData, Consumer<EntityClipboardEntry> action0, Consumer<Entity> action1) {
            super(null, aVoid -> {});
            ((HBox)this.getNode()).setAlignment(Pos.LEFT);
            ((HBox)this.getNode()).getChildren().remove(0);
            Node[] nodeArray = new Node[4];
            this.entityLabel = new Label("Entity");
            nodeArray[0] = this.entityLabel;
            nodeArray[1] = EntityIcons.createTexturedButtonForEntity(entityType);
            Button editButton = new Button("Editor", "Open in Entity Editor");
            nodeArray[2] = editButton;
            Button replaceButton = new Button("Clipboard", "Replace with Clipboard...");
            nodeArray[3] = replaceButton;
            this.addAll(nodeArray);
            editButton.getOnMouseClickedListeners().add(e -> new EntityEditor((Entity)ClientUtils.createEntity(entityType, spawnData), action1));
            replaceButton.getOnMouseClickedListeners().add(e -> new SelectionClipboard(AbstractClipboard.Filter.ENTITY, action0));
        }

        @Override
        protected Void getValue() {
            return null;
        }

        @Override
        protected void setValue(Void value) {
        }

        @Override
        protected void build() {
        }

        @Override
        public void updateSize(int listWidth) {
            this.entityLabel.setPrefWidth(listWidth - 0 - 155);
        }
    }
}

