/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.common.network;

import com.github.franckyi.ibeeditor.common.network.IPacket;
import com.github.franckyi.ibeeditor.common.network.editor.OpenEditorMessage;
import com.github.franckyi.ibeeditor.common.network.editor.block.BlockEditorMessage;
import com.github.franckyi.ibeeditor.common.network.editor.block.InitBlockEditorRequest;
import com.github.franckyi.ibeeditor.common.network.editor.block.InitBlockEditorResponse;
import com.github.franckyi.ibeeditor.common.network.editor.entity.EntityEditorMessage;
import com.github.franckyi.ibeeditor.common.network.editor.item.BlockInventoryItemEditorMessage;
import com.github.franckyi.ibeeditor.common.network.editor.item.EntityInventoryItemEditorMessage;
import com.github.franckyi.ibeeditor.common.network.editor.item.MainHandItemEditorMessage;
import com.github.franckyi.ibeeditor.common.network.editor.item.PlayerInventoryItemEditorMessage;
import com.github.franckyi.ibeeditor.common.network.handshake.C2SHandshake;
import com.github.franckyi.ibeeditor.common.network.handshake.S2CHandshake;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;

public class IBENetworkHandler {
    private static final String CHANNEL_VERSION = "1.0.0";
    private static final SimpleChannel MOD_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("ibeeditor", "network")).clientAcceptedVersions(version -> true).serverAcceptedVersions(version -> true).networkProtocolVersion(() -> "1.0.0").simpleChannel();
    private static int i;

    public static SimpleChannel getModChannel() {
        return MOD_CHANNEL;
    }

    public static void init() {
        IBENetworkHandler.registerPacket(S2CHandshake.class, S2CHandshake::new);
        IBENetworkHandler.registerPacket(C2SHandshake.class, C2SHandshake::new);
        IBENetworkHandler.registerPacket(OpenEditorMessage.class, OpenEditorMessage::new);
        IBENetworkHandler.registerPacket(MainHandItemEditorMessage.class, MainHandItemEditorMessage::new);
        IBENetworkHandler.registerPacket(PlayerInventoryItemEditorMessage.class, PlayerInventoryItemEditorMessage::new);
        IBENetworkHandler.registerPacket(BlockInventoryItemEditorMessage.class, BlockInventoryItemEditorMessage::new);
        IBENetworkHandler.registerPacket(EntityInventoryItemEditorMessage.class, EntityInventoryItemEditorMessage::new);
        IBENetworkHandler.registerPacket(InitBlockEditorRequest.class, InitBlockEditorRequest::new);
        IBENetworkHandler.registerPacket(InitBlockEditorResponse.class, InitBlockEditorResponse::new);
        IBENetworkHandler.registerPacket(BlockEditorMessage.class, BlockEditorMessage::new);
        IBENetworkHandler.registerPacket(EntityEditorMessage.class, EntityEditorMessage::new);
    }

    private static <P extends IPacket> void registerPacket(Class<P> c, Function<PacketBuffer, P> read) {
        MOD_CHANNEL.messageBuilder(c, i++).decoder(read).encoder(IPacket::write).consumer(IPacket::handle).add();
    }
}

