/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.gui;

import com.github.franckyi.ibeeditor.IBEEditor;
import com.github.franckyi.ibeeditor.gui.GuiEditor;
import com.github.franckyi.ibeeditor.gui.child.item.GuiPropertyListAttributeModifier;
import com.github.franckyi.ibeeditor.gui.child.item.GuiPropertyListBlock;
import com.github.franckyi.ibeeditor.gui.child.item.GuiPropertyListDisplay;
import com.github.franckyi.ibeeditor.gui.child.item.GuiPropertyListPotionEffects;
import com.github.franckyi.ibeeditor.gui.property.BaseProperty;
import com.github.franckyi.ibeeditor.gui.property.BooleanProperty;
import com.github.franckyi.ibeeditor.gui.property.FormattedStringProperty;
import com.github.franckyi.ibeeditor.gui.property.IntegerProperty;
import com.github.franckyi.ibeeditor.gui.property.PropertyCategory;
import com.github.franckyi.ibeeditor.gui.property.StringProperty;
import com.github.franckyi.ibeeditor.gui.property.item.AttributeModifierProperty;
import com.github.franckyi.ibeeditor.gui.property.item.PotionEffectProperty;
import com.github.franckyi.ibeeditor.models.AttributeModifierModel;
import com.github.franckyi.ibeeditor.models.PotionEffectModel;
import com.github.franckyi.ibeeditor.network.UpdateItemMessage;
import com.github.franckyi.ibeeditor.util.EnchantmentsUtil;
import com.github.franckyi.ibeeditor.util.IBEUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemLingeringPotion;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemSplashPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTippedArrow;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiItemEditor
extends GuiEditor {
    private final ItemStack itemStack;
    private final int slotId;
    private final BlockPos blockPos;
    private final NBTTagCompound tagCompound;
    private final NBTTagCompound displayTag;
    private NBTTagList loresList;
    private NBTTagList enchantmentsList;
    private NBTTagList canDestroy;
    private NBTTagList canPlaceOn;
    private NBTTagList potionEffects;
    private Map<Enchantment, Integer> enchantmentsMap;
    private int hideFlags;

    public GuiItemEditor(ItemStack itemStack, int slotId, BlockPos blockPos) {
        this(null, itemStack, slotId, blockPos);
    }

    public GuiItemEditor(ItemStack itemStack) {
        this(null, itemStack, Minecraft.func_71410_x().field_71439_g.field_71071_by.func_184429_b(itemStack), null);
    }

    public GuiItemEditor(GuiScreen parentScreen, ItemStack itemStack, int slotId, BlockPos blockPos) {
        super(parentScreen);
        this.itemStack = itemStack;
        this.slotId = slotId;
        this.blockPos = blockPos;
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        this.tagCompound = itemStack.func_77978_p();
        this.displayTag = itemStack.func_190925_c("display");
        this.loresList = this.displayTag.func_150295_c("Lore", 8);
        this.enchantmentsList = itemStack.func_77986_q();
        this.canDestroy = this.tagCompound.func_150295_c("CanDestroy", 8);
        this.enchantmentsMap = EnchantmentsUtil.readNBT(this.enchantmentsList);
        this.hideFlags = this.tagCompound.func_74762_e("HideFlags");
        boolean isBlock = itemStack.func_77973_b() instanceof ItemBlock;
        boolean isPotion = itemStack.func_77973_b() instanceof ItemPotion || itemStack.func_77973_b() instanceof ItemSplashPotion || itemStack.func_77973_b() instanceof ItemLingeringPotion || itemStack.func_77973_b() instanceof ItemTippedArrow;
        IntegerProperty damage = new IntegerProperty("Damage", () -> ((ItemStack)this.itemStack).func_77952_i(), arg_0 -> ((ItemStack)this.itemStack).func_77964_b(arg_0));
        IntegerProperty count = new IntegerProperty("Count", () -> ((ItemStack)this.itemStack).func_190916_E(), arg_0 -> ((ItemStack)this.itemStack).func_190920_e(arg_0));
        BooleanProperty unbreakable = new BooleanProperty("Unbreakable", () -> this.tagCompound.func_74771_c("Unbreakable") == 1, b -> this.tagCompound.func_74774_a("Unbreakable", (byte)(b != false ? 1 : 0)));
        this.categories.add(new PropertyCategory("General").addAll(new BaseProperty[]{damage, count, unbreakable}));
        FormattedStringProperty name = new FormattedStringProperty("Name", () -> IBEUtil.unformatString(this.itemStack.func_82833_r()), s -> {});
        ArrayList lores = new ArrayList(this.loresList.func_74745_c());
        this.loresList.forEach(nbtBase -> lores.add(new FormattedStringProperty("", () -> IBEUtil.unformatString(((NBTTagString)nbtBase).func_150285_a_()), s -> {})));
        this.categories.add(new PropertyCategory("Display", GuiPropertyListDisplay::new, this::applyDisplay).addAll(new FormattedStringProperty[]{name}).addAll(lores));
        BooleanProperty hideEnchantments = new BooleanProperty("Hide Enchantments", () -> this.hasHideFlags(5), b -> this.addHideFlags(b != false ? 1 : 0));
        BooleanProperty hideAttributeModifiers = new BooleanProperty("Hide Attribute Modifiers", () -> this.hasHideFlags(4), b -> this.addHideFlags(b != false ? 2 : 0));
        BooleanProperty hideUnbreakable = new BooleanProperty("Hide Unbreakable", () -> this.hasHideFlags(3), b -> this.addHideFlags(b != false ? 4 : 0));
        BooleanProperty hideCanDestroy = new BooleanProperty("Hide 'Can destroy'", () -> this.hasHideFlags(2), b -> this.addHideFlags(b != false ? 8 : 0));
        BooleanProperty hideCanPlaceOn = new BooleanProperty("Hide 'Can place on'", () -> this.hasHideFlags(1), b -> this.addHideFlags(b != false ? 16 : 0));
        BooleanProperty hideMisc = new BooleanProperty("Hide Miscellaneous", () -> this.hasHideFlags(0), b -> this.addHideFlags(b != false ? 32 : 0));
        this.categories.add(new PropertyCategory("Hide Flags").addAll(new BooleanProperty[]{hideEnchantments, hideAttributeModifiers, hideUnbreakable, hideCanDestroy, hideCanPlaceOn, hideMisc}));
        ArrayList enchantments = new ArrayList(EnchantmentsUtil.getEnchantments().size());
        EnchantmentsUtil.getEnchantments().forEach(enchantment -> enchantments.add(new IntegerProperty(I18n.func_135052_a((String)enchantment.func_77320_a(), (Object[])new Object[0]), () -> this.enchantmentsMap.getOrDefault(enchantment, 0), i -> {
            if (i > 0) {
                this.enchantmentsList.func_74742_a((NBTBase)EnchantmentsUtil.writeNBT(enchantment, i));
            }
        })));
        this.categories.add(new PropertyCategory("Enchantments").addAll(enchantments));
        ArrayList attributeModifiers = new ArrayList();
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            itemStack.func_111283_C(slot).entries().forEach(entry -> attributeModifiers.add(new AttributeModifierProperty(() -> new AttributeModifierModel((String)entry.getKey(), ((AttributeModifier)entry.getValue()).func_111164_d(), ((AttributeModifier)entry.getValue()).func_111169_c(), slot))));
        }
        this.categories.add(new PropertyCategory("Attribute Modifiers", GuiPropertyListAttributeModifier::new, this::applyAttributeModifiers).addAll(attributeModifiers));
        ArrayList canDestroyList = new ArrayList(this.canDestroy.func_74745_c());
        this.canDestroy.forEach(nbtBase -> canDestroyList.add(new StringProperty("", () -> ((NBTTagString)((NBTTagString)nbtBase)).func_150285_a_(), s -> {})));
        this.categories.add(new PropertyCategory("Can Destroy", GuiPropertyListBlock::new, this::applyCanDestroy).addAll(canDestroyList));
        if (isBlock) {
            this.canPlaceOn = this.tagCompound.func_150295_c("CanPlaceOn", 8);
            ArrayList canPlaceOnList = new ArrayList(this.canDestroy.func_74745_c());
            this.canPlaceOn.forEach(nbtBase -> canPlaceOnList.add(new StringProperty("", () -> ((NBTTagString)((NBTTagString)nbtBase)).func_150285_a_(), s -> {})));
            this.categories.add(new PropertyCategory("Can Place On", GuiPropertyListBlock::new, this::applyCanPlaceOn).addAll(canPlaceOnList));
        }
        if (isPotion) {
            this.potionEffects = this.tagCompound.func_150295_c("CustomPotionEffects", 10);
            ArrayList potionEffectList = new ArrayList(this.potionEffects.func_74745_c());
            this.potionEffects.forEach(nbtBase -> potionEffectList.add(new PotionEffectProperty(() -> PotionEffectModel.fromNBT((NBTTagCompound)nbtBase))));
            this.categories.add(new PropertyCategory("Potion Effects", GuiPropertyListPotionEffects::new, this::applyPotionEffects).addAll(potionEffectList));
        }
    }

    private void addHideFlags(int i) {
        this.hideFlags += i;
    }

    private boolean hasHideFlags(int i) {
        return String.format("%6s", Integer.toBinaryString(this.hideFlags)).replace(" ", "0").charAt(i) == '1';
    }

    @Override
    protected void apply() {
        IBEEditor.logger.info("Preparing to apply...");
        this.hideFlags = 0;
        this.enchantmentsList = new NBTTagList();
        super.apply();
        this.tagCompound.func_74768_a("HideFlags", this.hideFlags);
        this.tagCompound.func_74782_a("ench", (NBTBase)this.enchantmentsList);
        IBEEditor.netwrapper.sendToServer((IMessage)new UpdateItemMessage(this.itemStack, this.slotId, this.blockPos));
        IBEEditor.logger.info("Done !");
    }

    private void applyDisplay(List<FormattedStringProperty> properties) {
        this.loresList = new NBTTagList();
        for (int i = 0; i < properties.size(); ++i) {
            StringProperty property = properties.get(i);
            if (i == 0) {
                this.itemStack.func_151001_c(IBEUtil.formatString((String)property.getValue()));
                continue;
            }
            this.loresList.func_74742_a((NBTBase)new NBTTagString(IBEUtil.formatString((String)property.getValue())));
        }
        this.displayTag.func_74782_a("Lore", (NBTBase)this.loresList);
    }

    private void applyAttributeModifiers(List<AttributeModifierProperty> properties) {
        this.tagCompound.func_82580_o("AttributeModifiers");
        properties.forEach(property -> {
            AttributeModifierModel model = (AttributeModifierModel)property.getValue();
            if (model.toAttributeModifier() == null || model.getName().isEmpty()) {
                IBEEditor.logger.warn("Unable to create attribute modifier for attribute {} {} {} {}", (Object)model.getName(), (Object)model.getAmount(), (Object)model.getOperation(), (Object)model.getSlot());
            } else {
                this.itemStack.func_185129_a(model.getName(), model.toAttributeModifier(), model.getSlot());
            }
        });
    }

    private void applyCanDestroy(List<StringProperty> properties) {
        this.canDestroy = new NBTTagList();
        properties.forEach(property -> this.canDestroy.func_74742_a((NBTBase)new NBTTagString((String)property.getValue())));
        this.tagCompound.func_74782_a("CanDestroy", (NBTBase)this.canDestroy);
    }

    private void applyCanPlaceOn(List<StringProperty> properties) {
        this.canPlaceOn = new NBTTagList();
        properties.forEach(property -> this.canPlaceOn.func_74742_a((NBTBase)new NBTTagString((String)property.getValue())));
        this.tagCompound.func_74782_a("CanPlaceOn", (NBTBase)this.canPlaceOn);
    }

    private void applyPotionEffects(List<PotionEffectProperty> properties) {
        this.potionEffects = new NBTTagList();
        properties.forEach(property -> this.potionEffects.func_74742_a((NBTBase)((PotionEffectModel)property.getValue()).toNBT()));
        this.tagCompound.func_74782_a("CustomPotionEffects", (NBTBase)this.potionEffects);
    }
}

