/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.gui.base;

import com.github.franckyi.ibeeditor.gui.base.GuiValueField;
import java.util.function.Predicate;
import net.minecraft.client.gui.FontRenderer;

public class GuiDoubleValueField
extends GuiValueField<Double> {
    private final double minVal;
    private final double maxVal;

    public GuiDoubleValueField(int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height) {
        this(componentId, fontrendererObj, x, y, par5Width, par6Height, 0.0);
    }

    public GuiDoubleValueField(int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height, double value) {
        this(componentId, fontrendererObj, x, y, par5Width, par6Height, value, -1.7976931348623157E308, Double.MAX_VALUE);
    }

    public GuiDoubleValueField(int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height, double minVal, double maxVal) {
        this(componentId, fontrendererObj, x, y, par5Width, par6Height, 0.0, minVal, maxVal);
    }

    public GuiDoubleValueField(int componentId, FontRenderer fontrendererObj, int x, int y, int par5Width, int par6Height, double value, double minVal, double maxVal) {
        super(componentId, fontrendererObj, x, y, par5Width, par6Height, value);
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    @Override
    protected String fromValue(Double value) {
        return value.toString();
    }

    @Override
    protected Double toValue(String text) {
        try {
            return Double.parseDouble(text.isEmpty() ? "0" : text);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    @Override
    protected Predicate<Double> validate() {
        return d -> d >= this.minVal && d <= this.maxVal || d == 0.0;
    }
}

