/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.gui.child;

import com.github.franckyi.ibeeditor.gui.GuiEditor;
import com.github.franckyi.ibeeditor.gui.child.GuiPropertyList;
import com.github.franckyi.ibeeditor.gui.property.BaseProperty;
import com.github.franckyi.ibeeditor.proxy.ClientProxy;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;

public abstract class GuiPropertyListEditable<T extends BaseProperty<?>>
extends GuiPropertyList<T> {
    protected int clickedX;
    protected int clickedY;
    protected int startSlot;
    protected boolean isClicking;
    protected GuiButton add;

    public GuiPropertyListEditable(GuiEditor parent, Minecraft mcIn, int slotHeight, List<T> properties) {
        super(parent, mcIn, slotHeight, properties);
    }

    private boolean canUp(int index) {
        return index <= this.getListEnd() && index > this.getListStart();
    }

    private boolean canDown(int index) {
        return index < this.getListEnd() && index >= this.getListStart();
    }

    private boolean canAddBefore(int index) {
        return index <= this.getListEnd() && index >= this.getListStart();
    }

    private boolean canAddAfter(int index) {
        return index <= this.getListEnd() && index >= this.getListStart();
    }

    private boolean canRemove(int index) {
        return index <= this.getListEnd() && index >= this.getListStart();
    }

    private void up(int index) {
        if (this.canUp(index)) {
            Collections.swap(this.properties, index, index - 1);
            this.listUpdated();
        }
    }

    private void down(int index) {
        if (this.canDown(index)) {
            Collections.swap(this.properties, index, index + 1);
            this.listUpdated();
        }
    }

    private void addBefore(int index, T property) {
        if (this.canAddBefore(index)) {
            this.properties.add(index, property);
            this.listUpdated();
        }
    }

    private void addAfter(int index, T property) {
        if (this.canAddAfter(index)) {
            this.properties.add(index + 1, property);
            this.listUpdated();
        }
    }

    private void remove(int index) {
        if (this.canRemove(index)) {
            this.properties.remove(index);
            this.listUpdated();
        }
    }

    @Override
    public boolean func_148179_a(int mouseX, int mouseY, int mouseEvent) {
        if (this.add.func_146116_c(this.field_148161_k, mouseX, mouseY)) {
            this.properties.add(this.getListStart(), this.newProperty(this.getListStart()));
            this.listUpdated();
        }
        if (mouseEvent == 1) {
            this.clickedX = mouseX;
            this.clickedY = mouseY;
            this.startSlot = this.func_148124_c(mouseX, mouseY);
            this.isClicking = true;
        }
        return super.func_148179_a(mouseX, mouseY, mouseEvent);
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        if (this.properties.stream().flatMap(property -> property.getTextfieldList().stream()).anyMatch(GuiTextField::func_146206_l)) {
            super.keyTyped(typedChar, keyCode);
        } else {
            int slot = this.func_148124_c(this.field_148150_g, this.field_148162_h);
            if (keyCode == ClientProxy.guiListUp.func_151463_i()) {
                this.up(slot);
            }
            if (keyCode == ClientProxy.guiListDown.func_151463_i()) {
                this.down(slot);
            }
            if (keyCode == ClientProxy.guiListRemove.func_151463_i()) {
                this.remove(slot);
            }
            if (keyCode == ClientProxy.guiListAddBefore.func_151463_i()) {
                this.addBefore(slot, this.newProperty(slot));
            }
            if (keyCode == ClientProxy.guiListAddAfter.func_151463_i()) {
                this.addAfter(slot, this.newProperty(slot));
            }
        }
    }

    public boolean func_148181_b(int releasedX, int releasedY, int mouseEvent) {
        if (mouseEvent == 1 && this.isClicking) {
            this.isClicking = false;
            EnumSelectionType sel = this.processSelection(releasedX, releasedY);
            if (sel != null) {
                switch (sel) {
                    case TOP_LEFT: 
                    case TOP_CENTER: {
                        this.up(this.startSlot);
                        break;
                    }
                    case TOP_RIGHT: {
                        this.addBefore(this.startSlot, this.newProperty(this.startSlot));
                        break;
                    }
                    case CENTER_LEFT: {
                        this.remove(this.startSlot);
                        break;
                    }
                    case CENTER_RIGHT: {
                        break;
                    }
                    case BOTTOM_LEFT: 
                    case BOTTOM_CENTER: {
                        this.down(this.startSlot);
                        break;
                    }
                    case BOTTOM_RIGHT: {
                        this.addAfter(this.startSlot, this.newProperty(this.startSlot));
                    }
                }
            }
        }
        return super.func_148181_b(releasedX, releasedY, mouseEvent);
    }

    @Override
    public void func_148128_a(int mouseXIn, int mouseYIn, float partialTicks) {
        super.func_148128_a(mouseXIn, mouseYIn, partialTicks);
        this.add.func_191745_a(this.field_148161_k, mouseXIn, mouseYIn, partialTicks);
        this.field_148161_k.field_71466_p.func_78276_b("Right-click on a slot and release the mouse on the action you want to perform!", 5, 5, 0xFFFFFF);
        this.drawMenu();
    }

    protected void drawMenu() {
        if (this.isClicking) {
            if (this.canUp(this.startSlot)) {
                this.field_148161_k.field_71466_p.func_175063_a("Up", (float)(this.clickedX - 4), (float)(this.clickedY - 20), 0xFFFFFF);
            }
            if (this.canDown(this.startSlot)) {
                this.field_148161_k.field_71466_p.func_175063_a("Down", (float)(this.clickedX - 10), (float)(this.clickedY + 12), 0xFFFFFF);
            }
            if (this.canAddBefore(this.startSlot) && this.startSlot >= 0) {
                this.field_148161_k.field_71466_p.func_175063_a("Add before", (float)(this.clickedX + 20), (float)(this.clickedY - 20), 0x80FF80);
            }
            if (this.canAddAfter(this.startSlot) && this.startSlot >= 0) {
                this.field_148161_k.field_71466_p.func_175063_a("Add after", (float)(this.clickedX + 20), (float)(this.clickedY + 12), 65280);
            }
            if (this.canRemove(this.startSlot)) {
                this.field_148161_k.field_71466_p.func_175063_a("Remove", (float)(this.clickedX - 50), (float)(this.clickedY - 4), 0xFF0000);
            }
        }
    }

    protected int getListStart() {
        return 0;
    }

    protected int getListEnd() {
        return this.properties.size() - 1;
    }

    private EnumSelectionType processSelection(int releasedX, int releasedY) {
        boolean bottom;
        boolean left = this.clickedX - releasedX > 10;
        boolean right = releasedX - this.clickedX > 10;
        boolean top = this.clickedY - releasedY > 10;
        boolean bl = bottom = releasedY - this.clickedY > 10;
        return EnumSelectionType.of(left ? 0 : (right ? 2 : 1), top ? 0 : (bottom ? 2 : 1));
    }

    protected void init() {
        this.add = new GuiButton(0, this.field_148152_e + this.field_148155_a / 4, this.field_148153_b + this.field_148160_j + this.getListStart() * this.field_148149_f + 3, this.field_148155_a / 2, 20, "Add new");
        this.listUpdated();
    }

    protected void listUpdated() {
        this.add.field_146125_m = this.properties.size() == this.getListStart();
    }

    protected abstract T newProperty(int var1);

    protected static enum EnumSelectionType {
        TOP_LEFT(0, 0),
        TOP_CENTER(1, 0),
        TOP_RIGHT(2, 0),
        CENTER_LEFT(0, 1),
        CENTER_RIGHT(2, 1),
        BOTTOM_LEFT(0, 2),
        BOTTOM_CENTER(1, 2),
        BOTTOM_RIGHT(2, 2);

        private int relativeX;
        private int relativeY;

        private EnumSelectionType(int relativeX, int relativeY) {
            this.relativeX = relativeX;
            this.relativeY = relativeY;
        }

        @Nullable
        public static EnumSelectionType of(int relativeX, int relativeY) {
            for (EnumSelectionType type : EnumSelectionType.values()) {
                if (type.relativeX != relativeX || type.relativeY != relativeY) continue;
                return type;
            }
            return null;
        }

        public boolean isLeft() {
            return this.relativeX == 0;
        }

        public boolean isHCenter() {
            return this.relativeX == 1;
        }

        public boolean isRight() {
            return this.relativeX == 0;
        }

        public boolean isTop() {
            return this.relativeY == 0;
        }

        public boolean isVCenter() {
            return this.relativeY == 1;
        }

        public boolean isBottom() {
            return this.relativeY == 2;
        }
    }
}

