/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.gui.property;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiListExtended;
import net.minecraft.client.gui.GuiTextField;

public abstract class BaseProperty<V>
implements GuiListExtended.IGuiListEntry {
    protected static final Minecraft mc = Minecraft.func_71410_x();
    private final List<GuiButton> buttonList = new ArrayList<GuiButton>();
    private final List<GuiTextField> textfieldList = new ArrayList<GuiTextField>();
    private final Supplier<V> defaultValue;
    private final Consumer<V> apply;
    private final GuiButton undo = new GuiButton(0, 0, 0, 20, 20, "\u21b6");
    protected int slotTop;
    protected int slotBottom;
    protected int slotLeft;
    protected int slotRight;
    private String name;
    private V value;

    public BaseProperty(String name, Supplier<V> value, Consumer<V> apply) {
        this.name = name;
        this.defaultValue = value;
        this.apply = apply;
        this.buttonList.add(this.undo);
        this.reset();
    }

    public BaseProperty(String name, Supplier<V> value) {
        this(name, value, v -> {});
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V getValue() {
        return this.value;
    }

    public void setValue(V value) {
        this.value = value;
    }

    public List<GuiButton> getButtonList() {
        return this.buttonList;
    }

    public List<GuiTextField> getTextfieldList() {
        return this.textfieldList;
    }

    public void place0(int slotTop, int slotBottom, int slotLeft, int slotRight) {
        this.slotTop = slotTop + 5;
        this.slotBottom = slotBottom;
        this.slotLeft = slotLeft;
        this.slotRight = slotRight;
        this.place();
    }

    public void apply() {
        this.apply.accept(this.value);
    }

    protected void init() {
    }

    public void reset() {
        this.setValue(this.defaultValue.get());
    }

    protected void place() {
        this.undo.field_146128_h = this.slotRight - 30;
        this.undo.field_146129_i = this.slotTop;
    }

    public void keyTyped(char typedChar, int keyCode) {
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        if (this.undo.func_146116_c(mc, mouseX, mouseY)) {
            this.reset();
            this.init();
        }
    }

    public void updateScreen() {
    }

    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        this.undo.func_191745_a(mc, mouseX, mouseY, partialTicks);
    }

    public void func_192633_a(int slotIndex, int x, int y, float partialTicks) {
    }

    public boolean func_148278_a(int slotIndex, int mouseX, int mouseY, int mouseEvent, int relativeX, int relativeY) {
        return true;
    }

    public void func_148277_b(int slotIndex, int x, int y, int mouseEvent, int relativeX, int relativeY) {
    }
}

