/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.gui.property.item;

import com.github.franckyi.ibeeditor.gui.base.GuiIntValueField;
import com.github.franckyi.ibeeditor.gui.property.BaseProperty;
import com.github.franckyi.ibeeditor.models.PotionEffectModel;
import java.util.Arrays;
import java.util.function.Supplier;
import net.minecraft.client.resources.I18n;
import net.minecraft.potion.Potion;
import net.minecraftforge.fml.client.config.GuiCheckBox;

public class PotionEffectProperty
extends BaseProperty<PotionEffectModel> {
    private GuiIntValueField idTextField;
    private GuiIntValueField amplifierTextField;
    private GuiIntValueField durationTextField;
    private GuiCheckBox ambientCheckbox;
    private GuiCheckBox showParticlesCheckbox;

    public PotionEffectProperty(Supplier<PotionEffectModel> value) {
        super("Unknown Potion", value);
        this.idTextField = new GuiIntValueField(0, PotionEffectProperty.mc.field_71466_p, 0, 0, 20, 14);
        this.amplifierTextField = new GuiIntValueField(0, PotionEffectProperty.mc.field_71466_p, 0, 0, 20, 14);
        this.durationTextField = new GuiIntValueField(0, PotionEffectProperty.mc.field_71466_p, 0, 0, 60, 14);
        this.ambientCheckbox = new GuiCheckBox(0, 0, 0, "Ambient", false);
        this.showParticlesCheckbox = new GuiCheckBox(0, 0, 0, "Show Particles", false);
        this.getButtonList().addAll(Arrays.asList(this.ambientCheckbox, this.showParticlesCheckbox));
        this.getTextfieldList().addAll(Arrays.asList(this.idTextField, this.amplifierTextField, this.durationTextField));
        this.init();
    }

    @Override
    protected void init() {
        this.idTextField.func_146180_a(String.valueOf(((PotionEffectModel)this.getValue()).getId()));
        this.amplifierTextField.func_146180_a(String.valueOf(((PotionEffectModel)this.getValue()).getAmplifier()));
        this.durationTextField.func_146180_a(String.valueOf(((PotionEffectModel)this.getValue()).getDuration()));
        this.ambientCheckbox.setIsChecked(((PotionEffectModel)this.getValue()).isAmbient());
        this.showParticlesCheckbox.setIsChecked(((PotionEffectModel)this.getValue()).isShowParticles());
        Potion potion = Potion.func_188412_a((int)((PotionEffectModel)this.getValue()).getId());
        this.setName(potion == null ? "Unknown Potion" : I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]));
    }

    @Override
    protected void place() {
        super.place();
        this.idTextField.field_146209_f = this.slotRight - 160;
        this.idTextField.field_146210_g = this.slotTop + 3;
        this.amplifierTextField.field_146209_f = this.slotRight - 130;
        this.amplifierTextField.field_146210_g = this.slotTop + 3;
        this.durationTextField.field_146209_f = this.slotRight - 100;
        this.durationTextField.field_146210_g = this.slotTop + 3;
        this.ambientCheckbox.field_146128_h = this.slotLeft + 10;
        this.ambientCheckbox.field_146129_i = this.slotTop + 25;
        this.showParticlesCheckbox.field_146128_h = this.slotLeft + 150;
        this.showParticlesCheckbox.field_146129_i = this.slotTop + 25;
    }

    @Override
    public void keyTyped(char typedChar, int keyCode) {
        this.idTextField.func_146201_a(typedChar, keyCode);
        this.amplifierTextField.func_146201_a(typedChar, keyCode);
        this.durationTextField.func_146201_a(typedChar, keyCode);
        ((PotionEffectModel)this.getValue()).setId((Integer)this.idTextField.getValue());
        ((PotionEffectModel)this.getValue()).setAmplifier((Integer)this.amplifierTextField.getValue());
        ((PotionEffectModel)this.getValue()).setDuration((Integer)this.durationTextField.getValue());
        Potion potion = Potion.func_188412_a((int)((PotionEffectModel)this.getValue()).getId());
        this.setName(potion == null ? "Unknown Potion" : I18n.func_135052_a((String)potion.func_76393_a(), (Object[])new Object[0]));
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        this.idTextField.func_146192_a(mouseX, mouseY, mouseButton);
        this.amplifierTextField.func_146192_a(mouseX, mouseY, mouseButton);
        this.durationTextField.func_146192_a(mouseX, mouseY, mouseButton);
        this.ambientCheckbox.func_146116_c(mc, mouseX, mouseY);
        this.showParticlesCheckbox.func_146116_c(mc, mouseX, mouseY);
        ((PotionEffectModel)this.getValue()).setAmbient(this.ambientCheckbox.isChecked());
        ((PotionEffectModel)this.getValue()).setShowParticles(this.showParticlesCheckbox.isChecked());
    }

    @Override
    public void func_192634_a(int slotIndex, int x, int y, int listWidth, int slotHeight, int mouseX, int mouseY, boolean isSelected, float partialTicks) {
        super.func_192634_a(slotIndex, x, y, listWidth, slotHeight, mouseX, mouseY, isSelected, partialTicks);
        PotionEffectProperty.mc.field_71466_p.func_78276_b(this.getName(), x + 5, this.slotTop + 6, 0xFFFFFF);
        this.idTextField.func_146194_f();
        this.amplifierTextField.func_146194_f();
        this.durationTextField.func_146194_f();
        this.ambientCheckbox.func_191745_a(mc, mouseX, mouseY, partialTicks);
        this.showParticlesCheckbox.func_191745_a(mc, mouseX, mouseY, partialTicks);
    }
}

