/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.network;

import com.github.franckyi.ibeeditor.IBEEditor;
import com.github.franckyi.ibeeditor.network.ICustomMessageHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class UpdateItemMessage
implements IMessage {
    private ItemStack itemStack = ItemStack.field_190927_a;
    private int slotId = -1;
    private BlockPos blockPos;
    private boolean flag;

    public UpdateItemMessage() {
    }

    public UpdateItemMessage(ItemStack itemStack, int slotId, BlockPos blockPos) {
        this.itemStack = itemStack;
        this.slotId = slotId;
        this.blockPos = blockPos;
    }

    public void fromBytes(ByteBuf buf) {
        this.itemStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.slotId = buf.readInt();
        this.flag = buf.readBoolean();
        if (this.flag) {
            this.blockPos = BlockPos.func_177969_a((long)buf.readLong());
        }
    }

    public void toBytes(ByteBuf buf) {
        this.flag = this.blockPos != null;
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.itemStack);
        buf.writeInt(this.slotId);
        buf.writeBoolean(this.flag);
        if (this.flag) {
            buf.writeLong(this.blockPos.func_177986_g());
        }
    }

    public static class UpdateItemMessageHandler
    implements ICustomMessageHandler<UpdateItemMessage> {
        @Override
        public void accept(UpdateItemMessage message, MessageContext ctx) {
            if (message.blockPos == null) {
                if (message.slotId < 0) {
                    ctx.getServerHandler().field_147369_b.field_71071_by.func_70441_a(message.itemStack);
                } else {
                    ctx.getServerHandler().field_147369_b.field_71071_by.func_70299_a(message.slotId, message.itemStack);
                }
            } else {
                TileEntity te = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.blockPos);
                if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) && te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null) != null) {
                    ((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).extractItem(message.slotId, Integer.MAX_VALUE, false);
                    ((IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)).insertItem(message.slotId, message.itemStack, false);
                    te.func_70296_d();
                } else {
                    IBEEditor.logger.warn("Couldn't insert the item in the TileEntity at pos [x={};y={};z={}]. Injecting in player's inventory instead.", (Object)message.blockPos.func_177958_n(), (Object)message.blockPos.func_177956_o(), (Object)message.blockPos.func_177952_p());
                    ctx.getServerHandler().field_147369_b.field_71071_by.func_70441_a(message.itemStack);
                }
            }
        }
    }
}

