/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.IValueNode;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.Scene;
import com.github.franckyi.guapi.gui.IGuiView;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.GuiUtils;

public class CheckBox
extends Node<GuiCheckBoxView>
implements IValueNode<Boolean> {
    private final Set<BiConsumer<Boolean, Boolean>> onValueChangedListeners = new HashSet<BiConsumer<Boolean, Boolean>>();

    public CheckBox() {
        this("", false);
    }

    public CheckBox(String text) {
        this(text, false);
    }

    public CheckBox(boolean checked) {
        this("", checked);
    }

    public CheckBox(String text, boolean checked) {
        super(new GuiCheckBoxView(text, checked, new String[0]));
        this.computeSize();
        this.updateSize();
    }

    public String getText() {
        return ((GuiCheckBoxView)this.getView()).getMessage();
    }

    public void setText(String text) {
        ((GuiCheckBoxView)this.getView()).setMessage(text);
    }

    public boolean getValue() {
        return ((GuiCheckBoxView)this.getView()).isChecked();
    }

    public void setValue(boolean checked) {
        boolean old = this.getValue();
        ((GuiCheckBoxView)this.getView()).setChecked(checked);
        if (old != checked) {
            this.onValueChanged(old, checked);
        }
    }

    public List<String> getTooltipText() {
        return ((GuiCheckBoxView)this.getView()).tooltipText;
    }

    public boolean isDisabled() {
        return !((GuiCheckBoxView)this.getView()).active;
    }

    public void setDisabled(boolean disabled) {
        ((GuiCheckBoxView)this.getView()).active = !disabled;
    }

    public int getSpacing() {
        return ((GuiCheckBoxView)this.getView()).spacing;
    }

    public void setSpacing(int spacing) {
        ((GuiCheckBoxView)this.getView()).spacing = spacing;
    }

    @Override
    protected void computeWidth() {
        this.setComputedWidth(11 + this.getSpacing() + CheckBox.mc.field_71466_p.func_78256_a(this.getText()));
    }

    @Override
    protected void computeHeight() {
        this.setComputedHeight(11);
    }

    @Override
    public boolean onMouseClicked(GuiScreenEvent.MouseClickedEvent event) {
        if (super.onMouseClicked(event)) {
            this.setValue(!this.getValue());
            return true;
        }
        return false;
    }

    @Override
    public Set<BiConsumer<Boolean, Boolean>> getOnValueChangedListeners() {
        return this.onValueChangedListeners;
    }

    public static class GuiCheckBoxView
    extends GuiButtonExt
    implements IGuiView {
        private int spacing = 4;
        private boolean checked;
        private final List<String> tooltipText;
        private Scene.GUAPIScreen screen;

        public GuiCheckBoxView(String displayString, boolean checked, String ... tooltipText) {
            super(0, 0, 0, 0, displayString, b -> {});
            this.checked = checked;
            this.tooltipText = Lists.newArrayList((Object[])tooltipText);
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean checked) {
            this.checked = checked;
        }

        @Override
        public int getViewX() {
            return this.x;
        }

        @Override
        public void setViewX(int x) {
            this.x = x;
        }

        @Override
        public int getViewY() {
            return this.y;
        }

        @Override
        public void setViewY(int y) {
            this.y = y;
        }

        @Override
        public int getViewWidth() {
            return super.getWidth();
        }

        @Override
        public void setViewWidth(int width) {
            super.setWidth(width);
        }

        @Override
        public int getViewHeight() {
            return this.height;
        }

        @Override
        public void setViewHeight(int height) {
            this.height = height;
        }

        @Override
        public boolean isViewVisible() {
            return this.visible;
        }

        @Override
        public void setViewVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public void renderView(int mouseX, int mouseY, float partialTicks) {
            int boxSize = this.height;
            GuiUtils.drawContinuousTexturedBox((ResourceLocation)WIDGETS_LOCATION, (int)this.x, (int)this.y, (int)0, (int)46, (int)boxSize, (int)this.height, (int)200, (int)20, (int)2, (int)3, (int)2, (int)2, (float)this.blitOffset);
            if (this.checked) {
                this.drawCenteredString(IScreenEventListener.mc.field_71466_p, "x", this.x + boxSize / 2 + 1, this.y + 1, 0xE0E0E0);
            }
            this.drawString(IScreenEventListener.mc.field_71466_p, this.getMessage(), this.x + boxSize + this.spacing, this.y + 2, 0xFFFFFF);
            if (this.inBounds(mouseX, mouseY)) {
                if (this.screen == null) {
                    this.screen = (Scene.GUAPIScreen)IScreenEventListener.mc.field_71462_r;
                }
                this.screen.renderTooltip(this.tooltipText, mouseX, mouseY);
            }
        }
    }
}

