/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.node.TextFieldBase;

public abstract class NumberField<T extends Number>
extends TextFieldBase<T> {
    private T min;
    private T max;

    protected NumberField(T value, T min, T max) {
        this.min = min;
        this.max = max;
        ((TextFieldBase.GuiTextFieldView)this.getView()).func_200675_a(s -> {
            if (s.isEmpty() || s.equals("-")) {
                return true;
            }
            try {
                T t = this.fromString((String)s);
                return ((Comparable)t).compareTo(this.min) >= 0 && ((Comparable)t).compareTo(this.max) <= 0;
            }
            catch (NumberFormatException e) {
                return false;
            }
        });
        this.setValue(value);
    }

    public T getMin() {
        return this.min;
    }

    public void setMin(T min) {
        this.min = min;
        if (((Comparable)this.getValue()).compareTo(min) < 0) {
            this.setValue(min);
        }
    }

    public T getMax() {
        return this.max;
    }

    public void setMax(T max) {
        this.max = max;
        if (((Comparable)this.getValue()).compareTo(max) > 0) {
            this.setValue(max);
        }
    }

    @Override
    public T getValue() {
        String s = this.getText();
        if (s.isEmpty() || s.equals("-")) {
            return this.getMin();
        }
        try {
            return this.fromString(s);
        }
        catch (NumberFormatException e) {
            return this.getMin();
        }
    }

    @Override
    public void setValue(T value) {
        this.setText(this.toString(value));
    }

    protected abstract T fromString(String var1) throws NumberFormatException;

    protected abstract String toString(T var1);
}

