/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.IValueNode;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.Scene;
import com.github.franckyi.guapi.gui.IGuiView;
import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.widget.TextFieldWidget;

public abstract class TextFieldBase<T>
extends Node<GuiTextFieldView>
implements IValueNode<T> {
    private final Set<BiConsumer<T, T>> onValueChangedListeners = new HashSet<BiConsumer<T, T>>();
    private T oldVal;

    public TextFieldBase() {
        super(new GuiTextFieldView(new String[0]));
        this.computeSize();
        this.updateSize();
    }

    @Override
    public int getWidth() {
        return super.getWidth() + 2;
    }

    @Override
    public int getX() {
        return super.getX() - 1;
    }

    @Override
    protected void computeWidth() {
        this.setComputedWidth(100 + this.getPadding().getHorizontal());
    }

    @Override
    protected void computeHeight() {
        this.setComputedHeight(16 + this.getPadding().getVertical());
    }

    public void tick() {
        ((GuiTextFieldView)this.getView()).func_146178_a();
        if (((GuiTextFieldView)this.getView()).changed) {
            this.onValueChanged(this.oldVal, this.getValue());
        }
        ((GuiTextFieldView)this.getView()).changed = false;
        this.oldVal = this.getValue();
    }

    @Override
    public Set<BiConsumer<T, T>> getOnValueChangedListeners() {
        return this.onValueChangedListeners;
    }

    public abstract T getValue();

    public abstract void setValue(T var1);

    protected final String getText() {
        return ((GuiTextFieldView)this.getView()).func_146179_b();
    }

    protected final void setText(String text) {
        ((GuiTextFieldView)this.getView()).func_146180_a(text);
    }

    public List<String> getTooltipText() {
        return ((GuiTextFieldView)this.getView()).tooltipText;
    }

    public static class GuiTextFieldView
    extends TextFieldWidget
    implements IGuiView {
        private final List<String> tooltipText;
        private Scene.GUAPIScreen screen;
        private boolean changed;
        private boolean flag;

        public GuiTextFieldView(String ... tooltipText) {
            super(IScreenEventListener.mc.field_71466_p, 0, 0, 0, 0, "");
            this.tooltipText = Lists.newArrayList((Object[])tooltipText);
            this.func_146203_f(Short.MAX_VALUE);
        }

        @Override
        public int getViewX() {
            return this.x;
        }

        @Override
        public void setViewX(int x) {
            this.x = x;
        }

        @Override
        public int getViewY() {
            return this.y;
        }

        @Override
        public void setViewY(int y) {
            this.y = y;
        }

        @Override
        public int getViewWidth() {
            return this.getWidth();
        }

        @Override
        public void setViewWidth(int width) {
            this.setWidth(width);
        }

        @Override
        public int getViewHeight() {
            return this.getHeight();
        }

        @Override
        public void setViewHeight(int height) {
            this.setHeight(height);
        }

        @Override
        public boolean isViewVisible() {
            return this.func_146176_q();
        }

        @Override
        public void setViewVisible(boolean visible) {
            this.func_146189_e(visible);
        }

        @Override
        public void renderView(int mouseX, int mouseY, float partialTicks) {
            if (!this.flag) {
                this.flag = true;
                this.func_146190_e(0);
            }
            this.render(mouseX, mouseY, partialTicks);
            if (this.inBounds(mouseX, mouseY)) {
                if (this.screen == null) {
                    this.screen = (Scene.GUAPIScreen)IScreenEventListener.mc.field_71462_r;
                }
                this.screen.renderTooltip(this.tooltipText, mouseX, mouseY);
            }
        }

        @Override
        public boolean inBounds(double x, double y) {
            return x >= (double)this.getViewX() && x <= (double)(this.getViewX() + this.getViewWidth()) && y >= (double)this.getViewY() && y <= (double)(this.getViewY() + this.getViewHeight());
        }

        public void func_146180_a(String textIn) {
            String old = this.func_146179_b();
            super.func_146180_a(textIn);
            this.changed = !this.func_146179_b().equals(old);
        }

        public void func_146191_b(String textToWrite) {
            String old = this.func_146179_b();
            super.func_146191_b(textToWrite);
            this.changed = !this.func_146179_b().equals(old);
        }

        public void func_146175_b(int num) {
            String old = this.func_146179_b();
            super.func_146175_b(num);
            this.changed = !this.func_146179_b().equals(old);
        }

        public void func_146203_f(int length) {
            String old = this.func_146179_b();
            super.func_146203_f(length);
            this.changed = !this.func_146179_b().equals(old);
        }
    }
}

