/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.Scene;
import com.github.franckyi.guapi.util.Notification;
import com.github.franckyi.ibeeditor.client.EditorHelper;
import com.github.franckyi.ibeeditor.client.EntityIcons;
import com.github.franckyi.ibeeditor.client.clipboard.IBEClipboard;
import com.github.franckyi.ibeeditor.client.gui.clipboard.ViewClipboard;
import com.github.franckyi.ibeeditor.common.IProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.client.settings.KeyModifier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;

public class ClientProxy
implements IProxy {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final String KEYBINDING_CATEGORY = "IBE Editor";
    private static final KeyBinding KEY_OPEN_EDITOR = new KeyBinding("Open GUI", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, InputMappings.Type.KEYSYM, 73, "IBE Editor");
    private static final KeyBinding KEY_OPEN_CLIPBOARD = new KeyBinding("Open IBE clipboard", (IKeyConflictContext)KeyConflictContext.UNIVERSAL, KeyModifier.NONE, InputMappings.Type.KEYSYM, 74, "IBE Editor");

    @Override
    public void onSetup() {
        MinecraftForge.EVENT_BUS.addListener(this::onClientTick);
        MinecraftForge.EVENT_BUS.addListener(this::onKeyPressed);
        MinecraftForge.EVENT_BUS.addListener(this::onWorldUnload);
        MinecraftForge.EVENT_BUS.register(Node.NodeEventHandler.class);
        MinecraftForge.EVENT_BUS.register(Scene.ScreenEventHandler.class);
        MinecraftForge.EVENT_BUS.register(Notification.class);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_OPEN_EDITOR);
        ClientRegistry.registerKeyBinding((KeyBinding)KEY_OPEN_CLIPBOARD);
        IBEClipboard.getInstance().load();
        EntityIcons.setup();
    }

    private void onClientTick(TickEvent.ClientTickEvent e) {
        if (e.phase == TickEvent.Phase.END) {
            if (KEY_OPEN_EDITOR.func_151468_f()) {
                EditorHelper.openEditor();
            } else if (KEY_OPEN_CLIPBOARD.func_151468_f()) {
                new ViewClipboard();
            }
        }
    }

    private void onKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Pre e) {
        ContainerScreen gui;
        Minecraft.func_71410_x().field_71417_B.func_198032_j();
        if (e.getGui() instanceof ContainerScreen && e.getKeyCode() == KEY_OPEN_EDITOR.getKey().func_197937_c() && (gui = (ContainerScreen)e.getGui()).getSlotUnderMouse() != null && gui.getSlotUnderMouse().func_75216_d()) {
            if (gui instanceof InventoryScreen || gui instanceof CreativeScreen) {
                EditorHelper.openItemEditorFromPlayerInventory(gui.getSlotUnderMouse());
            } else if (ClientProxy.mc.field_71476_x instanceof BlockRayTraceResult) {
                EditorHelper.openItemEditorFromBlockInventory(gui.getSlotUnderMouse(), ((BlockRayTraceResult)ClientProxy.mc.field_71476_x).func_216350_a());
            } else if (ClientProxy.mc.field_71476_x instanceof EntityRayTraceResult) {
                EditorHelper.openItemEditorFromEntityInventory(gui.getSlotUnderMouse(), ((EntityRayTraceResult)ClientProxy.mc.field_71476_x).func_216348_a());
            }
        }
    }

    private void onWorldUnload(WorldEvent.Unload event) {
        EditorHelper.setServerEnabled(false);
    }
}

