/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client;

import com.github.franckyi.ibeeditor.IBEEditorMod;
import com.github.franckyi.ibeeditor.client.IBENotification;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import org.apache.logging.log4j.MarkerManager;

public final class ClientUtils {
    private static final Minecraft mc = Minecraft.func_71410_x();
    private static final ITextComponent COMMAND_SENT_MESSAGE = new StringTextComponent("[IBE Editor] Command sent.").func_211708_a(TextFormatting.GREEN);
    private static final ITextComponent COMMAND_COPIED_MESSAGE = new StringTextComponent("[IBE Editor] Command copied in your clipboard. Paste it in a ").func_211708_a(TextFormatting.YELLOW).func_150257_a(new TranslationTextComponent("block.minecraft.command_block", new Object[0]).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/give @p minecraft:command_block 1")).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (ITextComponent)new StringTextComponent(new ItemStack((IItemProvider)Items.field_221747_dJ).func_77955_b(new CompoundNBT()).toString()))).func_150238_a(TextFormatting.LIGHT_PURPLE).func_150228_d(Boolean.valueOf(true)))).func_150257_a((ITextComponent)new StringTextComponent(" to apply the changes."));

    public static Entity createEntity(CompoundNBT entityTag) {
        EntityType entityType = EntityType.func_220327_a((String)entityTag.func_74779_i("id")).orElse(EntityType.field_200784_X);
        return ClientUtils.createEntity(entityType, entityTag);
    }

    public static <T extends Entity> T createEntity(EntityType<T> entityType, CompoundNBT entityTag) {
        Entity entity = entityType.func_200721_a((World)Minecraft.func_71410_x().field_71441_e);
        entity.func_70020_e(entityTag);
        return (T)entity;
    }

    public static CompoundNBT getCleanEntityTag(Entity entity) {
        CompoundNBT tag = new CompoundNBT();
        entity.func_184198_c(tag);
        tag.func_82580_o("UUIDMost");
        tag.func_82580_o("UUIDLeast");
        tag.func_82580_o("Pos");
        return tag;
    }

    private static void copyCommand(String command) {
        ClientUtils.mc.field_195559_v.func_197960_a(command);
        IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Command copied to clipboard.");
    }

    public static String getGiveCommand(ResourceLocation name, CompoundNBT tag, int count) {
        return String.format("/give @p %s%s %d", name, tag, count);
    }

    public static String getGiveCommand(ItemStack itemStack) {
        return ClientUtils.getGiveCommand(itemStack.func_77973_b().getRegistryName(), itemStack.func_196082_o(), itemStack.func_190916_E());
    }

    public static String getGiveCommand(BlockState blockState, TileEntity tileEntity) {
        CompoundNBT tag = new CompoundNBT();
        return ClientUtils.getGiveCommand(blockState.func_177230_c().getRegistryName(), tileEntity == null ? tag : tileEntity.func_189515_b(tag), 1);
    }

    public static String getSetblockCommand(BlockState blockState, TileEntity tileEntity) {
        return ClientUtils.getSetblockCommand(null, blockState, tileEntity);
    }

    public static String getSetblockCommand(BlockPos blockPos, BlockState blockState, TileEntity tileEntity) {
        StringBuilder builder = new StringBuilder("[");
        blockState.func_206869_a().forEach(property -> builder.append(property.func_177701_a()).append("=").append(blockState.func_177229_b(property).toString().toLowerCase()).append(","));
        if (builder.length() > 1) {
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append("]");
        CompoundNBT tag = new CompoundNBT();
        return String.format("/setblock %s %s%s%s", blockPos == null ? "~ ~ ~" : String.format("%d %d %d", blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p()), blockState.func_177230_c().getRegistryName(), builder, tileEntity == null ? tag : tileEntity.func_189515_b(tag));
    }

    public static String getSummonCommand(Entity entity) {
        return String.format("/summon %s ~ ~ ~ %s", entity.func_200600_R().getRegistryName(), ClientUtils.getCleanEntityTag(entity));
    }

    public static void copyGiveCommand(ItemStack itemStack) {
        ClientUtils.copyCommand(ClientUtils.getGiveCommand(itemStack));
    }

    public static void copyGiveCommandWithoutFormatting(ItemStack itemStack) {
        ClientUtils.copyCommand(TextFormatting.func_110646_a((String)ClientUtils.getGiveCommand(itemStack)));
    }

    public static void copyGiveCommand(BlockState blockState, TileEntity tileEntity) {
        ClientUtils.copyCommand(ClientUtils.getGiveCommand(blockState, tileEntity));
    }

    public static void copyGiveCommandWithoutFormatting(BlockState blockState, TileEntity tileEntity) {
        ClientUtils.copyCommand(TextFormatting.func_110646_a((String)ClientUtils.getGiveCommand(blockState, tileEntity)));
    }

    public static void copySetblockCommand(BlockState blockState, TileEntity tileEntity) {
        ClientUtils.copyCommand(ClientUtils.getSetblockCommand(blockState, tileEntity));
    }

    public static void copySetblockCommandWithoutFormatting(BlockState blockState, TileEntity tileEntity) {
        ClientUtils.copyCommand(TextFormatting.func_110646_a((String)ClientUtils.getSetblockCommand(blockState, tileEntity)));
    }

    public static void copySummonCommand(Entity entity) {
        ClientUtils.copyCommand(ClientUtils.getSummonCommand(entity));
    }

    public static void copySummonCommandWithoutFormatting(Entity entity) {
        ClientUtils.copyCommand(TextFormatting.func_110646_a((String)ClientUtils.getSummonCommand(entity)));
    }

    public static String getReplaceItemCommandForPlayerMainHand(ItemStack itemStack) {
        return String.format("/replaceitem entity @p weapon.mainhand %s%s %d", itemStack.func_77973_b().getRegistryName(), itemStack.func_196082_o(), itemStack.func_190916_E());
    }

    public static String getReplaceItemCommandForPlayer(ItemStack itemStack, Slot slot) {
        return String.format("/replaceitem entity @p container.%d %s%s %d", slot.field_75222_d, itemStack.func_77973_b().getRegistryName(), itemStack.func_196082_o(), itemStack.func_190916_E());
    }

    public static String getReplaceItemCommandForBlock(ItemStack itemStack, Slot slot, BlockPos pos) {
        return String.format("/replaceitem block %d %d %d container.%d %s%s %d", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), slot.field_75222_d, itemStack.func_77973_b().getRegistryName(), itemStack.func_196082_o(), itemStack.func_190916_E());
    }

    public static String getReplaceItemCommandForEntity(ItemStack itemStack, Slot slot, Entity entity) {
        return String.format("/replaceitem entity %s container.%d %s%s %d", entity.func_110124_au(), slot.field_75222_d, itemStack.func_77973_b().getRegistryName(), itemStack.func_196082_o(), itemStack.func_190916_E());
    }

    public static String getEntityData(Entity entity, INBT tag) {
        return String.format("/data merge entity %s %s", entity.func_110124_au(), tag);
    }

    public static boolean handleCommand(String command) {
        IBEEditorMod.LOGGER.debug(MarkerManager.getMarker((String)"COMMAND"), command);
        if (command.length() < 256) {
            ClientUtils.sendCommand(command);
            ClientUtils.mc.field_71439_g.func_145747_a(COMMAND_SENT_MESSAGE);
            return true;
        }
        ClientUtils.copyCommand(command);
        ClientUtils.mc.field_71439_g.func_145747_a(COMMAND_COPIED_MESSAGE);
        return false;
    }

    public static void sendCommand(String command) {
        ClientUtils.mc.field_71439_g.func_71165_d(command);
    }
}

