/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.base;

import com.github.franckyi.guapi.IValueNode;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.node.ListExtended;
import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.ibeeditor.client.gui.IResizable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.util.text.TextFormatting;

public abstract class AbstractProperty<T>
extends ListExtended.NodeEntry<HBox>
implements IValueNode<T>,
IResizable {
    protected final TexturedButton resetButton;
    protected final T initialValue;
    protected final Consumer<T> action;
    private final Set<BiConsumer<T, T>> onValueChangedListeners;

    public AbstractProperty(T initialValue, Consumer<T> action) {
        super(new HBox(1));
        this.initialValue = initialValue;
        this.action = action;
        this.onValueChangedListeners = new HashSet<BiConsumer<T, T>>();
        this.build();
        this.setValue(initialValue);
        Node[] nodeArray = new Node[1];
        this.resetButton = new TexturedButton("reset.png", TextFormatting.YELLOW + "Reset to default");
        nodeArray[0] = this.resetButton;
        this.addAll(nodeArray);
        this.resetButton.getOnMouseClickedListeners().add(e -> this.setValue(initialValue));
    }

    @Override
    public Set<BiConsumer<T, T>> getOnValueChangedListeners() {
        return this.onValueChangedListeners;
    }

    protected abstract T getValue();

    protected abstract void setValue(T var1);

    protected abstract void build();

    public void apply() {
        this.action.accept(this.getValue());
    }

    public final void addAll(Node ... nodes) {
        ((HBox)this.getNode()).getChildren().addAll(Arrays.asList(nodes));
    }
}

