/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.base.category;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.math.Pos;
import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.IEditableCategoryProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.util.text.TextFormatting;

public abstract class EditableCategory<T>
extends AbstractCategory {
    private int editableStart;

    public EditableCategory() {
        this(0);
    }

    public EditableCategory(int editableStart) {
        this.editableStart = editableStart;
    }

    protected void addProperty(T initialValue) {
        int index = this.getPropertyCount();
        AbstractProperty<T> p = this.createNewProperty(initialValue, index);
        this.getChildren().add(index + this.editableStart, p);
        p.updateSize(this.getWidth());
    }

    protected abstract AbstractProperty<T> createNewProperty(T var1, int var2);

    protected abstract T getDefaultPropertyValue();

    protected IEditableCategoryProperty getProperty(int index) {
        return (IEditableCategoryProperty)this.getChildren().get(index + this.editableStart);
    }

    public void swapProperties(int i1, int i2) {
        if (i1 >= 0 && i2 < this.getPropertyCount()) {
            List list = this.getChildren();
            Collections.swap(list, i1 + this.editableStart, i2 + this.editableStart);
            this.getProperty(i1).update(i1);
            this.getProperty(i2).update(i2);
        }
    }

    public void removeProperty(int index) {
        this.getChildren().remove(index + this.editableStart);
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            this.getProperty(i).update(i);
        }
    }

    public int getPropertyCount() {
        return this.getChildren().size() - (1 + this.editableStart);
    }

    protected class AddButton
    extends AbstractProperty<Void> {
        private TexturedButton button;

        public AddButton() {
            this("");
        }

        public AddButton(String text) {
            this(new String[]{TextFormatting.GREEN + text});
        }

        public AddButton(String ... textLines) {
            super(null, (T aVoid) -> {});
            ((HBox)this.getNode()).getChildren().remove(1);
            this.button.getText().clear();
            this.button.getText().addAll(Arrays.asList(textLines));
        }

        @Override
        protected void build() {
            Node[] nodeArray = new Node[1];
            this.button = new TexturedButton("add.png");
            nodeArray[0] = this.button;
            this.addAll(nodeArray);
            this.button.getOnMouseClickedListeners().add(event -> {
                EditableCategory.this.addProperty(EditableCategory.this.getDefaultPropertyValue());
                int count = EditableCategory.this.getPropertyCount();
                EditableCategory.this.getProperty(--count).update(count--);
                if (count >= 0) {
                    EditableCategory.this.getProperty(count).update(count);
                }
            });
            ((HBox)this.getNode()).setAlignment(Pos.CENTER);
        }

        @Override
        protected Void getValue() {
            return null;
        }

        @Override
        protected void setValue(Void value) {
        }
    }
}

