/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.base.property;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.node.NumberField;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.LabeledProperty;
import java.util.function.Consumer;

public abstract class PropertyNumber<T extends Number>
extends LabeledProperty<T> {
    protected NumberField<T> numberField;

    protected PropertyNumber(String name, T initialValue, Consumer<T> action) {
        super(name, initialValue, action);
    }

    protected PropertyNumber(String name, T initialValue, Consumer<T> action, int labelSize) {
        super(name, initialValue, action);
        this.nameLabel.setPrefWidth(labelSize);
    }

    protected PropertyNumber(String name, T initialValue, Consumer<T> action, T min, T max) {
        this(name, initialValue, action);
        this.numberField.setMin(min);
        this.numberField.setMax(max);
    }

    @Override
    public T getValue() {
        return (T)this.numberField.getValue();
    }

    @Override
    protected void setValue(T value) {
        this.numberField.setValue(value);
    }

    @Override
    protected void build() {
        super.build();
        Node[] nodeArray = new Node[1];
        this.numberField = this.createField((Number)this.initialValue);
        nodeArray[0] = this.numberField;
        this.addAll(nodeArray);
    }

    @Override
    public void updateSize(int listWidth) {
        this.numberField.setPrefWidth(listWidth - this.nameLabel.getWidth() - 0 - 64);
    }

    public NumberField<T> getNumberField() {
        return this.numberField;
    }

    protected abstract NumberField<T> createField(T var1);
}

