/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.entity;

import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.category.EditableCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.PropertyBoolean;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.custom.EntityPotionEffectProperty;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;

public class EntityPotionEffectsCategory
extends EditableCategory<EffectInstance> {
    private final LivingEntity entity;
    private final Set<EffectInstance> effects;
    private boolean hideParticles;

    public EntityPotionEffectsCategory(LivingEntity entity) {
        super(1);
        this.entity = entity;
        this.effects = new HashSet<EffectInstance>();
        this.hideParticles = entity.func_70651_bq().stream().allMatch(EffectInstance::func_82720_e);
        this.addAll(new PropertyBoolean("Hide particles", this.hideParticles, this::setHideParticles), new EditableCategory.AddButton((EditableCategory)this, "Add potion effect"));
        entity.func_70651_bq().forEach(this::addProperty);
    }

    private void setHideParticles(boolean hideParticles) {
        this.hideParticles = hideParticles;
    }

    @Override
    protected AbstractProperty<EffectInstance> createNewProperty(EffectInstance initialValue, int index) {
        return new EntityPotionEffectProperty((EditableCategory<?>)this, index, initialValue, this.effects::add);
    }

    @Override
    protected EffectInstance getDefaultPropertyValue() {
        return new EffectInstance(Effects.field_76424_c);
    }

    @Override
    public void apply() {
        this.effects.clear();
        super.apply();
        this.entity.func_193076_bZ().clear();
        this.effects.stream().map(effect -> new EffectInstance(effect.func_188419_a(), effect.func_76459_b(), effect.func_76458_c(), this.hideParticles, false, false)).forEach(effectInstance -> this.entity.func_193076_bZ().put(effectInstance.func_188419_a(), effectInstance));
    }
}

