/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.item;

import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.group.HBox;
import com.github.franckyi.guapi.math.Pos;
import com.github.franckyi.guapi.node.TextField;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.category.EditableCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.IEditableCategoryProperty;
import com.github.franckyi.ibeeditor.client.gui.editor.base.property.LabeledProperty;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockCategory
extends EditableCategory<Block> {
    private final ItemStack itemStack;
    private final String tagName;
    private boolean flag;

    public BlockCategory(ItemStack itemStack, String tagName) {
        this.itemStack = itemStack;
        this.tagName = tagName;
        this.getChildren().add(new EditableCategory.AddButton((EditableCategory)this, "Add block"));
        CompoundNBT tag = itemStack.func_196082_o();
        if (tag.func_150297_b(tagName, 9)) {
            ListNBT list = tag.func_150295_c(tagName, 8);
            for (int i = 0; i < list.size(); ++i) {
                this.addProperty(BlockCategory.stringToBlock(list.func_150307_f(i)));
            }
        }
    }

    public static Block stringToBlock(String str) {
        return (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.func_208304_a((String)str));
    }

    @Override
    public void apply() {
        this.itemStack.func_196082_o().func_82580_o(this.tagName);
        this.flag = true;
        super.apply();
    }

    private void addBlock(Block block) {
        if (this.flag) {
            this.itemStack.func_196082_o().func_218657_a(this.tagName, (INBT)new ListNBT());
            this.flag = false;
        }
        this.itemStack.func_196082_o().func_150295_c(this.tagName, 8).add((Object)new StringNBT(block.getRegistryName().toString()));
    }

    @Override
    protected AbstractProperty<Block> createNewProperty(Block initialValue, int index) {
        return new PropertyBlock(index, initialValue, this::addBlock);
    }

    @Override
    protected Block getDefaultPropertyValue() {
        return Blocks.field_150350_a;
    }

    public class PropertyBlock
    extends LabeledProperty<Block>
    implements IEditableCategoryProperty {
        private IEditableCategoryProperty.PropertyControls controls;
        private TextField blockField;

        public PropertyBlock(int index, Block initialValue, Consumer<Block> action) {
            super(initialValue.func_200291_n().func_150261_e(), initialValue, action, -1);
            this.controls = new IEditableCategoryProperty.PropertyControls(BlockCategory.this, index);
            IEditableCategoryProperty.super.build();
        }

        @Override
        protected Block getValue() {
            return BlockCategory.stringToBlock(this.blockField.getValue());
        }

        @Override
        protected void setValue(Block value) {
            this.blockField.setValue(value.getRegistryName().toString());
        }

        @Override
        public IEditableCategoryProperty.PropertyControls getControls() {
            return this.controls;
        }

        @Override
        public void build() {
            super.build();
            ((HBox)this.getNode()).setAlignment(Pos.RIGHT);
            Node[] nodeArray = new Node[1];
            this.blockField = new TextField();
            nodeArray[0] = this.blockField;
            this.addAll(nodeArray);
            this.blockField.getOnCharTypedListeners().add(e -> this.update());
            this.blockField.getOnKeyPressedListeners().add(e -> this.update());
        }

        @Override
        public void updateSize(int listWidth) {
            this.blockField.setPrefWidth(listWidth / 2 - 0 - 35);
        }

        private void update() {
            this.nameLabel.setText(this.getValue().func_200291_n().func_150261_e());
            this.updateChildrenPos();
        }
    }
}

