/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor.client.gui.editor.item;

import com.github.franckyi.guapi.node.TexturedButton;
import com.github.franckyi.ibeeditor.client.IBENotification;
import com.github.franckyi.ibeeditor.client.gui.editor.base.AbstractCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.base.CapabilityProviderEditor;
import com.github.franckyi.ibeeditor.client.gui.editor.item.AttributeModifiersCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.BlockCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.EnchantmentsCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.GeneralItemCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.HideFlagsCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.PotionCategory;
import com.github.franckyi.ibeeditor.client.gui.editor.item.ToolsItemCategory;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.PotionItem;
import net.minecraft.item.TippedArrowItem;
import net.minecraft.util.text.TextFormatting;

public class ItemEditor
extends CapabilityProviderEditor {
    private final ItemStack itemStack;
    private final Predicate<ItemStack> action;

    public static void withConsumer(ItemStack itemStack, Consumer<ItemStack> action) {
        new ItemEditor(itemStack, itemStack1 -> {
            action.accept((ItemStack)itemStack1);
            return true;
        });
    }

    public static void withPredicate(ItemStack itemStack, Predicate<ItemStack> action) {
        new ItemEditor(itemStack, action);
    }

    private ItemEditor(ItemStack itemStack, Predicate<ItemStack> action) {
        super("Item Editor :");
        this.itemStack = itemStack;
        this.action = action;
        this.header.getChildren().add(new TexturedButton(itemStack));
        this.addCategory("General", new GeneralItemCategory(itemStack));
        if (itemStack.func_77973_b() instanceof PotionItem || itemStack.func_77973_b() instanceof TippedArrowItem) {
            this.addCategory("Potion effects", new PotionCategory(itemStack));
        }
        this.applyConfigurations(this.getCapabilityConfigurations(), itemStack);
        this.addCategory("Enchantments", new EnchantmentsCategory(itemStack));
        this.addCategory("Attribute modifiers", new AttributeModifiersCategory(itemStack));
        this.addCategory("Hide Flags", new HideFlagsCategory(itemStack));
        if (itemStack.func_77973_b() instanceof BlockItem) {
            this.addCategory("Can place on", new BlockCategory(itemStack, "CanPlaceOn"));
        }
        this.addCategory("Can destroy", new BlockCategory(itemStack, "CanDestroy"));
        this.addCategory("Tools", new ToolsItemCategory(itemStack));
        this.show();
    }

    @Override
    protected void apply() {
        ItemStack baseStack = this.itemStack.func_77946_l();
        this.propertiesList.subList(1, this.propertiesList.size()).forEach(AbstractCategory::apply);
        ((AbstractCategory)this.propertiesList.get(0)).apply();
        this.header.getChildren().set(1, new TexturedButton(this.itemStack));
        if (baseStack.equals(this.itemStack, false)) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.YELLOW + "Nothing to save.");
        } else if (this.action.test(this.itemStack)) {
            IBENotification.show(IBENotification.Type.EDITOR, 3, TextFormatting.GREEN + "Item saved.");
        }
    }
}

