/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi;

import com.github.franckyi.guapi.IParent;
import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.Scene;
import com.github.franckyi.guapi.event.IEventListener;
import com.github.franckyi.guapi.gui.IGuiView;
import com.github.franckyi.guapi.math.Insets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public abstract class Node<V extends IGuiView>
implements IScreenEventListener {
    public static final int COMPUTED_SIZE = -1;
    private final Set<IEventListener<GuiScreenEvent.MouseClickedEvent>> onMouseClickedListeners;
    private final Set<IEventListener<GuiScreenEvent.MouseReleasedEvent>> onMouseReleasedListeners;
    private final Set<IEventListener<GuiScreenEvent.MouseDragEvent>> onMouseDraggedListeners;
    private final Set<IEventListener<GuiScreenEvent.MouseScrollEvent>> onMouseScrolledListeners;
    private final Set<IEventListener<GuiScreenEvent.KeyboardKeyPressedEvent>> onKeyPressedListeners;
    private final Set<IEventListener<GuiScreenEvent.KeyboardKeyReleasedEvent>> onKeyReleasedListeners;
    private final Set<IEventListener<GuiScreenEvent.KeyboardCharTypedEvent>> onCharTypedListeners;
    private final V view;
    private IParent parent;
    private int computedWidth;
    private int computedHeight;
    private int prefWidth;
    private int prefHeight;
    private Insets padding;
    private Insets margin;

    public Node(V view) {
        this.view = view;
        this.parent = null;
        this.computedWidth = 0;
        this.computedHeight = 0;
        this.prefWidth = -1;
        this.prefHeight = -1;
        this.padding = Insets.NONE;
        this.margin = Insets.NONE;
        this.onMouseClickedListeners = new HashSet<IEventListener<GuiScreenEvent.MouseClickedEvent>>();
        this.onMouseReleasedListeners = new HashSet<IEventListener<GuiScreenEvent.MouseReleasedEvent>>();
        this.onMouseDraggedListeners = new HashSet<IEventListener<GuiScreenEvent.MouseDragEvent>>();
        this.onMouseScrolledListeners = new HashSet<IEventListener<GuiScreenEvent.MouseScrollEvent>>();
        this.onKeyPressedListeners = new HashSet<IEventListener<GuiScreenEvent.KeyboardKeyPressedEvent>>();
        this.onKeyReleasedListeners = new HashSet<IEventListener<GuiScreenEvent.KeyboardKeyReleasedEvent>>();
        this.onCharTypedListeners = new HashSet<IEventListener<GuiScreenEvent.KeyboardCharTypedEvent>>();
    }

    public IParent getParent() {
        return this.parent;
    }

    public void setParent(IParent parent) {
        this.parent = parent;
        if (parent != null) {
            parent.updateChildrenPos();
        }
    }

    public Scene getScene() {
        Screen screen = Node.mc.field_71462_r;
        if (screen instanceof Scene.GUAPIScreen) {
            return ((Scene.GUAPIScreen)screen).getScene();
        }
        return null;
    }

    public int getX() {
        return this.getView().getViewX();
    }

    public void setX(int x) {
        this.getView().setViewX(x);
    }

    public int getY() {
        return this.getView().getViewY();
    }

    public void setY(int y) {
        this.getView().setViewY(y);
    }

    public void setPosition(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public int getWidth() {
        return this.getView().getViewWidth();
    }

    protected void setWidth(int width) {
        if (this.getWidth() != width) {
            this.getView().setViewWidth(width);
            if (this.getParent() != null) {
                this.getParent().updateChildrenPos();
            }
        }
    }

    public int getHeight() {
        return this.getView().getViewHeight();
    }

    protected void setHeight(int height) {
        if (this.getHeight() != height) {
            this.getView().setViewHeight(height);
            if (this.getParent() != null) {
                this.getParent().updateChildrenPos();
            }
        }
    }

    protected void setSize(int width, int height) {
        boolean flag = false;
        if (this.getWidth() != width) {
            this.getView().setViewWidth(width);
            flag = true;
        }
        if (this.getHeight() != height) {
            this.getView().setViewHeight(height);
            flag = true;
        }
        if (flag && this.getParent() != null) {
            this.getParent().updateChildrenPos();
        }
    }

    public int getComputedWidth() {
        return this.computedWidth;
    }

    public void setComputedWidth(int computedWidth) {
        this.computedWidth = computedWidth;
    }

    public int getComputedHeight() {
        return this.computedHeight;
    }

    public void setComputedHeight(int computedHeight) {
        this.computedHeight = computedHeight;
    }

    public int getPrefWidth() {
        return this.prefWidth;
    }

    public void setPrefWidth(int prefWidth) {
        if (this.getPrefWidth() != prefWidth) {
            this.prefWidth = prefWidth;
            if (this.getPrefWidth() == -1) {
                this.computeWidth();
            }
            this.updateWidth();
        }
    }

    public int getPrefHeight() {
        return this.prefHeight;
    }

    public void setPrefHeight(int prefHeight) {
        if (this.getPrefHeight() != prefHeight) {
            this.prefHeight = prefHeight;
            if (this.getPrefHeight() == -1) {
                this.computeHeight();
            }
            this.updateHeight();
        }
    }

    public void setPrefSize(int prefWidth, int prefHeight) {
        if (this.getPrefHeight() != prefHeight) {
            this.prefHeight = prefHeight;
            if (this.getPrefHeight() == -1) {
                this.computeHeight();
            }
        }
        if (this.getPrefWidth() != prefWidth) {
            this.prefWidth = prefWidth;
            if (this.getPrefWidth() == -1) {
                this.computeWidth();
            }
        }
        this.updateSize();
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (!this.getPadding().equals(padding)) {
            this.padding = padding;
            this.computeSize();
            this.updateSize();
        }
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets margin) {
        if (!this.getMargin().equals(margin)) {
            Scene scene;
            boolean flag = false;
            if (this.getParent() instanceof Scene && (scene = (Scene)this.getParent()).isContentFullScreen()) {
                flag = true;
            }
            this.margin = margin;
            if (flag) {
                ((Scene)this.getParent()).setContentFullScreen();
            }
            if (this.getParent() != null) {
                this.getParent().updateChildrenPos();
            }
        }
    }

    public boolean isVisible() {
        return this.getView().isViewVisible();
    }

    public void setVisible(boolean visible) {
        this.getView().setViewVisible(visible);
    }

    public V getView() {
        return this.view;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.MouseClickedEvent>> getOnMouseClickedListeners() {
        return this.onMouseClickedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.MouseReleasedEvent>> getOnMouseReleasedListeners() {
        return this.onMouseReleasedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.MouseDragEvent>> getOnMouseDraggedListeners() {
        return this.onMouseDraggedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.MouseScrollEvent>> getOnMouseScrolledListeners() {
        return this.onMouseScrolledListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.KeyboardKeyPressedEvent>> getOnKeyPressedListeners() {
        return this.onKeyPressedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.KeyboardKeyReleasedEvent>> getOnKeyReleasedListeners() {
        return this.onKeyReleasedListeners;
    }

    @Override
    public Set<IEventListener<GuiScreenEvent.KeyboardCharTypedEvent>> getOnCharTypedListeners() {
        return this.onCharTypedListeners;
    }

    @Override
    public boolean onMouseClicked(GuiScreenEvent.MouseClickedEvent event) {
        if (this.getView().isViewVisible() && this.getView().mouseClicked(event.getMouseX(), event.getMouseY(), event.getButton())) {
            IScreenEventListener.super.onMouseClicked(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseReleased(GuiScreenEvent.MouseReleasedEvent event) {
        if (this.getView().isViewVisible() && this.getView().mouseReleased(event.getMouseX(), event.getMouseY(), event.getButton())) {
            IScreenEventListener.super.onMouseReleased(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseDragged(GuiScreenEvent.MouseDragEvent event) {
        if (this.getView().isViewVisible() && this.getView().mouseDragged(event.getMouseX(), event.getMouseY(), event.getMouseButton(), event.getDragX(), event.getDragY())) {
            IScreenEventListener.super.onMouseDragged(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean onMouseScrolled(GuiScreenEvent.MouseScrollEvent event) {
        if (this.getView().isViewVisible() && this.getView().mouseScrolled(event.getMouseX(), event.getMouseY(), event.getScrollDelta())) {
            IScreenEventListener.super.onMouseScrolled(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent event) {
        if (this.getView().isViewVisible() && this.getView().keyPressed(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            IScreenEventListener.super.onKeyPressed(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean onKeyReleased(GuiScreenEvent.KeyboardKeyReleasedEvent event) {
        if (this.getView().isViewVisible() && this.getView().func_223281_a_(event.getKeyCode(), event.getScanCode(), event.getModifiers())) {
            IScreenEventListener.super.onKeyReleased(event);
            return true;
        }
        return false;
    }

    @Override
    public boolean onCharTyped(GuiScreenEvent.KeyboardCharTypedEvent event) {
        if (this.getView().isViewVisible() && this.getView().charTyped(event.getCodePoint(), event.getModifiers())) {
            IScreenEventListener.super.onCharTyped(event);
            return true;
        }
        return false;
    }

    public void updateSize() {
        this.setSize(this.getPrefWidth() == -1 ? this.getComputedWidth() : this.getPrefWidth(), this.getPrefHeight() == -1 ? this.getComputedHeight() : this.getPrefHeight());
    }

    protected void updateWidth() {
        this.setWidth(this.getPrefWidth() == -1 ? this.getComputedWidth() : this.getPrefWidth());
    }

    protected void updateHeight() {
        this.setHeight(this.getPrefHeight() == -1 ? this.getComputedHeight() : this.getPrefHeight());
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.getView().renderView(mouseX, mouseY, partialTicks);
    }

    public void computeSize() {
        this.computeWidth();
        this.computeHeight();
    }

    protected abstract void computeWidth();

    protected abstract void computeHeight();

    public static class NodeEventHandler {
        @SubscribeEvent
        public static void onMouseClicked(GuiScreenEvent.MouseClickedEvent.Pre event) {
            NodeEventHandler.handle(event, IScreenEventListener::onMouseClicked);
        }

        @SubscribeEvent
        public static void onMouseReleased(GuiScreenEvent.MouseReleasedEvent.Pre event) {
            NodeEventHandler.handle(event, IScreenEventListener::onMouseReleased);
        }

        @SubscribeEvent
        public static void onMouseDragged(GuiScreenEvent.MouseDragEvent.Pre event) {
            NodeEventHandler.handle(event, IScreenEventListener::onMouseDragged);
        }

        @SubscribeEvent
        public static void onMouseScrolled(GuiScreenEvent.MouseScrollEvent.Pre event) {
            NodeEventHandler.handle(event, IScreenEventListener::onMouseScrolled);
        }

        @SubscribeEvent
        public static void onKeyboardKeyPressed(GuiScreenEvent.KeyboardKeyPressedEvent.Pre event) {
            NodeEventHandler.handle(event, IScreenEventListener::onKeyPressed);
        }

        @SubscribeEvent
        public static void onKeyboardKeyReleased(GuiScreenEvent.KeyboardKeyReleasedEvent.Pre event) {
            NodeEventHandler.handle(event, IScreenEventListener::onKeyReleased);
        }

        @SubscribeEvent
        public static void onKeyboardCharTyped(GuiScreenEvent.KeyboardCharTypedEvent.Pre event) {
            NodeEventHandler.handle(event, IScreenEventListener::onCharTyped);
        }

        private static <T extends GuiScreenEvent> void handle(T event, BiConsumer<IScreenEventListener, T> eh) {
            Scene scene;
            if (event != null && event.getGui() instanceof Scene.GUAPIScreen && (scene = ((Scene.GUAPIScreen)event.getGui()).getScene()) != null && scene.getContent() != null) {
                NodeEventHandler.propagate(scene.getContent(), event, eh);
                event.setCanceled(true);
            }
        }

        private static <T extends GuiScreenEvent> void propagate(IScreenEventListener node, T event, BiConsumer<IScreenEventListener, T> eh) {
            eh.accept(node, (IScreenEventListener)event);
            if (node instanceof IParent) {
                ArrayList<? extends IScreenEventListener> list = new ArrayList<IScreenEventListener>(((IParent)((Object)node)).getChildren());
                for (IScreenEventListener iScreenEventListener : list) {
                    NodeEventHandler.propagate(iScreenEventListener, event, eh);
                }
            }
        }
    }
}

