/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.gui.IGuiView;
import com.google.common.collect.Lists;
import java.util.List;

public class Button
extends Node<GuiButtonView> {
    protected Button(GuiButtonView view) {
        super(view);
        this.computeSize();
        this.updateSize();
    }

    public Button(String text) {
        this(text, new String[0]);
    }

    public Button(String text, String ... tooltip) {
        this(new GuiButtonView(text, tooltip));
    }

    public Button() {
        this("Button");
    }

    public String getText() {
        return ((GuiButtonView)this.getView()).getMessage();
    }

    public void setText(String text) {
        ((GuiButtonView)this.getView()).setMessage(text);
        this.computeWidth();
        this.updateWidth();
    }

    public boolean isDisabled() {
        return !((GuiButtonView)this.getView()).active;
    }

    public void setDisabled(boolean disabled) {
        ((GuiButtonView)this.getView()).active = !disabled;
    }

    public List<String> getTooltipText() {
        return ((GuiButtonView)this.getView()).tooltipText;
    }

    @Override
    protected void computeWidth() {
        this.setComputedWidth(Button.mc.field_71466_p.func_78256_a(this.getText()) + this.getPadding().getVertical() + 10);
    }

    @Override
    protected void computeHeight() {
        this.setComputedHeight(20 + this.getPadding().getHorizontal());
    }

    public static class GuiButtonView
    extends net.minecraft.client.gui.widget.button.Button
    implements IGuiView {
        protected final List<String> tooltipText;

        public GuiButtonView(String text, String[] tooltip) {
            super(0, 0, 0, 0, text, b -> {});
            this.tooltipText = Lists.newArrayList((Object[])tooltip);
        }

        @Override
        public int getViewX() {
            return this.x;
        }

        @Override
        public void setViewX(int x) {
            this.x = x;
        }

        @Override
        public int getViewY() {
            return this.y;
        }

        @Override
        public void setViewY(int y) {
            this.y = y;
        }

        @Override
        public int getViewWidth() {
            return super.getWidth();
        }

        @Override
        public void setViewWidth(int width) {
            super.setWidth(width);
        }

        @Override
        public int getViewHeight() {
            return this.height;
        }

        @Override
        public void setViewHeight(int height) {
            this.height = height;
        }

        @Override
        public boolean isViewVisible() {
            return this.visible;
        }

        @Override
        public void setViewVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public void renderView(int mouseX, int mouseY, float partialTicks) {
            this.render(mouseX, mouseY, partialTicks);
            if (this.isHovered() && !this.tooltipText.isEmpty()) {
                IScreenEventListener.mc.field_71462_r.renderTooltip(this.tooltipText, mouseX, mouseY);
            }
        }
    }
}

