/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.guapi.node;

import com.github.franckyi.guapi.IScreenEventListener;
import com.github.franckyi.guapi.Node;
import com.github.franckyi.guapi.Scene;
import com.github.franckyi.guapi.node.Button;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class TexturedButton
extends Node<GuiGraphicButtonView> {
    public TexturedButton(String filename) {
        this(new ResourceLocation("ibeeditor", "textures/gui/" + filename));
    }

    public TexturedButton(String filename, String text) {
        this(new ResourceLocation("ibeeditor", "textures/gui/" + filename), text);
    }

    public TexturedButton(ResourceLocation texture) {
        this(texture, "");
        ((GuiGraphicButtonView)this.getView()).getText().clear();
    }

    public TexturedButton(ResourceLocation texture, int width, int height, int u, int v) {
        this(texture, width, height, u, v, "");
        ((GuiGraphicButtonView)this.getView()).getText().clear();
    }

    public TexturedButton(ResourceLocation texture, String text) {
        this(texture, 16, 16, 0, 0, text);
    }

    public TexturedButton(ResourceLocation texture, int width, int height, int u, int v, String text) {
        super(new GuiTexturedButtonView(texture, width, height, u, v, text));
        this.computeSize();
        this.updateSize();
    }

    public TexturedButton(ItemStack item) {
        this(item, true);
    }

    public TexturedButton(ItemStack item, boolean showTooltip) {
        super(new GuiItemTexturedButtonView(item, showTooltip));
        this.computeSize();
        this.updateSize();
    }

    public boolean isDisabled() {
        return !((GuiGraphicButtonView)this.getView()).active;
    }

    public void setDisabled(boolean disabled) {
        ((GuiGraphicButtonView)this.getView()).active = !disabled;
    }

    public List<String> getText() {
        return ((GuiGraphicButtonView)this.getView()).getText();
    }

    public List<String> getTooltipText() {
        return ((GuiGraphicButtonView)this.getView()).tooltipText;
    }

    @Override
    protected void computeWidth() {
        this.setComputedWidth(20);
    }

    @Override
    protected void computeHeight() {
        this.setComputedHeight(20);
    }

    private static class GuiItemTexturedButtonView
    extends GuiGraphicButtonView {
        private final ItemStack item;
        private final boolean showTooltip;
        private Scene.GUAPIScreen screen;

        public GuiItemTexturedButtonView(ItemStack item, boolean showTooltip) {
            super(new String[0]);
            this.item = item;
            this.showTooltip = showTooltip;
        }

        @Override
        public void renderView(int mouseX, int mouseY, float partialTicks) {
            super.renderView(mouseX, mouseY, partialTicks);
            if (this.visible) {
                int x = this.x + 2;
                int y = this.y + 2;
                IScreenEventListener.mc.func_175599_af().func_180450_b(this.item, x, y);
                IScreenEventListener.mc.func_175599_af().func_175030_a(IScreenEventListener.mc.field_71466_p, this.item, x, y);
                if (this.isHovered() && this.showTooltip) {
                    if (this.screen == null) {
                        this.screen = (Scene.GUAPIScreen)IScreenEventListener.mc.field_71462_r;
                    }
                    this.screen.renderTooltip(this.item, mouseX, mouseY);
                }
            }
        }
    }

    public static class GuiTexturedButtonView
    extends GuiGraphicButtonView {
        private ResourceLocation resource;
        private int u;
        private int v;
        private int textureWidth;
        private int textureHeight;
        private ResourceLocation texture;
        private boolean flag;

        public GuiTexturedButtonView(ResourceLocation resource, String ... text) {
            this(resource, 16, 16, 0, 0, text);
        }

        public GuiTexturedButtonView(ResourceLocation resource, int width, int height, int u, int v, String ... text) {
            super(text);
            this.setResource(resource);
            this.setTextureSize(width, height);
            this.setTexturePosition(u, v);
        }

        public ResourceLocation getResource() {
            return this.resource;
        }

        public void setResource(ResourceLocation resource) {
            if (!resource.equals((Object)this.resource)) {
                this.resource = resource;
                this.flag = true;
            }
        }

        public void setTexturePosition(int u, int v) {
            this.u = u;
            this.v = v;
        }

        public void setTextureSize(int width, int height) {
            this.textureWidth = width;
            this.textureHeight = height;
        }

        @Override
        public void renderView(int mouseX, int mouseY, float partialTicks) {
            super.render(mouseX, mouseY, partialTicks);
            if (this.visible) {
                if (this.flag) {
                    this.texture = this.loadTexture();
                    this.flag = false;
                }
                IScreenEventListener.mc.func_110434_K().func_110577_a(this.texture);
                this.drawModalRectWithCustomSizedTexture(this.x + 2, this.y + 2, this.u, this.v, 16, 16, this.textureWidth, this.textureHeight, 2.0);
                if (this.isHovered() && !this.tooltipText.isEmpty()) {
                    IScreenEventListener.mc.field_71462_r.renderTooltip(this.tooltipText, mouseX, mouseY);
                }
            }
        }

        private ResourceLocation loadTexture() {
            SimpleTexture tex = new SimpleTexture(this.resource);
            try {
                tex.func_195413_a(IScreenEventListener.mc.func_195551_G());
                return this.resource;
            }
            catch (IOException e) {
                return TextureManager.field_194008_a;
            }
        }

        private void drawModalRectWithCustomSizedTexture(int x, int y, float u, float v, int width, int height, float textureWidth, float textureHeight, double zLevel) {
            float f = 1.0f / textureWidth;
            float f1 = 1.0f / textureHeight;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexbuffer.func_225582_a_((double)x, (double)(y + height), zLevel).func_225583_a_(u * f, (v + (float)height) * f1).func_181675_d();
            vertexbuffer.func_225582_a_((double)(x + width), (double)(y + height), zLevel).func_225583_a_((u + (float)width) * f, (v + (float)height) * f1).func_181675_d();
            vertexbuffer.func_225582_a_((double)(x + width), (double)y, zLevel).func_225583_a_((u + (float)width) * f, v * f1).func_181675_d();
            vertexbuffer.func_225582_a_((double)x, (double)y, zLevel).func_225583_a_(u * f, v * f1).func_181675_d();
            tessellator.func_78381_a();
        }

        @Override
        public List<String> getText() {
            return this.tooltipText;
        }
    }

    public static abstract class GuiGraphicButtonView
    extends Button.GuiButtonView {
        public GuiGraphicButtonView(String ... text) {
            super("", text);
        }

        public List<String> getText() {
            return Collections.emptyList();
        }
    }
}

