/*
 * Decompiled with CFR 0.152.
 */
package com.github.franckyi.ibeeditor;

import com.github.franckyi.ibeeditor.IBEEditorMod;
import com.github.franckyi.ibeeditor.common.network.IBENetworkHandler;
import com.github.franckyi.ibeeditor.common.network.editor.OpenEditorMessage;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.network.NetworkDirection;

public class IBECommand {
    private static final ITextComponent DOWNLOAD_LINK = new StringTextComponent("Click here to download the mod !").func_150255_a(new Style().func_150228_d(Boolean.valueOf(true)).func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.BLUE).func_150241_a(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/ibe-editor")));
    private static final ITextComponent MUST_INSTALL = new StringTextComponent(TextFormatting.RED + "You must install the IBE Editor mod to use this command.");
    private static final ITextComponent PLAYER_ONLY = new StringTextComponent(TextFormatting.RED + "This command can only be executed by a player");
    private static Set<UUID> allowedPlayers = new HashSet<UUID>();

    static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register(IBECommand.getCommand());
    }

    private static LiteralArgumentBuilder<CommandSource> getCommand() {
        LiteralArgumentBuilder ibe = (LiteralArgumentBuilder)Commands.func_197057_a((String)"ibe").executes(ctx -> IBECommand.execute((CommandContext<CommandSource>)ctx, EditorArgument.ANY));
        for (EditorArgument argument : EditorArgument.values()) {
            if (argument == EditorArgument.ANY) continue;
            ibe.then(Commands.func_197057_a((String)argument.toString()).executes(ctx -> IBECommand.execute0((CommandContext<CommandSource>)ctx, argument)));
        }
        return ibe;
    }

    private static int execute0(CommandContext<CommandSource> ctx, EditorArgument argument) {
        if (argument != EditorArgument.ANY) {
            return IBECommand.execute(ctx, argument);
        }
        return 1;
    }

    private static int execute(CommandContext<CommandSource> ctx, EditorArgument argument) {
        try {
            if (!allowedPlayers.contains(((CommandSource)ctx.getSource()).func_197035_h().func_110124_au())) {
                ((CommandSource)ctx.getSource()).func_197021_a(MUST_INSTALL);
                ((CommandSource)ctx.getSource()).func_197021_a(DOWNLOAD_LINK);
                IBEEditorMod.LOGGER.debug(((CommandSource)ctx.getSource()).func_197035_h().func_200200_C_().func_150261_e() + " tried to open the editor without having the client mod installed.");
                return 0;
            }
            IBENetworkHandler.getModChannel().sendTo((Object)new OpenEditorMessage(argument), ((CommandSource)ctx.getSource()).func_197035_h().field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
        catch (CommandSyntaxException e) {
            ((CommandSource)ctx.getSource()).func_197021_a(PLAYER_ONLY);
            IBEEditorMod.LOGGER.debug(ctx.getSource() + " tried to eopen the editor, but it's not a player.");
            return 0;
        }
        return 1;
    }

    public static void addAllowedPlayer(PlayerEntity player) {
        if (allowedPlayers.add(player.func_110124_au())) {
            IBEEditorMod.LOGGER.debug("Adding " + player.func_200200_C_().func_150261_e() + " to allowed players list.");
        }
    }

    public static void removeAllowedPlayer(PlayerEntity player) {
        if (allowedPlayers.remove(player.func_110124_au())) {
            IBEEditorMod.LOGGER.debug("Removing " + player.func_200200_C_().func_150261_e() + " from allowed players list.");
        }
    }

    public static enum EditorArgument {
        ANY("any"),
        ITEM("item"),
        BLOCK("block"),
        ENTITY("entity"),
        SELF("self");

        private final String str;

        private EditorArgument(String str) {
            this.str = str;
        }

        public String toString() {
            return this.str;
        }
    }
}

